/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jms;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.jms.MessageBatchState;
import datadog.trace.bootstrap.instrumentation.jms.TimeInQueue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class SessionState {
    private static final AtomicReferenceFieldUpdater<SessionState, MessageBatchState> BATCH_STATE = AtomicReferenceFieldUpdater.newUpdater(SessionState.class, MessageBatchState.class, "batchState");
    private static final AtomicIntegerFieldUpdater<SessionState> COMMIT_SEQUENCE = AtomicIntegerFieldUpdater.newUpdater(SessionState.class, "commitSequence");
    private static final AtomicIntegerFieldUpdater<SessionState> TIME_IN_QUEUE_SPAN_COUNT = AtomicIntegerFieldUpdater.newUpdater(SessionState.class, "timeInQueueSpanCount");
    private static final Comparator<Map.Entry<Thread, TimeInQueue>> YOUNGEST_TIME_IN_QUEUE_FIRST = new Comparator<Map.Entry<Thread, TimeInQueue>>(){

        @Override
        public int compare(Map.Entry<Thread, TimeInQueue> o1, Map.Entry<Thread, TimeInQueue> o2) {
            return Long.compare(o2.getValue().span.getStartTime(), o1.getValue().span.getStartTime());
        }
    };
    static final int MAX_CAPTURED_SPANS = 8192;
    private static final int MAX_TRACKED_THREADS = 100;
    private static final int MIN_EVICTED_THREADS = 10;
    private final int ackMode;
    private volatile MessageBatchState batchState;
    private volatile int commitSequence;
    private final Deque<AgentSpan> capturedSpans;
    private final Map<Thread, TimeInQueue> timeInQueueSpans;
    private volatile int timeInQueueSpanCount = 0;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    private boolean capturingFlipped = false;

    public SessionState(int ackMode, boolean legacyTracing) {
        this.ackMode = ackMode;
        this.capturedSpans = this.isAutoAcknowledge() ? null : new ArrayDeque<AgentSpan>();
        this.timeInQueueSpans = legacyTracing ? Collections.emptyMap() : new ConcurrentHashMap<Thread, TimeInQueue>();
    }

    public boolean isTransactedSession() {
        return this.ackMode == 0;
    }

    public boolean isClientAcknowledge() {
        return this.ackMode == 2;
    }

    public boolean isAutoAcknowledge() {
        return this.ackMode != 0 && this.ackMode != 2;
    }

    MessageBatchState currentBatchState() {
        MessageBatchState oldBatch = this.batchState;
        if (null != oldBatch && oldBatch.commitSequence == this.commitSequence) {
            return oldBatch;
        }
        MessageBatchState newBatch = new MessageBatchState(this.commitSequence);
        if (!BATCH_STATE.compareAndSet(this, oldBatch, newBatch)) {
            newBatch = this.batchState;
        }
        return newBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCapturedSpanCount() {
        if (null == this.capturedSpans) {
            return 0;
        }
        Deque<AgentSpan> deque = this.capturedSpans;
        synchronized (deque) {
            return this.capturedSpans.size();
        }
    }

    public void finishOnAcknowledge(AgentSpan span) {
        this.captureMessageSpan(span);
    }

    public void finishOnCommit(AgentSpan span) {
        this.captureMessageSpan(span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureMessageSpan(AgentSpan span) {
        if (null != this.capturedSpans) {
            Deque<AgentSpan> deque = this.capturedSpans;
            synchronized (deque) {
                if (this.capturedSpans.size() < 8192) {
                    if (this.capturingFlipped) {
                        this.capturedSpans.addFirst(span);
                    } else {
                        this.capturedSpans.addLast(span);
                    }
                    return;
                }
            }
        }
        span.finish();
    }

    public void onAcknowledgeOrRecover() {
        this.finishSessionSpans();
    }

    public void onCommitOrRollback() {
        COMMIT_SEQUENCE.incrementAndGet(this);
        this.finishSessionSpans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSessionSpans() {
        SessionState sessionState = this;
        synchronized (sessionState) {
            Iterator<TimeInQueue> timeInQueueIterator = this.timeInQueueSpans.values().iterator();
            if (null != this.capturedSpans) {
                this.finishCapturedSpans();
            }
            while (timeInQueueIterator.hasNext()) {
                this.maybeFinishTimeInQueueSpan(timeInQueueIterator.next());
                timeInQueueIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCapturedSpans() {
        boolean finishingFlipped;
        int spansToFinish;
        Deque<AgentSpan> deque = this.capturedSpans;
        synchronized (deque) {
            spansToFinish = this.capturedSpans.size();
            finishingFlipped = this.capturingFlipped;
            this.capturingFlipped = !finishingFlipped;
        }
        for (int i = 0; i < spansToFinish; ++i) {
            AgentSpan span;
            Deque<AgentSpan> deque2 = this.capturedSpans;
            synchronized (deque2) {
                span = finishingFlipped ? this.capturedSpans.pollFirst() : this.capturedSpans.pollLast();
            }
            if (null == span) continue;
            span.finish();
        }
    }

    public void onClose() {
        this.finishSessionSpans();
    }

    AgentSpan getTimeInQueueSpan(long batchId) {
        TimeInQueue holder = this.timeInQueueSpans.get(Thread.currentThread());
        if (null != holder) {
            if (batchId > 0L && batchId == holder.batchId || !this.isAutoAcknowledge()) {
                return holder.span;
            }
            this.finishTimeInQueueSpan(true);
        }
        return null;
    }

    void setTimeInQueueSpan(long batchId, AgentSpan span) {
        if (TIME_IN_QUEUE_SPAN_COUNT.incrementAndGet(this) > 100) {
            this.finishStaleTimeInQueueSpans();
        }
        this.timeInQueueSpans.put(Thread.currentThread(), new TimeInQueue(batchId, span));
    }

    void finishTimeInQueueSpan(boolean clear) {
        if (clear) {
            this.maybeFinishTimeInQueueSpan(this.timeInQueueSpans.remove(Thread.currentThread()));
        } else {
            TimeInQueue holder = this.timeInQueueSpans.get(Thread.currentThread());
            if (null != holder) {
                holder.span.finish();
            }
        }
    }

    private void maybeFinishTimeInQueueSpan(TimeInQueue holder) {
        if (null != holder) {
            TIME_IN_QUEUE_SPAN_COUNT.decrementAndGet(this);
            holder.span.finish();
        }
    }

    private void finishStaleTimeInQueueSpans() {
        PriorityQueue<Map.Entry<Thread, TimeInQueue>> oldestEntries = new PriorityQueue<Map.Entry<Thread, TimeInQueue>>(11, YOUNGEST_TIME_IN_QUEUE_FIRST);
        int evictedThreads = 0;
        Iterator<Map.Entry<Thread, TimeInQueue>> itr = this.timeInQueueSpans.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Thread, TimeInQueue> entry = itr.next();
            if (!entry.getKey().isAlive()) {
                ++evictedThreads;
                this.maybeFinishTimeInQueueSpan(entry.getValue());
                itr.remove();
                continue;
            }
            if (evictedThreads >= 10) continue;
            oldestEntries.offer(entry);
            if (oldestEntries.size() <= 10) continue;
            oldestEntries.poll();
        }
        if (evictedThreads < 10) {
            for (Map.Entry entry : oldestEntries) {
                if (!((ConcurrentMap)this.timeInQueueSpans).remove(entry.getKey(), entry.getValue())) continue;
                this.maybeFinishTimeInQueueSpan((TimeInQueue)entry.getValue());
            }
        }
    }
}

