/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.ComparableRunnable;
import datadog.trace.bootstrap.instrumentation.java.concurrent.ExcludeFilter;
import java.util.concurrent.RunnableFuture;

public class Wrapper<T extends Runnable>
implements Runnable,
AutoCloseable {
    protected final T delegate;
    private final AgentScope.Continuation continuation;

    public static <T extends Runnable> Runnable wrap(T task) {
        if (task instanceof Wrapper || task instanceof RunnableFuture || task == null || ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            return task;
        }
        AgentScope scope = AgentTracer.activeScope();
        if (null != scope) {
            if (task instanceof Comparable) {
                return new ComparableRunnable<T>(task, scope.capture());
            }
            return new Wrapper<T>(task, scope.capture());
        }
        return task;
    }

    public static Runnable unwrap(Runnable task) {
        return task instanceof Wrapper ? ((Wrapper)task).unwrap() : task;
    }

    public Wrapper(T delegate, AgentScope.Continuation continuation) {
        this.delegate = delegate;
        this.continuation = continuation;
    }

    @Override
    public void run() {
        try (AgentScope scope = this.activate();){
            this.delegate.run();
        }
    }

    public void cancel() {
        if (null != this.continuation) {
            this.continuation.cancel();
        }
    }

    public T unwrap() {
        return this.delegate;
    }

    private AgentScope activate() {
        return null == this.continuation ? null : this.continuation.activate();
    }

    @Override
    public void close() throws Exception {
        this.cancel();
        if (this.delegate instanceof AutoCloseable) {
            ((AutoCloseable)this.delegate).close();
        }
    }
}

