/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.sslsocket;

import datadog.trace.bootstrap.instrumentation.usm.UsmConnection;
import datadog.trace.bootstrap.instrumentation.usm.UsmExtractor;
import datadog.trace.bootstrap.instrumentation.usm.UsmMessage;
import datadog.trace.bootstrap.instrumentation.usm.UsmMessageFactory;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLSocket;

public class UsmFilterInputStream
extends FilterInputStream {
    private final SSLSocket socket;

    public UsmFilterInputStream(InputStream in, SSLSocket socket) {
        super(in);
        this.socket = socket;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        boolean isIPv6 = this.socket.getLocalAddress() instanceof Inet6Address;
        UsmConnection connection = new UsmConnection(this.socket.getLocalAddress(), this.socket.getLocalPort(), this.socket.getInetAddress(), this.socket.getPort(), isIPv6);
        UsmMessage message = UsmMessageFactory.Supplier.getRequestMessage(connection, b, off, len);
        UsmExtractor.Supplier.send(message);
        return bytesRead;
    }
}

