/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util.stacktrace;

import datadog.trace.api.Platform;
import datadog.trace.util.stacktrace.AbstractStackWalker;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.function.Function;
import java.util.stream.Stream;

@SuppressForbidden
public class JDK9StackWalker
extends AbstractStackWalker {
    private static final StackWalker walker = JDK9StackWalker.newStackWalker();
    private static final StackMapper mapper = JDK9StackWalker.findMapper();

    @Override
    public boolean isEnabled() {
        return walker != null && mapper != null;
    }

    @Override
    <T> T doGetStack(Function<Stream<StackTraceElement>, T> consumer) {
        return (T)walker.walk((? super Stream<StackWalker.StackFrame> stack) -> consumer.apply(stack.map(mapper)));
    }

    private static StackTraceElement mapFrameForJ9(StackWalker.StackFrame frame) {
        return new StackTraceElement(frame.getClassName(), frame.getMethodName(), frame.getFileName(), frame.getLineNumber());
    }

    private static StackWalker newStackWalker() {
        try {
            return StackWalker.getInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static StackMapper findMapper() {
        try {
            return Platform.isJ9() ? JDK9StackWalker::mapFrameForJ9 : StackWalker.StackFrame::toStackTraceElement;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static interface StackMapper
    extends Function<StackWalker.StackFrame, StackTraceElement> {
    }
}

