/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.internal.util.LongStringUtils;
import java.util.Locale;

public class DD128bTraceId
extends DDTraceId {
    public static final DD128bTraceId ZERO = new DD128bTraceId(0L, 0L, "00000000000000000000000000000000");
    private final long highOrderBits;
    private final long lowOrderBits;
    private String hexStr;
    private String str;

    private DD128bTraceId(long highOrderBits, long leastSigBits, String hexStr) {
        this.highOrderBits = highOrderBits;
        this.lowOrderBits = leastSigBits;
        this.hexStr = hexStr;
    }

    public static DD128bTraceId from(long highOrderBits, long lowOrderBits) {
        return new DD128bTraceId(highOrderBits, lowOrderBits, null);
    }

    public static DD128bTraceId fromHex(String s) throws NumberFormatException {
        return DD128bTraceId.fromHex(s, 0, s == null ? 0 : s.length(), true);
    }

    public static DD128bTraceId fromHex(String s, int start, int length, boolean lowerCaseOnly) throws NumberFormatException {
        long lowOrderBits;
        long highOrderBits;
        if (s == null) {
            throw new NumberFormatException("s can't be null");
        }
        int stringLength = s.length();
        if (start < 0 || length <= 0 || length > 32 || start + length > stringLength) {
            throw new NumberFormatException("Illegal start or length");
        }
        if (length > 16) {
            int highOrderLength = length - 16;
            highOrderBits = LongStringUtils.parseUnsignedLongHex(s, start, highOrderLength, lowerCaseOnly);
            lowOrderBits = LongStringUtils.parseUnsignedLongHex(s, start + highOrderLength, 16, lowerCaseOnly);
        } else {
            highOrderBits = 0L;
            lowOrderBits = LongStringUtils.parseUnsignedLongHex(s, start, length, lowerCaseOnly);
        }
        String hexStr = null;
        if (length == 32) {
            hexStr = start == 0 ? s : s.substring(start, start + 32);
            if (!lowerCaseOnly) {
                hexStr = hexStr.toLowerCase(Locale.ROOT);
            }
        }
        return new DD128bTraceId(highOrderBits, lowOrderBits, hexStr);
    }

    @Override
    public String toHexString() {
        String hexString = this.hexStr;
        if (hexString == null) {
            this.hexStr = hexString = LongStringUtils.toHexStringPadded(this.highOrderBits, this.lowOrderBits, 32);
        }
        return hexString;
    }

    @Override
    public String toHexStringPadded(int size) {
        if (size <= 16) {
            return LongStringUtils.toHexStringPadded(this.lowOrderBits, 16);
        }
        return this.toHexString();
    }

    @Override
    public long toLong() {
        return this.lowOrderBits;
    }

    @Override
    public long toHighOrderLong() {
        return this.highOrderBits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DD128bTraceId)) {
            return false;
        }
        DD128bTraceId ddId = (DD128bTraceId)o;
        return this.highOrderBits == ddId.highOrderBits && this.lowOrderBits == ddId.lowOrderBits;
    }

    public int hashCode() {
        return (int)(this.highOrderBits ^ this.highOrderBits >>> 32 ^ this.lowOrderBits ^ this.lowOrderBits >>> 32);
    }

    @Override
    public String toString() {
        String s = this.str;
        if (s == null) {
            this.str = s = Long.toUnsignedString(this.lowOrderBits);
        }
        return s;
    }
}

