/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.civisibility.config;

import datadog.trace.api.civisibility.config.EarlyFlakeDetectionSettings;
import datadog.trace.api.civisibility.config.TestIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ModuleExecutionSettings {
    public static final ModuleExecutionSettings EMPTY = new ModuleExecutionSettings(false, false, false, false, EarlyFlakeDetectionSettings.DEFAULT, Collections.emptyMap(), null, Collections.emptyMap(), Collections.emptyList(), null, Collections.emptyList());
    private final boolean itrEnabled;
    private final boolean codeCoverageEnabled;
    private final boolean testSkippingEnabled;
    private final boolean flakyTestRetriesEnabled;
    private final EarlyFlakeDetectionSettings earlyFlakeDetectionSettings;
    private final Map<String, String> systemProperties;
    private final String itrCorrelationId;
    private final Map<String, Collection<TestIdentifier>> skippableTestsByModule;
    @Nullable
    private final Collection<TestIdentifier> flakyTests;
    @Nullable
    private final Map<String, Collection<TestIdentifier>> knownTestsByModule;
    private final List<String> coverageEnabledPackages;

    public ModuleExecutionSettings(boolean itrEnabled, boolean codeCoverageEnabled, boolean testSkippingEnabled, boolean flakyTestRetriesEnabled, EarlyFlakeDetectionSettings earlyFlakeDetectionSettings, Map<String, String> systemProperties, String itrCorrelationId, Map<String, Collection<TestIdentifier>> skippableTestsByModule, Collection<TestIdentifier> flakyTests, Map<String, Collection<TestIdentifier>> knownTestsByModule, List<String> coverageEnabledPackages) {
        this.itrEnabled = itrEnabled;
        this.codeCoverageEnabled = codeCoverageEnabled;
        this.testSkippingEnabled = testSkippingEnabled;
        this.flakyTestRetriesEnabled = flakyTestRetriesEnabled;
        this.earlyFlakeDetectionSettings = earlyFlakeDetectionSettings;
        this.systemProperties = systemProperties;
        this.itrCorrelationId = itrCorrelationId;
        this.skippableTestsByModule = skippableTestsByModule;
        this.flakyTests = flakyTests;
        this.knownTestsByModule = knownTestsByModule;
        this.coverageEnabledPackages = coverageEnabledPackages;
    }

    public boolean isItrEnabled() {
        return this.itrEnabled;
    }

    public boolean isCodeCoverageEnabled() {
        return this.codeCoverageEnabled;
    }

    public boolean isTestSkippingEnabled() {
        return this.testSkippingEnabled;
    }

    public boolean isFlakyTestRetriesEnabled() {
        return this.flakyTestRetriesEnabled;
    }

    public EarlyFlakeDetectionSettings getEarlyFlakeDetectionSettings() {
        return this.earlyFlakeDetectionSettings;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Nullable
    public String getItrCorrelationId() {
        return this.itrCorrelationId;
    }

    public Map<String, Collection<TestIdentifier>> getSkippableTestsByModule() {
        return this.skippableTestsByModule;
    }

    public Collection<TestIdentifier> getFlakyTests() {
        return this.flakyTests;
    }

    @Nullable
    public Map<String, Collection<TestIdentifier>> getKnownTestsByModule() {
        return this.knownTestsByModule;
    }

    public Collection<TestIdentifier> getSkippableTests(String moduleName) {
        return this.skippableTestsByModule.getOrDefault(moduleName, Collections.emptyList());
    }

    @Nullable
    public Collection<TestIdentifier> getFlakyTests(String moduleName) {
        return this.flakyTests;
    }

    @Nullable
    public Collection<TestIdentifier> getKnownTests(String moduleName) {
        return this.knownTestsByModule != null ? (Collection)this.knownTestsByModule.getOrDefault(moduleName, Collections.emptyList()) : null;
    }

    public List<String> getCoverageEnabledPackages() {
        return this.coverageEnabledPackages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleExecutionSettings that = (ModuleExecutionSettings)o;
        return this.itrEnabled == that.itrEnabled && this.codeCoverageEnabled == that.codeCoverageEnabled && this.testSkippingEnabled == that.testSkippingEnabled && Objects.equals(this.earlyFlakeDetectionSettings, that.earlyFlakeDetectionSettings) && Objects.equals(this.systemProperties, that.systemProperties) && Objects.equals(this.itrCorrelationId, that.itrCorrelationId) && Objects.equals(this.skippableTestsByModule, that.skippableTestsByModule) && Objects.equals(this.flakyTests, that.flakyTests) && Objects.equals(this.knownTestsByModule, that.knownTestsByModule) && Objects.equals(this.coverageEnabledPackages, that.coverageEnabledPackages);
    }

    public int hashCode() {
        return Objects.hash(this.itrEnabled, this.codeCoverageEnabled, this.testSkippingEnabled, this.earlyFlakeDetectionSettings, this.systemProperties, this.itrCorrelationId, this.skippableTestsByModule, this.flakyTests, this.knownTestsByModule, this.coverageEnabledPackages);
    }
}

