/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import datadog.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TagContext
implements AgentSpan.Context.Extracted {
    private static final HttpHeaders EMPTY_HTTP_HEADERS = new HttpHeaders();
    private final CharSequence origin;
    private Map<String, String> tags;
    private List<AgentSpanLink> terminatedContextLinks;
    private Object requestContextDataAppSec;
    private Object requestContextDataIast;
    private Object ciVisibilityContextData;
    private PathwayContext pathwayContext;
    private final HttpHeaders httpHeaders;
    private final Map<String, String> baggage;
    private final int samplingPriority;
    private final TraceConfig traceConfig;
    private final TracePropagationStyle propagationStyle;

    public TagContext() {
        this(null, null);
    }

    public TagContext(String origin, Map<String, String> tags) {
        this(origin, tags, null, null, -128, null, TracePropagationStyle.NONE);
    }

    public TagContext(CharSequence origin, Map<String, String> tags, HttpHeaders httpHeaders, Map<String, String> baggage, int samplingPriority, TraceConfig traceConfig, TracePropagationStyle propagationStyle) {
        this.origin = origin;
        this.tags = tags;
        this.terminatedContextLinks = null;
        this.httpHeaders = httpHeaders == null ? EMPTY_HTTP_HEADERS : httpHeaders;
        this.baggage = baggage == null ? Collections.emptyMap() : baggage;
        this.samplingPriority = samplingPriority;
        this.traceConfig = traceConfig;
        this.propagationStyle = propagationStyle;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }

    public TracePropagationStyle getPropagationStyle() {
        return this.propagationStyle;
    }

    public final CharSequence getOrigin() {
        return this.origin;
    }

    @Override
    public List<AgentSpanLink> getTerminatedContextLinks() {
        return this.terminatedContextLinks == null ? Collections.emptyList() : this.terminatedContextLinks;
    }

    public void addTerminatedContextLink(AgentSpanLink link) {
        if (this.terminatedContextLinks == null) {
            this.terminatedContextLinks = new ArrayList<AgentSpanLink>();
        }
        this.terminatedContextLinks.add(link);
    }

    @Override
    public String getForwarded() {
        return this.httpHeaders.forwarded;
    }

    @Override
    public String getFastlyClientIp() {
        return this.httpHeaders.fastlyClientIp;
    }

    @Override
    public String getCfConnectingIp() {
        return this.httpHeaders.cfConnectingIp;
    }

    @Override
    public String getCfConnectingIpv6() {
        return this.httpHeaders.cfConnectingIpv6;
    }

    @Override
    public String getXForwardedProto() {
        return this.httpHeaders.xForwardedProto;
    }

    @Override
    public String getXForwardedHost() {
        return this.httpHeaders.xForwardedHost;
    }

    @Override
    public String getXForwardedPort() {
        return this.httpHeaders.xForwardedPort;
    }

    @Override
    public String getForwardedFor() {
        return this.httpHeaders.forwardedFor;
    }

    @Override
    public String getXForwarded() {
        return this.httpHeaders.xForwarded;
    }

    @Override
    public String getXForwardedFor() {
        return this.httpHeaders.xForwardedFor;
    }

    @Override
    public String getXClusterClientIp() {
        return this.httpHeaders.xClusterClientIp;
    }

    @Override
    public String getXRealIp() {
        return this.httpHeaders.xRealIp;
    }

    @Override
    public String getXClientIp() {
        return this.httpHeaders.xClientIp;
    }

    @Override
    public String getUserAgent() {
        return this.httpHeaders.userAgent;
    }

    @Override
    public String getTrueClientIp() {
        return this.httpHeaders.trueClientIp;
    }

    @Override
    public String getCustomIpHeader() {
        return this.httpHeaders.customIpHeader;
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public void putTag(String key, String value) {
        if (this.tags.isEmpty()) {
            this.tags = new TreeMap<String, String>();
        }
        this.tags.put(key, value);
    }

    @Override
    public final int getSamplingPriority() {
        return this.samplingPriority;
    }

    public final Map<String, String> getBaggage() {
        return this.baggage;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    @Override
    public DDTraceId getTraceId() {
        return DDTraceId.ZERO;
    }

    @Override
    public long getSpanId() {
        return 0L;
    }

    @Override
    public final AgentTraceCollector getTraceCollector() {
        return AgentTracer.NoopAgentTraceCollector.INSTANCE;
    }

    public final Object getRequestContextDataAppSec() {
        return this.requestContextDataAppSec;
    }

    public final TagContext withRequestContextDataAppSec(Object requestContextData) {
        this.requestContextDataAppSec = requestContextData;
        return this;
    }

    public final Object getRequestContextDataIast() {
        return this.requestContextDataIast;
    }

    public final TagContext withRequestContextDataIast(Object requestContextData) {
        this.requestContextDataIast = requestContextData;
        return this;
    }

    public Object getCiVisibilityContextData() {
        return this.ciVisibilityContextData;
    }

    public TagContext withCiVisibilityContextData(Object ciVisibilityContextData) {
        this.ciVisibilityContextData = ciVisibilityContextData;
        return this;
    }

    @Override
    public PathwayContext getPathwayContext() {
        return this.pathwayContext;
    }

    public TagContext withPathwayContext(PathwayContext pathwayContext) {
        this.pathwayContext = pathwayContext;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TagContext{");
        if (this.origin != null) {
            builder.append("origin=").append(this.origin).append(", ");
        }
        if (this.tags != null) {
            builder.append("tags=").append(this.tags).append(", ");
        }
        if (this.baggage != null) {
            builder.append("baggage=").append(this.baggage).append(", ");
        }
        if (this.samplingPriority != -128) {
            builder.append("samplingPriority=").append(this.samplingPriority).append(", ");
        }
        return builder.append('}').toString();
    }

    public static class HttpHeaders {
        public String fastlyClientIp;
        public String cfConnectingIp;
        public String cfConnectingIpv6;
        public String xForwarded;
        public String forwarded;
        public String xForwardedProto;
        public String xForwardedHost;
        public String xForwardedPort;
        public String xForwardedFor;
        public String forwardedFor;
        public String xClusterClientIp;
        public String xRealIp;
        public String xClientIp;
        public String userAgent;
        public String trueClientIp;
        public String customIpHeader;
    }
}

