/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.UserIdCollectionMode;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.api.telemetry.LogCollector;
import datadog.trace.api.telemetry.WafMetricCollector;
import datadog.trace.bootstrap.ActiveSubsystems;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.util.Strings;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public class AppSecUserEventDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSecUserEventDecorator.class);
    private static final int HASH_SIZE_BYTES = 16;
    private static final String ANONYM_PREFIX = "anon_";
    private static final AtomicBoolean SHA_MISSING_REPORTED = new AtomicBoolean(false);

    public boolean isEnabled() {
        if (!ActiveSubsystems.APPSEC_ACTIVE) {
            return false;
        }
        return this.getUserIdCollectionMode() != UserIdCollectionMode.DISABLED;
    }

    public void onUserNotFound() {
        TraceSegment segment = this.beforeEvent();
        if (segment == null) {
            return;
        }
        segment.setTagTop("appsec.events.users.login.failure.usr.exists", false);
    }

    public void onLoginSuccess(String userId, Map<String, String> metadata) {
        TraceSegment segment = this.beforeEvent(userId);
        if (segment == null) {
            return;
        }
        this.onUserId(segment, "usr.id", userId);
        this.onEvent(segment, "users.login.success", metadata);
    }

    public void onLoginFailure(String userId, Map<String, String> metadata) {
        TraceSegment segment = this.beforeEvent(userId);
        if (segment == null) {
            return;
        }
        this.onUserId(segment, "appsec.events.users.login.failure.usr.id", userId);
        this.onEvent(segment, "users.login.failure", metadata);
    }

    public void onSignup(String userId, Map<String, String> metadata) {
        TraceSegment segment = this.beforeEvent(userId);
        if (segment == null) {
            return;
        }
        this.onUserId(segment, "usr.id", userId);
        this.onEvent(segment, "users.signup", metadata);
    }

    private TraceSegment beforeEvent() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getSegment();
    }

    private TraceSegment beforeEvent(String userId) {
        if (userId == null) {
            this.onMissingUserId();
            return null;
        }
        return this.beforeEvent();
    }

    private void onEvent(@Nonnull TraceSegment segment, String eventName, Map<String, String> tags) {
        segment.setTagTop("appsec.events." + eventName + ".track", true, true);
        segment.setTagTop("asm.keep", true);
        segment.setTagTop("_dd.p.appsec", true);
        UserIdCollectionMode mode = this.getUserIdCollectionMode();
        if (mode != UserIdCollectionMode.DISABLED) {
            segment.setTagTop("_dd.appsec.events." + eventName + ".auto.mode", mode.toString());
        }
        if (tags != null && !tags.isEmpty()) {
            segment.setTagTop("appsec.events." + eventName, tags);
        }
    }

    protected void onUserId(TraceSegment segment, String tagName, String userId) {
        if (segment.getTagTop(tagName) != null) {
            return;
        }
        String finalUserId = this.getUserIdCollectionMode() == UserIdCollectionMode.ANONYMIZATION ? AppSecUserEventDecorator.anonymize(userId) : userId;
        segment.setTagTop(tagName, finalUserId);
    }

    protected static String anonymize(String userId) {
        MessageDigest digest;
        if (userId == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            if (!SHA_MISSING_REPORTED.getAndSet(true)) {
                LOGGER.error(LogCollector.SEND_TELEMETRY, "Missing SHA-256 digest, user collection in 'anon' mode cannot continue", e);
            }
            return null;
        }
        digest.update(userId.getBytes());
        byte[] hash = digest.digest();
        if (hash.length > 16) {
            byte[] temp = new byte[16];
            System.arraycopy(hash, 0, temp, 0, temp.length);
            hash = temp;
        }
        return ANONYM_PREFIX + Strings.toHexString(hash);
    }

    protected TraceSegment getSegment() {
        return AgentTracer.get().getTraceSegment();
    }

    protected void onMissingUserId() {
        WafMetricCollector.get().missingUserId();
    }

    protected UserIdCollectionMode getUserIdCollectionMode() {
        return UserIdCollectionMode.get();
    }
}

