/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.BaseDecorator;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;

public abstract class AsyncResultDecorator
extends BaseDecorator {
    private static final CopyOnWriteArrayList<AsyncResultSupportExtension> EXTENSIONS = new CopyOnWriteArrayList<JavaUtilConcurrentAsyncResultSupportExtension>(Collections.singletonList(new JavaUtilConcurrentAsyncResultSupportExtension()));
    private static final ClassValue<AsyncResultSupportExtension> EXTENSION_CLASS_VALUE = new ClassValue<AsyncResultSupportExtension>(){

        @Override
        protected AsyncResultSupportExtension computeValue(Class<?> type) {
            return EXTENSIONS.stream().filter(extension -> extension.supports(type)).findFirst().orElse(null);
        }
    };

    public static void registerExtension(AsyncResultSupportExtension extension) {
        if (extension != null) {
            EXTENSIONS.add(extension);
        }
    }

    public Object wrapAsyncResultOrFinishSpan(Object result, AgentSpan span) {
        Object applied;
        AsyncResultSupportExtension extension;
        if (result != null && (extension = EXTENSION_CLASS_VALUE.get(result.getClass())) != null && (applied = extension.apply(result, span)) != null) {
            return applied;
        }
        span.finish();
        return result;
    }

    private static class JavaUtilConcurrentAsyncResultSupportExtension
    implements AsyncResultSupportExtension {
        private JavaUtilConcurrentAsyncResultSupportExtension() {
        }

        @Override
        public boolean supports(Class<?> result) {
            return CompletableFuture.class.isAssignableFrom(result) || CompletionStage.class.isAssignableFrom(result);
        }

        @Override
        public Object apply(Object result, AgentSpan span) {
            if (result instanceof CompletableFuture) {
                CompletableFuture completableFuture = (CompletableFuture)result;
                if (!completableFuture.isDone() && !completableFuture.isCancelled()) {
                    return completableFuture.whenComplete(this.finishSpan(span));
                }
            } else if (result instanceof CompletionStage) {
                CompletionStage completionStage = (CompletionStage)result;
                return completionStage.whenComplete(this.finishSpan(span));
            }
            return null;
        }

        private <T> BiConsumer<T, Throwable> finishSpan(AgentSpan span) {
            return (o, throwable) -> {
                if (throwable != null) {
                    span.addThrowable(throwable instanceof ExecutionException || throwable instanceof CompletionException ? throwable.getCause() : throwable);
                }
                span.finish();
            };
        }
    }

    public static interface AsyncResultSupportExtension {
        public boolean supports(Class<?> var1);

        public Object apply(Object var1, AgentSpan var2);
    }
}

