/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.State;

public class AdviceUtils {
    public static <T> AgentScope startTaskScope(ContextStore<T, State> contextStore, T task) {
        return AdviceUtils.startTaskScope(contextStore.get(task));
    }

    public static AgentScope startTaskScope(State state) {
        AgentScope.Continuation continuation;
        if (state != null && (continuation = state.getAndResetContinuation()) != null) {
            AgentScope scope = continuation.activate();
            scope.setAsyncPropagation(true);
            state.stopTiming();
            return scope;
        }
        return null;
    }

    public static void endTaskScope(AgentScope scope) {
        if (null != scope) {
            scope.close();
        }
    }

    public static <T> void cancelTask(ContextStore<T, State> contextStore, T task) {
        State state = contextStore.get(task);
        if (null != state) {
            state.closeContinuation();
        }
    }

    public static <T> void capture(ContextStore<T, State> contextStore, T task) {
        AgentScope activeScope = AgentTracer.activeScope();
        if (null != activeScope && activeScope.isAsyncPropagating()) {
            State state = contextStore.get(task);
            if (null == state) {
                state = State.FACTORY.create();
                contextStore.put(task, state);
            }
            state.captureAndSetContinuation(activeScope);
        }
    }
}

