/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.context;

import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import datadog.trace.bootstrap.otel.api.trace.Span;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import datadog.trace.bootstrap.otel.context.Scope;
import datadog.trace.bootstrap.otel.shim.context.OtelScope;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpan;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelContext
implements Context {
    private static final Object[] NO_ENTRIES = new Object[0];
    public static final Context ROOT = new OtelContext(OtelSpan.invalid(), OtelSpan.invalid());
    private static final String OTEL_CONTEXT_SPAN_KEY = "opentelemetry-trace-span-key";
    private static final String OTEL_CONTEXT_ROOT_SPAN_KEY = "opentelemetry-traces-local-root-span";
    private static final ThreadLocal<OtelContext> lastPropagated = new ThreadLocal();
    private final Span currentSpan;
    private final Span rootSpan;
    private final Object[] entries;

    public OtelContext(Span currentSpan, Span rootSpan) {
        this(currentSpan, rootSpan, NO_ENTRIES);
    }

    public OtelContext(Span currentSpan, Span rootSpan, Object[] entries) {
        this.currentSpan = currentSpan;
        this.rootSpan = rootSpan;
        this.entries = entries;
    }

    @Override
    @Nullable
    public <V> V get(ContextKey<V> key) {
        if (OTEL_CONTEXT_SPAN_KEY.equals(key.toString())) {
            return (V)this.currentSpan;
        }
        if (OTEL_CONTEXT_ROOT_SPAN_KEY.equals(key.toString())) {
            return (V)this.rootSpan;
        }
        for (int i = 0; i < this.entries.length; i += 2) {
            if (this.entries[i] != key) continue;
            return (V)this.entries[i + 1];
        }
        return null;
    }

    @Override
    public <V> Context with(ContextKey<V> key, V value) {
        if (OTEL_CONTEXT_SPAN_KEY.equals(key.toString())) {
            return new OtelContext((Span)value, this.rootSpan, this.entries);
        }
        if (OTEL_CONTEXT_ROOT_SPAN_KEY.equals(key.toString())) {
            return new OtelContext(this.currentSpan, (Span)value, this.entries);
        }
        Object[] newEntries = null;
        int oldEntriesLength = this.entries.length;
        for (int i = 0; i < oldEntriesLength; i += 2) {
            if (this.entries[i] != key) continue;
            if (this.entries[i + 1] == value) {
                return this;
            }
            newEntries = (Object[])this.entries.clone();
            newEntries[i + 1] = value;
            break;
        }
        if (null == newEntries) {
            newEntries = Arrays.copyOf(this.entries, oldEntriesLength + 2);
            newEntries[oldEntriesLength] = key;
            newEntries[oldEntriesLength + 1] = value;
        }
        return new OtelContext(this.currentSpan, this.rootSpan, newEntries);
    }

    @Override
    public Scope makeCurrent() {
        final Scope scope = Context.super.makeCurrent();
        if (this.currentSpan instanceof OtelSpan) {
            lastPropagated.remove();
            AgentScope agentScope = ((OtelSpan)this.currentSpan).activate();
            return new OtelScope(scope, agentScope, this.entries);
        }
        lastPropagated.set(this);
        return new Scope(){

            @Override
            public void close() {
                lastPropagated.remove();
                scope.close();
            }
        };
    }

    public static Context current() {
        Object wrapper;
        Object wrapper2;
        Object wrapper3;
        Context context = lastPropagated.get();
        if (null != context) {
            return context;
        }
        AgentScope agentCurrentScope = AgentTracer.activeScope();
        if (null == agentCurrentScope) {
            return ROOT;
        }
        OtelSpan otelCurrentSpan = null;
        AgentSpan agentCurrentSpan = agentCurrentScope.span();
        if (agentCurrentSpan instanceof AttachableWrapper && (wrapper3 = ((AttachableWrapper)((Object)agentCurrentSpan)).getWrapper()) instanceof OtelSpan) {
            otelCurrentSpan = (OtelSpan)wrapper3;
        }
        if (otelCurrentSpan == null) {
            otelCurrentSpan = new OtelSpan(agentCurrentSpan);
        }
        OtelSpan otelRootSpan = null;
        AgentSpan agentRootSpan = agentCurrentSpan.getLocalRootSpan();
        if (agentRootSpan instanceof AttachableWrapper && (wrapper2 = ((AttachableWrapper)((Object)agentRootSpan)).getWrapper()) instanceof OtelSpan) {
            otelRootSpan = (OtelSpan)wrapper2;
        }
        if (otelRootSpan == null) {
            otelRootSpan = new OtelSpan(agentRootSpan);
        }
        Object[] contextEntries = NO_ENTRIES;
        if (agentCurrentScope instanceof AttachableWrapper && (wrapper = ((AttachableWrapper)((Object)agentCurrentScope)).getWrapper()) instanceof OtelScope) {
            contextEntries = ((OtelScope)wrapper).contextEntries();
        }
        return new OtelContext(otelCurrentSpan, otelRootSpan, contextEntries);
    }

    @Nullable
    public static Context lastPropagated() {
        return lastPropagated.get();
    }

    public String toString() {
        return "OtelContext{currentSpan=" + this.currentSpan.getSpanContext() + ", rootSpan=" + this.rootSpan.getSpanContext() + '}';
    }
}

