/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.trace.Span;
import datadog.trace.bootstrap.otel.api.trace.SpanContext;
import datadog.trace.bootstrap.otel.api.trace.StatusCode;
import datadog.trace.bootstrap.otel.api.trace.TraceFlags;
import datadog.trace.bootstrap.otel.api.trace.TraceState;
import datadog.trace.bootstrap.otel.shim.trace.OtelConventions;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpanContext;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelSpan
implements Span {
    private final AgentSpan delegate;
    private StatusCode statusCode;
    private boolean recording;

    public OtelSpan(AgentSpan delegate) {
        this.delegate = delegate;
        if (delegate instanceof AttachableWrapper) {
            ((AttachableWrapper)((Object)delegate)).attachWrapper(this);
        }
        this.statusCode = StatusCode.UNSET;
        this.recording = true;
    }

    public static Span invalid() {
        return NoopSpan.INSTANCE;
    }

    @Override
    public <T> Span setAttribute(AttributeKey<T> key, T value) {
        if (this.recording && !OtelConventions.applyReservedAttribute(this.delegate, key, value)) {
            switch (key.getType()) {
                case STRING_ARRAY: 
                case BOOLEAN_ARRAY: 
                case LONG_ARRAY: 
                case DOUBLE_ARRAY: {
                    if (!(value instanceof List)) break;
                    List valueList = (List)value;
                    if (valueList.isEmpty()) {
                        this.delegate.setTag(key.getKey(), (Object)"");
                        break;
                    }
                    for (int index = 0; index < valueList.size(); ++index) {
                        this.delegate.setTag(key.getKey() + "." + index, valueList.get(index));
                    }
                    break;
                }
                default: {
                    this.delegate.setTag(key.getKey(), value);
                }
            }
        }
        return this;
    }

    @Override
    public Span addEvent(String name, Attributes attributes) {
        return this;
    }

    @Override
    public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        return this;
    }

    @Override
    public Span setStatus(StatusCode statusCode, String description) {
        if (this.recording) {
            if (this.statusCode == StatusCode.UNSET) {
                this.statusCode = statusCode;
                this.delegate.setError(statusCode == StatusCode.ERROR);
                this.delegate.setErrorMessage(statusCode == StatusCode.ERROR ? description : null);
            } else if (this.statusCode == StatusCode.ERROR && statusCode == StatusCode.OK) {
                this.statusCode = statusCode;
                this.delegate.setError(false);
                this.delegate.setErrorMessage(null);
            }
        }
        return this;
    }

    @Override
    public Span recordException(Throwable exception, Attributes additionalAttributes) {
        if (this.recording) {
            this.delegate.addThrowable(exception, (byte)-128);
        }
        return this;
    }

    @Override
    public Span updateName(String name) {
        if (this.recording) {
            this.delegate.setResourceName(name);
        }
        return this;
    }

    @Override
    public void end() {
        this.recording = false;
        OtelConventions.applyNamingConvention(this.delegate);
        this.delegate.finish();
    }

    @Override
    public void end(long timestamp, TimeUnit unit) {
        this.recording = false;
        OtelConventions.applyNamingConvention(this.delegate);
        this.delegate.finish(unit.toMicros(timestamp));
    }

    @Override
    public SpanContext getSpanContext() {
        return OtelSpanContext.fromLocalSpan(this.delegate);
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    public AgentScope activate() {
        return AgentTracer.activateSpan(this.delegate);
    }

    public AgentSpan.Context getAgentSpanContext() {
        return this.delegate.context();
    }

    private static class NoopSpanContext
    implements SpanContext {
        private static final SpanContext INSTANCE = new NoopSpanContext();

        private NoopSpanContext() {
        }

        @Override
        public String getTraceId() {
            return "00000000000000000000000000000000";
        }

        @Override
        public String getSpanId() {
            return "0000000000000000";
        }

        @Override
        public TraceFlags getTraceFlags() {
            return TraceFlags.getDefault();
        }

        @Override
        public TraceState getTraceState() {
            return TraceState.getDefault();
        }

        @Override
        public boolean isRemote() {
            return false;
        }
    }

    private static class NoopSpan
    implements Span {
        private static final Span INSTANCE = new NoopSpan();

        private NoopSpan() {
        }

        @Override
        public <T> Span setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        @Override
        public Span addEvent(String name, Attributes attributes) {
            return this;
        }

        @Override
        public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
            return this;
        }

        @Override
        public Span setStatus(StatusCode statusCode, String description) {
            return this;
        }

        @Override
        public Span recordException(Throwable exception, Attributes additionalAttributes) {
            return this;
        }

        @Override
        public Span updateName(String name) {
            return this;
        }

        @Override
        public void end() {
        }

        @Override
        public void end(long timestamp, TimeUnit unit) {
        }

        @Override
        public SpanContext getSpanContext() {
            return NoopSpanContext.INSTANCE;
        }

        @Override
        public boolean isRecording() {
            return false;
        }
    }
}

