package com.datadog.android.rum.model

import com.google.gson.JsonArray
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.JsonParseException
import com.google.gson.JsonParser
import java.lang.IllegalStateException
import java.lang.NullPointerException
import java.lang.NumberFormatException
import kotlin.String
import kotlin.collections.ArrayList
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.jvm.Throws

/**
 * Schema of all properties of events that can have parent actions
 * @param action Action properties
 */
public data class ActionChildProperties(
    public val action: Action? = null,
) {
    public fun toJson(): JsonElement {
        val json = JsonObject()
        action?.let { actionNonNull ->
            json.add("action", actionNonNull.toJson())
        }
        return json
    }

    public companion object {
        @JvmStatic
        @Throws(JsonParseException::class)
        public fun fromJson(jsonString: String): ActionChildProperties {
            try {
                val jsonObject = JsonParser.parseString(jsonString).asJsonObject
                return fromJsonObject(jsonObject)
            } catch (e: IllegalStateException) {
                throw JsonParseException(
                    "Unable to parse json into type ActionChildProperties",
                    e
                )
            }
        }

        @JvmStatic
        @Throws(JsonParseException::class)
        public fun fromJsonObject(jsonObject: JsonObject): ActionChildProperties {
            try {
                val action = jsonObject.get("action")?.asJsonObject?.let {
                    Action.fromJsonObject(it)
                }
                return ActionChildProperties(action)
            } catch (e: IllegalStateException) {
                throw JsonParseException(
                    "Unable to parse json into type ActionChildProperties",
                    e
                )
            } catch (e: NumberFormatException) {
                throw JsonParseException(
                    "Unable to parse json into type ActionChildProperties",
                    e
                )
            } catch (e: NullPointerException) {
                throw JsonParseException(
                    "Unable to parse json into type ActionChildProperties",
                    e
                )
            }
        }
    }

    /**
     * Action properties
     */
    public data class Action(
        public val id: List<String>,
    ) {
        public fun toJson(): JsonElement {
            val json = JsonObject()
            val idArray = JsonArray(id.size)
            id.forEach { idArray.add(it) }
            json.add("id", idArray)
            return json
        }

        public companion object {
            @JvmStatic
            @Throws(JsonParseException::class)
            public fun fromJson(jsonString: String): Action {
                try {
                    val jsonObject = JsonParser.parseString(jsonString).asJsonObject
                    return fromJsonObject(jsonObject)
                } catch (e: IllegalStateException) {
                    throw JsonParseException(
                        "Unable to parse json into type Action",
                        e
                    )
                }
            }

            @JvmStatic
            @Throws(JsonParseException::class)
            public fun fromJsonObject(jsonObject: JsonObject): Action {
                try {
                    val id = jsonObject.get("id").asJsonArray.let { jsonArray ->
                        val collection = ArrayList<String>(jsonArray.size())
                        jsonArray.forEach {
                            collection.add(it.asString)
                        }
                        collection
                    }
                    return Action(id)
                } catch (e: IllegalStateException) {
                    throw JsonParseException(
                        "Unable to parse json into type Action",
                        e
                    )
                } catch (e: NumberFormatException) {
                    throw JsonParseException(
                        "Unable to parse json into type Action",
                        e
                    )
                } catch (e: NullPointerException) {
                    throw JsonParseException(
                        "Unable to parse json into type Action",
                        e
                    )
                }
            }
        }
    }
}
