/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractReconnectionHandler;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.UnsupportedProtocolVersionException;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractReconnectionHandlerTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReconnectionHandlerTest.class);
    ScheduledExecutorService executor;
    MockReconnectionSchedule schedule;
    MockReconnectionWork work;
    AtomicReference<ListenableFuture<?>> future = new AtomicReference();
    AbstractReconnectionHandler handler;
    Callable<Boolean> nextTryAssigned = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return AbstractReconnectionHandlerTest.this.handler.handlerFuture.nextTry != null;
        }
    };

    @BeforeMethod(groups={"unit", "short"})
    public void setup() {
        this.executor = (ScheduledExecutorService)Mockito.spy((Object)Executors.newScheduledThreadPool(2));
        this.schedule = new MockReconnectionSchedule();
        this.work = new MockReconnectionWork();
        this.future.set(null);
        this.handler = new AbstractReconnectionHandler("test", this.executor, this.schedule, this.future){

            protected Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
                return AbstractReconnectionHandlerTest.this.work.tryReconnect();
            }

            protected void onReconnection(Connection connection) {
                AbstractReconnectionHandlerTest.this.work.onReconnection();
            }
        };
    }

    @AfterMethod(groups={"unit", "short"}, alwaysRun=true)
    public void tearDown() {
        if (this.future.get() != null) {
            this.future.get().cancel(false);
        }
        this.executor.shutdownNow();
    }

    @Test(groups={"unit"})
    public void should_complete_if_first_reconnection_succeeds() {
        this.handler.start();
        Assertions.assertThat(this.future.get()).isNotNull();
        Assertions.assertThat((boolean)this.future.get().isDone()).isFalse();
        this.schedule.tick();
        this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.SUCCEED;
        this.work.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isTrue();
        Assertions.assertThat((int)this.work.tries).isEqualTo(1);
        Assertions.assertThat(this.future.get()).isNull();
    }

    @Test(groups={"unit"})
    public void should_retry_until_success() {
        this.handler.start();
        int simulatedErrors = 10;
        for (int i = 0; i < simulatedErrors; ++i) {
            this.schedule.tick();
            this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.THROW_EXCEPTION;
            this.work.tick();
            Assertions.assertThat((boolean)this.work.success).isFalse();
            Assertions.assertThat((boolean)this.future.get().isDone()).isFalse();
        }
        this.schedule.tick();
        this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.SUCCEED;
        this.work.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isTrue();
        Assertions.assertThat((int)this.work.tries).isEqualTo(simulatedErrors + 1);
        Assertions.assertThat(this.future.get()).isNull();
    }

    @Test(groups={"unit"})
    public void should_stop_if_cancelled_before_first_attempt() {
        this.schedule.delay = 10000L;
        this.handler.start();
        this.schedule.tick();
        this.future.get().cancel(false);
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isFalse();
        Assertions.assertThat((int)this.work.tries).isEqualTo(0);
        Assertions.assertThat((boolean)this.future.get().isCancelled()).isTrue();
    }

    @Test(groups={"short"})
    public void should_stop_if_cancelled_between_attempts() {
        this.handler.start();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.timeout((long)10000L))).schedule((Runnable)this.handler, 0L, TimeUnit.MILLISECONDS);
        this.schedule.tick();
        this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.THROW_EXCEPTION;
        this.work.tick();
        this.schedule.delay = 3000L;
        this.schedule.tick();
        ((ScheduledExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.timeout((long)10000L))).schedule((Runnable)this.handler, this.schedule.delay, TimeUnit.MILLISECONDS);
        ConditionChecker.check().before(10000L).that(this.nextTryAssigned).becomesTrue();
        this.future.get().cancel(false);
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isFalse();
        Assertions.assertThat((int)this.work.tries).isEqualTo(1);
        ListenableFuture<?> currentAttempt = this.future.get();
        Assertions.assertThat(currentAttempt).isInstanceOf(AbstractReconnectionHandler.HandlerFuture.class);
        AbstractReconnectionHandler.HandlerFuture handlerFuture = (AbstractReconnectionHandler.HandlerFuture)currentAttempt;
        Assertions.assertThat((boolean)handlerFuture.isCancelled());
        Assertions.assertThat((Comparable)handlerFuture.nextTry).isNotNull();
        Assertions.assertThat((boolean)handlerFuture.nextTry.isCancelled());
    }

    @Test(groups={"unit"})
    public void should_complete_if_cancelled_during_successful_reconnect() throws InterruptedException {
        this.handler.start();
        this.schedule.tick();
        this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.SUCCEED;
        TimeUnit.MILLISECONDS.sleep(100L);
        this.future.get().cancel(false);
        this.work.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isTrue();
        Assertions.assertThat((int)this.work.tries).isEqualTo(1);
    }

    @Test(groups={"unit"})
    public void should_stop_if_cancelled_during_failed_reconnect() throws InterruptedException {
        this.handler.start();
        this.schedule.tick();
        this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.THROW_EXCEPTION;
        TimeUnit.MILLISECONDS.sleep(100L);
        this.future.get().cancel(false);
        this.work.tick();
        this.schedule.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isFalse();
        Assertions.assertThat((int)this.work.tries).isEqualTo(1);
    }

    @Test(groups={"unit"})
    public void should_yield_to_another_running_handler() {
        this.future.set((ListenableFuture<?>)SettableFuture.create());
        this.handler.start();
        this.schedule.delay = 5000L;
        this.schedule.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isFalse();
    }

    @Test(groups={"unit"})
    public void should_yield_to_another_handler_that_just_succeeded() {
        this.future.set((ListenableFuture<?>)Futures.immediateCheckedFuture(null));
        this.handler.start();
        this.schedule.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isFalse();
    }

    @Test(groups={"unit"})
    public void should_run_if_another_handler_was_cancelled() {
        this.future.set(Futures.immediateCancelledFuture());
        this.handler.start();
        this.schedule.tick();
        this.work.nextReconnect = MockReconnectionWork.ReconnectBehavior.SUCCEED;
        this.work.tick();
        this.waitForCompletion();
        Assertions.assertThat((boolean)this.work.success).isTrue();
        Assertions.assertThat((int)this.work.tries).isEqualTo(1);
        Assertions.assertThat(this.future.get()).isNull();
    }

    private void waitForCompletion() {
        this.executor.shutdown();
        try {
            boolean shutdown = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!shutdown) {
                Assert.fail((String)"executor ran for longer than expected");
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while waiting for executor to shutdown");
        }
    }

    static class MockReconnectionWork {
        private final CyclicBarrier barrier = new CyclicBarrier(2);
        volatile ReconnectBehavior nextReconnect;
        volatile int tries = 0;
        volatile boolean success = false;

        MockReconnectionWork() {
        }

        protected Connection tryReconnect() throws ConnectionException {
            ++this.tries;
            logger.debug("in reconnection work, wait for tick from main thread");
            try {
                this.barrier.await(60L, TimeUnit.SECONDS);
                logger.debug("in reconnection work, got tick from main thread, proceeding");
            }
            catch (Exception e) {
                Assert.fail((String)"Error while waiting for tick", (Throwable)e);
            }
            switch (this.nextReconnect) {
                case SUCCEED: {
                    logger.debug("simulate reconnection success");
                    return null;
                }
                case THROW_EXCEPTION: {
                    logger.debug("simulate reconnection error");
                    throw new ConnectionException(new InetSocketAddress(8888), "Simulated exception from mock reconnection");
                }
            }
            throw new AssertionError();
        }

        public void tick() {
            logger.debug("send tick to reconnection work");
            try {
                this.barrier.await(60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Assert.fail((String)"Error while sending tick, no thread was waiting", (Throwable)e);
            }
            this.barrier.reset();
        }

        protected void onReconnection() {
            this.success = true;
        }

        static enum ReconnectBehavior {
            SUCCEED,
            THROW_EXCEPTION;

        }
    }

    static class MockReconnectionSchedule
    implements ReconnectionPolicy.ReconnectionSchedule {
        volatile long delay;
        private final CyclicBarrier barrier = new CyclicBarrier(2);
        private volatile boolean firstDelay = true;
        private volatile boolean firstTick = true;

        MockReconnectionSchedule() {
        }

        public long nextDelayMs() {
            if (this.firstDelay) {
                this.firstDelay = false;
            } else {
                logger.debug("in schedule, waiting for tick from main thread");
                try {
                    this.barrier.await(10L, TimeUnit.SECONDS);
                    logger.debug("in schedule, got tick from main thread, proceeding");
                }
                catch (Exception e) {
                    Assert.fail((String)"Error while waiting for tick", (Throwable)e);
                }
            }
            logger.debug("in schedule, returning {}", (Object)this.delay);
            return this.delay;
        }

        public void tick() {
            if (this.firstTick) {
                this.firstTick = false;
            } else {
                logger.debug("send tick to schedule");
                try {
                    this.barrier.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Assert.fail((String)"Error while sending tick, no thread was waiting", (Throwable)e);
                }
                this.barrier.reset();
            }
        }
    }
}

