/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AtomicMonotonicTimestampGenerator;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.MockClocks;
import com.datastax.driver.core.TimestampGenerator;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AtomicMonotonicTimestampGeneratorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"unit"})
    public void should_generate_incrementing_timestamps_for_all_threads() throws InterruptedException {
        long fixedTime = 1L;
        final AtomicMonotonicTimestampGenerator generator = new AtomicMonotonicTimestampGenerator();
        generator.clock = new MockClocks.FixedTimeClock(1L);
        MemoryAppender appender = new MemoryAppender();
        Logger logger = Logger.getLogger(TimestampGenerator.class);
        Level originalLevel = logger.getLevel();
        logger.setLevel(Level.WARN);
        logger.addAppender((Appender)appender);
        try {
            int testThreadsCount = 2;
            Assert.assertEquals((int)0, (int)0);
            final ConcurrentSkipListSet allTimestamps = new ConcurrentSkipListSet();
            ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(2));
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)2);
            for (int i = 0; i < 2; ++i) {
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 500; ++i) {
                            allTimestamps.add(generator.next());
                        }
                    }
                }));
            }
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
            try {
                Futures.allAsList((Iterable)futures).get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AssertionError) {
                    throw (AssertionError)((Object)cause);
                }
                Assert.fail((String)"Error in a test thread", (Throwable)cause);
            }
            int i = 0;
            for (Long timestamp : allTimestamps) {
                Long expected = 1L + (long)i;
                Assert.assertEquals((Object)timestamp, (Object)expected);
                ++i;
            }
        }
        finally {
            logger.removeAppender((Appender)appender);
            logger.setLevel(originalLevel);
        }
    }
}

