/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.utils.CassandraVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class BatchStatementIntegrationTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))");
    }

    @Test(groups={"short"})
    public void should_execute_simple_batch() {
        try {
            PreparedStatement st = this.session().prepare("INSERT INTO test (k, v) VALUES (?, ?)");
            BatchStatement batch = new BatchStatement();
            batch.add((Statement)new SimpleStatement("INSERT INTO test (k, v) VALUES (?, ?)", new Object[]{"key1", 0}));
            batch.add((Statement)st.bind(new Object[]{"key1", 1}));
            batch.add((Statement)st.bind(new Object[]{"key2", 0}));
            Assert.assertEquals((int)3, (int)batch.size());
            this.session().execute((Statement)batch);
            ResultSet rs = this.session().execute("SELECT * FROM test");
            Row r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key1");
            Assert.assertEquals((int)r.getInt("v"), (int)0);
            r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key1");
            Assert.assertEquals((int)r.getInt("v"), (int)1);
            r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key2");
            Assert.assertEquals((int)r.getInt("v"), (int)0);
            Assert.assertTrue((boolean)rs.isExhausted());
        }
        catch (UnsupportedFeatureException e) {
            Assert.assertEquals((Object)this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion(), (Object)ProtocolVersion.V1);
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.9", description="This will only work with C* 2.0.9 (CASSANDRA-7337)")
    public void should_execute_cas_batch() {
        PreparedStatement st = this.session().prepare("INSERT INTO test (k, v) VALUES (?, ?) IF NOT EXISTS");
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement("INSERT INTO test (k, v) VALUES (?, ?)", new Object[]{"key1", 0}));
        batch.add((Statement)st.bind(new Object[]{"key1", 1}));
        batch.add((Statement)st.bind(new Object[]{"key1", 2}));
        Assert.assertEquals((int)3, (int)batch.size());
        ResultSet rs = this.session().execute((Statement)batch);
        Row r = rs.one();
        Assert.assertTrue((!r.isNull("[applied]") ? 1 : 0) != 0);
        Assert.assertEquals((boolean)r.getBool("[applied]"), (boolean)true);
        rs = this.session().execute((Statement)batch);
        r = rs.one();
        Assert.assertTrue((!r.isNull("[applied]") ? 1 : 0) != 0);
        Assert.assertEquals((boolean)r.getBool("[applied]"), (boolean)false);
    }
}

