/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.google.common.collect.Lists;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BoundStatementTest
extends CCMTestsSupport {
    PreparedStatement prepared;

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE foo (k int primary key, v1 text, v2 list<int>)");
    }

    @BeforeClass(groups={"short"})
    public void setup() {
        this.prepared = this.session().prepare("INSERT INTO foo (k, v1, v2) VALUES (?, ?, ?)");
    }

    @Test(groups={"short"})
    public void should_get_single_value() {
        BoundStatement statement = this.prepared.bind(new Object[]{1, "test", Lists.newArrayList((Object[])new Integer[]{1})});
        Assertions.assertThat((int)statement.getInt(0)).isEqualTo(statement.getInt("k")).isEqualTo(1);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)statement.getString(1)).isEqualTo((Object)statement.getString("v1"))).isEqualTo((Object)"test");
        ((AbstractListAssert)Assertions.assertThat((List)statement.getList(2, Integer.class)).isEqualTo((Object)statement.getList("v2", Integer.class))).isEqualTo((Object)Lists.newArrayList((Object[])new Integer[]{1}));
        try {
            statement.getString(0);
            Assertions.fail((String)"Expected codec not found error");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            statement.getString(3);
            Assertions.fail((String)"Expected index error");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

