/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMAccess;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCMCache {
    private static final Logger LOGGER;
    private static final LoadingCache<CCMBridge.Builder, CachedCCMAccess> CACHE;
    private static final int ONE_CCM_NODE_MB = 800;

    public static CCMAccess get(CCMBridge.Builder key) {
        CachedCCMAccess ccm = (CachedCCMAccess)CACHE.getIfPresent((Object)key);
        if (ccm != null) {
            ccm.refCount.incrementAndGet();
        } else {
            try {
                ccm = (CachedCCMAccess)CACHE.get((Object)key);
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        CCMCache.logCache();
        return ccm;
    }

    public static void remove(CCMBridge.Builder key) {
        CACHE.invalidate((Object)key);
    }

    private static void logCache() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Free memory: {} MB", (Object)TestUtils.getFreeMemoryMB());
            StringBuilder sb = new StringBuilder();
            Iterator iterator = CACHE.asMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                sb.append(((CachedCCMAccess)entry.getValue()).getClusterName()).append(" (").append(((CCMBridge.Builder)entry.getKey()).weight()).append(")");
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            LOGGER.debug("Cache contents: {{}}", (Object)sb.toString());
            LOGGER.debug("Cache stats: {}", (Object)CACHE.stats());
        }
    }

    static {
        long maximumWeight;
        LOGGER = LoggerFactory.getLogger(CCMCache.class);
        String numberOfNodes = System.getProperty("ccm.maxNumberOfNodes");
        if (numberOfNodes == null) {
            long freeMemoryMB = TestUtils.getFreeMemoryMB();
            if (freeMemoryMB < 800L) {
                LOGGER.warn("Not enough available memory: {} MB, CCM clusters might fail to start", (Object)freeMemoryMB);
            }
            long slotsAvailable = freeMemoryMB / 800L - 3L;
            maximumWeight = Math.min(8L, Math.max(1L, slotsAvailable));
        } else {
            maximumWeight = Integer.parseInt(numberOfNodes);
        }
        LOGGER.info("Maximum number of running CCM nodes: {}", (Object)maximumWeight);
        CACHE = CacheBuilder.newBuilder().initialCapacity(3).softValues().maximumWeight(maximumWeight).weigher((Weigher)new CCMAccessWeigher()).removalListener((RemovalListener)new CCMAccessRemovalListener()).recordStats().build((CacheLoader)new CCMAccessLoader());
    }

    private static class CCMAccessRemovalListener
    implements RemovalListener<CCMBridge.Builder, CachedCCMAccess> {
        private CCMAccessRemovalListener() {
        }

        public void onRemoval(RemovalNotification<CCMBridge.Builder, CachedCCMAccess> notification) {
            CachedCCMAccess cached = (CachedCCMAccess)notification.getValue();
            if (cached != null && cached.ccm != null) {
                LOGGER.debug("Evicting: {}, reason: {}", (Object)cached.ccm, (Object)notification.getCause());
                cached.evicted = true;
                cached.maybeClose();
            }
        }
    }

    private static class CCMAccessWeigher
    implements Weigher<CCMBridge.Builder, CachedCCMAccess> {
        private CCMAccessWeigher() {
        }

        public int weigh(CCMBridge.Builder key, CachedCCMAccess value) {
            return key.weight();
        }
    }

    private static class CCMAccessLoader
    extends CacheLoader<CCMBridge.Builder, CachedCCMAccess> {
        private CCMAccessLoader() {
        }

        public CachedCCMAccess load(CCMBridge.Builder key) {
            return new CachedCCMAccess(key.build());
        }
    }

    private static class CachedCCMAccess
    implements CCMAccess {
        private final CCMAccess ccm;
        private final AtomicInteger refCount = new AtomicInteger(1);
        private volatile boolean evicted = false;

        private CachedCCMAccess(CCMAccess ccm) {
            this.ccm = ccm;
        }

        @Override
        public String getClusterName() {
            return this.ccm.getClusterName();
        }

        @Override
        public VersionNumber getCassandraVersion() {
            return this.ccm.getCassandraVersion();
        }

        @Override
        public VersionNumber getDSEVersion() {
            return this.ccm.getDSEVersion();
        }

        @Override
        public File getCcmDir() {
            return this.ccm.getCcmDir();
        }

        @Override
        public File getClusterDir() {
            return this.ccm.getClusterDir();
        }

        @Override
        public File getNodeDir(int n) {
            return this.ccm.getNodeDir(n);
        }

        @Override
        public File getNodeConfDir(int n) {
            return this.ccm.getNodeConfDir(n);
        }

        @Override
        public int getStoragePort() {
            return this.ccm.getStoragePort();
        }

        @Override
        public int getThriftPort() {
            return this.ccm.getThriftPort();
        }

        @Override
        public int getBinaryPort() {
            return this.ccm.getBinaryPort();
        }

        @Override
        public void setKeepLogs(boolean keepLogs) {
            this.ccm.setKeepLogs(keepLogs);
        }

        @Override
        public InetSocketAddress addressOfNode(int n) {
            return this.ccm.addressOfNode(n);
        }

        @Override
        public void start() {
            this.ccm.start();
        }

        @Override
        public void stop() {
            this.ccm.stop();
        }

        @Override
        public void forceStop() {
            this.ccm.forceStop();
        }

        @Override
        public void close() {
            this.refCount.decrementAndGet();
            this.maybeClose();
        }

        private void maybeClose() {
            if (this.refCount.get() <= 0 && this.evicted) {
                this.ccm.close();
            }
        }

        @Override
        public void remove() {
            this.ccm.remove();
        }

        @Override
        public void updateConfig(Map<String, Object> configs) {
            this.ccm.updateConfig(configs);
        }

        @Override
        public void updateDSEConfig(Map<String, Object> configs) {
            this.ccm.updateDSEConfig(configs);
        }

        @Override
        public String checkForErrors() {
            return this.ccm.checkForErrors();
        }

        @Override
        public void start(int n) {
            this.ccm.start(n);
        }

        @Override
        public void stop(int n) {
            this.ccm.stop(n);
        }

        @Override
        public void forceStop(int n) {
            this.ccm.forceStop(n);
        }

        @Override
        public void pause(int n) {
            this.ccm.pause(n);
        }

        @Override
        public void resume(int n) {
            this.ccm.resume(n);
        }

        @Override
        public void remove(int n) {
            this.ccm.remove(n);
        }

        @Override
        public void add(int n) {
            this.ccm.add(n);
        }

        @Override
        public void add(int dc, int n) {
            this.ccm.add(dc, n);
        }

        @Override
        public void decommission(int n) {
            this.ccm.decommission(n);
        }

        @Override
        public void updateNodeConfig(int n, String key, Object value) {
            this.ccm.updateNodeConfig(n, key, value);
        }

        @Override
        public void updateNodeConfig(int n, Map<String, Object> configs) {
            this.ccm.updateNodeConfig(n, configs);
        }

        @Override
        public void updateDSENodeConfig(int n, String key, Object value) {
            this.ccm.updateDSENodeConfig(n, key, value);
        }

        @Override
        public void updateDSENodeConfig(int n, Map<String, Object> configs) {
            this.ccm.updateDSENodeConfig(n, configs);
        }

        @Override
        public void setWorkload(int n, String ... workload) {
            this.ccm.setWorkload(n, workload);
        }

        @Override
        public void waitForUp(int node) {
            this.ccm.waitForUp(node);
        }

        @Override
        public void waitForDown(int node) {
            this.ccm.waitForDown(node);
        }

        @Override
        public void dsetool(int node, String ... args) {
            this.ccm.dsetool(node, args);
        }

        @Override
        public void reloadCore(int node, String keyspace, String table, boolean reindex) {
            this.ccm.reloadCore(node, keyspace, table, reindex);
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return this.ccm.getProtocolVersion();
        }

        @Override
        public ProtocolVersion getProtocolVersion(ProtocolVersion maximumAllowed) {
            return this.ccm.getProtocolVersion(maximumAllowed);
        }

        public String toString() {
            return this.ccm.toString();
        }
    }
}

