/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Clock;
import com.datastax.driver.core.ClockFactory;
import com.datastax.driver.core.NativeClock;
import com.datastax.driver.core.SystemClock;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class ClockFactoryTest {
    final String osName = System.getProperty("os.name");

    @Test(groups={"unit"})
    public void should_use_native_clock_on_unix_platforms() {
        if (this.osName.startsWith("Windows")) {
            throw new SkipException("Skipping test for Windows platforms.");
        }
        Clock clock = ClockFactory.newInstance();
        Assertions.assertThat((Object)clock).isInstanceOf(NativeClock.class);
        Assertions.assertThat((long)clock.currentTimeMicros()).isGreaterThan(0L);
    }

    @Test(groups={"unit"})
    public void should_fallback_on_system_clock_on_windows_platforms() {
        if (!this.osName.startsWith("Windows")) {
            throw new SkipException("Skipping test for non-Windows platforms.");
        }
        Clock clock = ClockFactory.newInstance();
        Assertions.assertThat((Object)clock).isInstanceOf(SystemClock.class);
        Assertions.assertThat((long)clock.currentTimeMicros()).isGreaterThan(0L);
    }
}

