/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class ColumnMetadataAssert
extends AbstractAssert<ColumnMetadataAssert, ColumnMetadata> {
    protected ColumnMetadataAssert(ColumnMetadata actual) {
        super((Object)actual, ColumnMetadataAssert.class);
    }

    public ColumnMetadataAssert hasType(DataType dataType) {
        Assertions.assertThat((Object)((ColumnMetadata)this.actual).getType()).isEqualTo((Object)dataType);
        return this;
    }

    public ColumnMetadataAssert hasName(String name) {
        Assertions.assertThat((String)((ColumnMetadata)this.actual).getName()).isEqualTo((Object)name);
        return this;
    }

    public ColumnMetadataAssert isPrimaryKey() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ColumnMetadata)this.actual).getParent().getPrimaryKey().contains(this.actual)).as("Expecting %s to be part of the primary key, but it was not", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ColumnMetadataAssert isPartitionKey() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ColumnMetadata)this.actual).getParent().getPartitionKey().contains(this.actual)).as("Expecting %s to be part of the partition key, but it was not", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ColumnMetadataAssert isClusteringColumn() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ColumnMetadata)this.actual).getParent().getClusteringColumns().contains(this.actual)).as("Expecting %s to be a clustering column, but it was not", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ColumnMetadataAssert isRegularColumn() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ColumnMetadata)this.actual).getParent().getPrimaryKey().contains(this.actual)).as("Expecting %s to be a regular column, but it was not", new Object[]{this.actual})).isFalse();
        return this;
    }

    public ColumnMetadataAssert hasClusteringOrder(ClusteringOrder clusteringOrder) {
        Assertions.assertThat((Comparable)((Comparable)((ColumnMetadata)this.actual).getParent().getClusteringOrder().get(((ColumnMetadata)this.actual).getParent().getClusteringColumns().indexOf(this.actual)))).isEqualTo((Object)clusteringOrder);
        return this;
    }

    public ColumnMetadataAssert isStatic() {
        Assertions.assertThat((boolean)((ColumnMetadata)this.actual).isStatic()).isTrue();
        return this;
    }

    public ColumnMetadataAssert isNotStatic() {
        Assertions.assertThat((boolean)((ColumnMetadata)this.actual).isStatic()).isFalse();
        return this;
    }
}

