/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.CassandraVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@CassandraVersion(value="2.0.0", description="Conditional Updates requires 2.0+.")
public class ConditionalUpdateTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test(k1 int, k2 int, v int, PRIMARY KEY (k1, k2))");
    }

    @Test(groups={"short"})
    public void singleUpdateTest() {
        this.session().execute("TRUNCATE test");
        this.session().execute("INSERT INTO test (k1, k2, v) VALUES (1, 1, 1)");
        ResultSet rs = this.session().execute("UPDATE test SET v = 3 WHERE k1 = 1 AND k2 = 1 IF v = 2");
        Assert.assertFalse((boolean)rs.wasApplied());
        Assert.assertFalse((boolean)rs.isExhausted());
        rs = this.session().execute("UPDATE test SET v = 3 WHERE k1 = 1 AND k2 = 1 IF v = 1");
        Assert.assertTrue((boolean)rs.wasApplied());
        Assert.assertFalse((boolean)rs.isExhausted());
        rs = this.session().execute("UPDATE test SET v = 4 WHERE k1 = 1 AND k2 = 1");
        Assert.assertTrue((boolean)rs.wasApplied());
    }

    @Test(groups={"short"})
    public void batchUpdateTest() {
        this.session().execute("TRUNCATE test");
        this.session().execute("INSERT INTO test (k1, k2, v) VALUES (1, 1, 1)");
        this.session().execute("INSERT INTO test (k1, k2, v) VALUES (1, 2, 1)");
        PreparedStatement ps = this.session().prepare("UPDATE test SET v = :new WHERE k1 = :k1 AND k2 = :k2 IF v = :old");
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)ps.bind().setInt("k1", 1).setInt("k2", 1).setInt("old", 2).setInt("new", 3));
        batch.add((Statement)ps.bind().setInt("k1", 1).setInt("k2", 2).setInt("old", 1).setInt("new", 3));
        ResultSet rs = this.session().execute((Statement)batch);
        Assert.assertFalse((boolean)rs.wasApplied());
    }

    @Test(groups={"short"})
    public void multipageResultSetTest() {
        this.session().execute("TRUNCATE test");
        this.session().execute("INSERT INTO test (k1, k2, v) VALUES (1, 1, 1)");
        this.session().execute("INSERT INTO test (k1, k2, v) VALUES (1, 2, 1)");
        ResultSet rs = this.session().execute(new SimpleStatement("SELECT * FROM test WHERE k1 = 1").setFetchSize(1));
        Assert.assertTrue((boolean)rs.wasApplied());
    }

    @Test(groups={"short"})
    public void insert_if_not_exist_should_support_wasApplied_boolean() {
        this.session().execute("CREATE TABLE IF NOT EXISTS Java358 (key int primary key, value int)");
        ResultSet rs = this.session().execute("INSERT INTO Java358(key, value) VALUES (42, 42) IF NOT EXISTS");
        Assert.assertTrue((boolean)rs.wasApplied());
        rs = this.session().execute("INSERT INTO Java358(key, value) VALUES (42, 42) IF NOT EXISTS");
        Assert.assertFalse((boolean)rs.wasApplied());
    }

    @Test(groups={"short"})
    public void delete_if_not_exist_should_support_wasApplied_boolean() {
        this.session().execute("CREATE TABLE IF NOT EXISTS Java358 (key int primary key, value int)");
        this.session().execute("INSERT INTO Java358(key, value) VALUES (42, 42)");
        ResultSet rs = this.session().execute("DELETE FROM Java358 WHERE KEY=42 IF EXISTS");
        Assert.assertTrue((boolean)rs.wasApplied());
        rs = this.session().execute("DELETE FROM Java358 WHERE KEY=42 IF EXISTS");
        Assert.assertFalse((boolean)rs.wasApplied());
    }
}

