/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DelegatingCluster;
import com.datastax.driver.core.ResultSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class DelegatingClusterIntegrationTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_allow_subclass_to_delegate_to_other_instance() {
        SimpleDelegatingCluster delegatingCluster = new SimpleDelegatingCluster(this.cluster());
        ResultSet rs = delegatingCluster.connect().execute("select * from system.local");
        Assertions.assertThat((List)rs.all()).hasSize(1);
    }

    static class SimpleDelegatingCluster
    extends DelegatingCluster {
        private final Cluster delegate;

        public SimpleDelegatingCluster(Cluster delegate) {
            this.delegate = delegate;
        }

        protected Cluster delegate() {
            return this.delegate;
        }
    }
}

