/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DelegatingClusterIntegrationTest;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.exceptions.verification.WantedButNotInvoked;
import org.mockito.invocation.Invocation;
import org.testng.annotations.Test;

public class DelegatingClusterTest {
    private static final Set<String> NON_DELEGATED_METHODS = ImmutableSet.of((Object)"getClusterName");

    @Test(groups={"unit"})
    public void should_call_delegate_methods() throws Exception {
        Cluster delegate = (Cluster)Mockito.mock(Cluster.class);
        DelegatingClusterIntegrationTest.SimpleDelegatingCluster delegatingCluster = new DelegatingClusterIntegrationTest.SimpleDelegatingCluster(delegate);
        for (Method method : Cluster.class.getMethods()) {
            if ((method.getModifiers() & 8) == 8 || NON_DELEGATED_METHODS.contains(method.getName()) || method.getDeclaringClass() == Object.class) continue;
            Object[] parameters = new Object[method.getParameterTypes().length];
            try {
                method.invoke((Object)delegatingCluster, parameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DelegatingClusterTest.verify(delegate, method, parameters);
            Mockito.reset((Object[])new Cluster[]{delegate});
        }
    }

    private static void verify(Object mock, Method expectedMethod, Object ... expectedArguments) {
        block0: for (Invocation invocation : Mockito.mockingDetails((Object)mock).getInvocations()) {
            if (!invocation.getMethod().equals(expectedMethod)) continue;
            Object[] actualArguments = invocation.getArguments();
            assert (actualArguments.length == expectedArguments.length);
            for (int i = 0; i < actualArguments.length; ++i) {
                boolean equal;
                Object actual = actualArguments[i];
                Object expected = expectedArguments[i];
                boolean bl = actual == null ? expected == null : (equal = actual.equals(expected));
                if (!equal) continue block0;
            }
            invocation.markVerified();
            return;
        }
        throw new WantedButNotInvoked("Not delegated: " + expectedMethod.toString());
    }
}

