/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

@CassandraVersion(value="2.0")
@CCMConfig(config={"enable_user_defined_functions:true"})
public class ExportAsStringTest
extends CCMTestsSupport {
    private static final Logger logger = LoggerFactory.getLogger(ExportAsStringTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void create_schema_and_ensure_exported_cql_is_as_expected() {
        KeyspaceMetadata ks;
        String keyspace = "complex_ks";
        ImmutableMap replicationOptions = ImmutableMap.of((Object)"class", (Object)"SimpleStrategy", (Object)"replication_factor", (Object)1);
        this.session().execute((Statement)SchemaBuilder.createKeyspace((String)keyspace).with().replication((Map)replicationOptions));
        Session session = this.cluster().connect(keyspace);
        if (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"2.1")) >= 0) {
            session.execute((Statement)((CreateType)SchemaBuilder.createType((String)"ztype").addColumn("c", DataType.text())).addColumn("a", DataType.cint()));
            session.execute((Statement)SchemaBuilder.createType((String)"xtype").addColumn("d", DataType.text()));
            ks = this.cluster().getMetadata().getKeyspace(keyspace);
            session.execute((Statement)((CreateType)SchemaBuilder.createType((String)"ctype").addColumn("z", (DataType)ks.getUserType("ztype").copy(true))).addColumn("x", (DataType)ks.getUserType("xtype").copy(true)));
            session.execute((Statement)SchemaBuilder.createType((String)"btype").addColumn("a", DataType.text()));
            ks = this.cluster().getMetadata().getKeyspace(keyspace);
            session.execute((Statement)SchemaBuilder.createType((String)"atype").addColumn("c", (DataType)ks.getUserType("ctype").copy(true)));
            session.execute((Statement)((Create)SchemaBuilder.createTable((String)"ztable").addPartitionKey("zkey", DataType.text()).addColumn("a", (DataType)ks.getUserType("atype").copy(true))).withOptions().compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.leveledStrategy().ssTableSizeInMB(Integer.valueOf(95))));
        } else {
            session.execute((Statement)((Create)SchemaBuilder.createTable((String)"ztable").addPartitionKey("zkey", DataType.text()).addColumn("a", DataType.cint())).withOptions().compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.leveledStrategy().ssTableSizeInMB(Integer.valueOf(95))));
        }
        if (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"2.2")) >= 0) {
            session.execute((Statement)((Create)((Create)((Create)SchemaBuilder.createTable((String)"cyclist_mv").addPartitionKey("cid", DataType.uuid()).addColumn("name", DataType.text())).addColumn("age", DataType.cint())).addColumn("birthday", DataType.date())).addColumn("country", DataType.text()));
            session.execute((Statement)SchemaBuilder.createIndex((String)"cyclist_by_country").onTable("cyclist_mv").andColumn("country"));
            if (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"3.0")) >= 0) {
                session.execute("CREATE MATERIALIZED VIEW cyclist_by_r_age AS SELECT age, birthday, name, country FROM cyclist_mv WHERE age IS NOT NULL AND cid IS NOT NULL PRIMARY KEY (age, cid) WITH CLUSTERING ORDER BY (cid DESC)");
                session.execute("CREATE MATERIALIZED VIEW cyclist_by_a_age AS SELECT * FROM cyclist_mv WHERE age IS NOT NULL AND cid IS NOT NULL PRIMARY KEY (age, cid)");
                session.execute("CREATE MATERIALIZED VIEW cyclist_by_age AS SELECT age, birthday, name, country FROM cyclist_mv WHERE age IS NOT NULL AND cid IS NOT NULL PRIMARY KEY (age, cid) WITH comment = 'simple view'");
            }
        }
        session.execute((Statement)SchemaBuilder.createTable((String)"rank_by_year_and_name").addPartitionKey("race_year", DataType.cint()).addPartitionKey("race_name", DataType.text()).addClusteringColumn("rank", DataType.cint()).addColumn("cyclist_name", DataType.text()));
        session.execute((Statement)SchemaBuilder.createIndex((String)"ryear").onTable("rank_by_year_and_name").andColumn("race_year"));
        session.execute((Statement)SchemaBuilder.createIndex((String)"rrank").onTable("rank_by_year_and_name").andColumn("rank"));
        if (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"2.2")) >= 0) {
            session.execute("CREATE OR REPLACE FUNCTION avgState ( state tuple<int,bigint>, val int ) CALLED ON NULL INPUT RETURNS tuple<int,bigint> LANGUAGE java AS \n  'if (val !=null) { state.setInt(0, state.getInt(0)+1); state.setLong(1, state.getLong(1)+val.intValue()); } return state;';");
            session.execute("CREATE OR REPLACE FUNCTION avgFinal ( state tuple<int,bigint> ) CALLED ON NULL INPUT RETURNS double LANGUAGE java AS \n  'double r = 0; if (state.getInt(0) == 0) return null; r = state.getLong(1); r /= state.getInt(0); return Double.valueOf(r);';");
            session.execute("CREATE AGGREGATE IF NOT EXISTS mean ( int ) \nSFUNC avgState STYPE tuple<int,bigint> FINALFUNC avgFinal INITCOND (0,0);");
            session.execute("CREATE AGGREGATE IF NOT EXISTS average ( int ) \nSFUNC avgState STYPE tuple<int,bigint> FINALFUNC avgFinal INITCOND (0,0);");
        }
        ks = this.cluster().getMetadata().getKeyspace(keyspace);
        Assertions.assertThat((String)ks.exportAsString().trim()).isEqualTo((Object)this.getExpectedCqlString());
        Cluster newCluster = this.createClusterBuilderNoDebouncing().addContactPointsWithPorts(this.getContactPointsWithPorts()).build();
        try {
            newCluster.init();
            ks = newCluster.getMetadata().getKeyspace(keyspace);
            Assertions.assertThat((String)ks.exportAsString().trim()).isEqualTo((Object)this.getExpectedCqlString());
        }
        finally {
            newCluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExpectedCqlString() {
        VersionNumber cassandraVersion = this.ccm().getCassandraVersion();
        String majorMinor = cassandraVersion.getMajor() > 3 || cassandraVersion.getMajor() == 3 && cassandraVersion.getMinor() >= 8 ? "3.11" : cassandraVersion.getMajor() + "." + cassandraVersion.getMinor();
        String resourceName = "/export_as_string_test_" + majorMinor + ".cql";
        Closer closer = Closer.create();
        try {
            InputStream is = ExportAsStringTest.class.getResourceAsStream(resourceName);
            closer.register((Closeable)is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ByteStreams.copy((InputStream)is, (OutputStream)ps);
            String string = baos.toString().trim();
            return string;
        }
        catch (IOException e) {
            logger.warn("Failure to read {}", (Object)resourceName, (Object)e);
            Assertions.fail((String)("Unable to read " + resourceName + " is it defined?"));
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                logger.warn("Failure closing streams", (Throwable)e);
            }
        }
        return "";
    }
}

