/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.Map;
import org.assertj.core.data.MapEntry;
import org.testng.annotations.Test;

@CassandraVersion(value="2.2.0")
@CCMConfig(config={"enable_user_defined_functions:true"})
public class FunctionMetadataTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_parse_and_format_simple_function() {
        String cql = String.format("CREATE FUNCTION %s.plus(s int,v int) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return s+v;';", this.keyspace);
        this.session().execute(cql);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata function = keyspace.getFunction("plus", new DataType[]{DataType.cint(), DataType.cint()});
        Assertions.assertThat(function).isNotNull();
        Assertions.assertThat(function.getKeyspace()).isEqualTo(keyspace);
        Assertions.assertThat((String)function.getSignature()).isEqualTo((Object)"plus(int,int)");
        Assertions.assertThat((String)function.getSimpleName()).isEqualTo((Object)"plus");
        Assertions.assertThat(function.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat((Map)function.getArguments()).containsEntry((Object)"s", (Object)DataType.cint()).containsEntry((Object)"v", (Object)DataType.cint());
        Assertions.assertThat((String)function.getLanguage()).isEqualTo((Object)"java");
        Assertions.assertThat((String)function.getBody()).isEqualTo((Object)"return s+v;");
        Assertions.assertThat((boolean)function.isCalledOnNullInput()).isFalse();
        Assertions.assertThat((String)function.toString()).isEqualTo((Object)cql);
        Assertions.assertThat((String)function.exportAsString()).isEqualTo((Object)String.format("CREATE FUNCTION %s.plus(s int,v int)\n    RETURNS NULL ON NULL INPUT\n    RETURNS int\n    LANGUAGE java\n    AS 'return s+v;';", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_and_format_function_with_no_arguments() {
        String cql = String.format("CREATE FUNCTION %s.pi() CALLED ON NULL INPUT RETURNS double LANGUAGE java AS 'return Math.PI;';", this.keyspace);
        this.session().execute(cql);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        FunctionMetadata function = keyspace.getFunction("pi", new DataType[0]);
        Assertions.assertThat(function).isNotNull();
        Assertions.assertThat(function.getKeyspace()).isEqualTo(keyspace);
        Assertions.assertThat((String)function.getSignature()).isEqualTo((Object)"pi()");
        Assertions.assertThat((String)function.getSimpleName()).isEqualTo((Object)"pi");
        Assertions.assertThat(function.getReturnType()).isEqualTo(DataType.cdouble());
        Assertions.assertThat((Map)function.getArguments()).isEmpty();
        Assertions.assertThat((String)function.getLanguage()).isEqualTo((Object)"java");
        Assertions.assertThat((String)function.getBody()).isEqualTo((Object)"return Math.PI;");
        Assertions.assertThat((boolean)function.isCalledOnNullInput()).isTrue();
        Assertions.assertThat((String)function.toString()).isEqualTo((Object)cql);
        Assertions.assertThat((String)function.exportAsString()).isEqualTo((Object)String.format("CREATE FUNCTION %s.pi()\n    CALLED ON NULL INPUT\n    RETURNS double\n    LANGUAGE java\n    AS 'return Math.PI;';", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_and_format_function_with_udts() {
        String body = "//If \"called on null input\", handle nulls\nif(ADDRESS == null) return previous_total + 0;\n//User types are converted to com.datastax.driver.core.UDTValue types\njava.util.Set phones = ADDRESS.getSet(\"phones\", com.datastax.driver.core.UDTValue.class);\nreturn previous_total + phones.size();\n";
        String cqlFunction = String.format("CREATE FUNCTION %s.\"NUM_PHONES_ACCU\"(previous_total int,\"ADDRESS\" \"Address\") CALLED ON NULL INPUT RETURNS int LANGUAGE java AS '" + body + "';", this.keyspace);
        this.session().execute(cqlFunction);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        UserType addressType = keyspace.getUserType("\"Address\"");
        FunctionMetadata function = keyspace.getFunction("\"NUM_PHONES_ACCU\"", new DataType[]{DataType.cint(), addressType});
        Assertions.assertThat(function).isNotNull();
        Assertions.assertThat(function.getKeyspace()).isEqualTo(keyspace);
        Assertions.assertThat((String)function.getSignature()).isEqualTo((Object)"\"NUM_PHONES_ACCU\"(int,\"Address\")");
        Assertions.assertThat((String)function.getSimpleName()).isEqualTo((Object)"NUM_PHONES_ACCU");
        Assertions.assertThat(function.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat((Map)function.getArguments()).containsExactly(new MapEntry[]{org.assertj.core.api.Assertions.entry((Object)"previous_total", (Object)DataType.cint()), org.assertj.core.api.Assertions.entry((Object)"ADDRESS", (Object)addressType)});
        Assertions.assertThat((String)function.getLanguage()).isEqualTo((Object)"java");
        Assertions.assertThat((String)function.getBody()).isEqualTo((Object)body);
        Assertions.assertThat((boolean)function.isCalledOnNullInput()).isTrue();
        Assertions.assertThat((String)function.toString()).isEqualTo((Object)cqlFunction);
    }

    @Test(groups={"short"})
    public void should_parse_and_format_functions_with_complex_arguments() {
        String cql = String.format("CREATE FUNCTION %s.complex(x tuple<tuple<int>, map<int, int>>) RETURNS NULL ON NULL INPUT RETURNS int LANGUAGE java AS 'return 42;';", this.keyspace);
        this.session().execute(cql);
        KeyspaceMetadata keyspace = this.cluster().getMetadata().getKeyspace(this.keyspace);
        TupleType argumentType = this.cluster().getMetadata().newTupleType(new DataType[]{this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint()}), DataType.map((DataType)DataType.cint(), (DataType)DataType.cint())});
        FunctionMetadata function = keyspace.getFunction("complex", new DataType[]{argumentType});
        Assertions.assertThat(function).isNotNull();
        Assertions.assertThat(function.getKeyspace()).isEqualTo(keyspace);
        Assertions.assertThat((String)function.getSignature()).isEqualTo((Object)"complex(tuple<tuple<int>, map<int, int>>)");
        Assertions.assertThat((String)function.getSimpleName()).isEqualTo((Object)"complex");
        Assertions.assertThat(function.getReturnType()).isEqualTo(DataType.cint());
        Assertions.assertThat((Map)function.getArguments()).containsEntry((Object)"x", (Object)argumentType);
        Assertions.assertThat((String)function.getLanguage()).isEqualTo((Object)"java");
        Assertions.assertThat((String)function.getBody()).isEqualTo((Object)"return 42;");
        Assertions.assertThat((boolean)function.isCalledOnNullInput()).isFalse();
        Assertions.assertThat((String)function.toString()).isEqualTo((Object)cql);
        Assertions.assertThat((String)function.exportAsString()).isEqualTo((Object)String.format("CREATE FUNCTION %s.complex(x tuple<tuple<int>, map<int, int>>)\n    RETURNS NULL ON NULL INPUT\n    RETURNS int\n    LANGUAGE java\n    AS 'return 42;';", this.keyspace));
    }

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TYPE IF NOT EXISTS %s.\"Phone\" (number text)", this.keyspace), String.format("CREATE TYPE IF NOT EXISTS %s.\"Address\" (    street text,    city text,    zip int,    phones frozen<set<frozen<\"Phone\">>>,    location frozen<tuple<float, float>>)", this.keyspace));
    }
}

