/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.scassandra.http.client.ClosedConnectionReport;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HostConnectionPoolMultiTest {
    private ScassandraCluster scassandra;
    private Cluster cluster;

    @BeforeMethod(groups={"short", "long"})
    private void setUp() {
        this.scassandra = ScassandraCluster.builder().withNodes(2).build();
        this.scassandra.init();
    }

    @AfterMethod(groups={"short", "long"}, alwaysRun=true)
    private void tearDown() {
        if (this.cluster != null) {
            this.cluster.close();
        }
        this.scassandra.stop();
    }

    private void createCluster(int core, int max) {
        PoolingOptions poolingOptions = new PoolingOptions().setConnectionsPerHost(HostDistance.LOCAL, core, max);
        SocketOptions socketOptions = new SocketOptions().setReadTimeoutMillis(1000);
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandra.address(1).getAddress()}).withPort(this.scassandra.getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).withPoolingOptions(poolingOptions).withSocketOptions(socketOptions).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(1000L)).build();
        this.cluster.connect();
    }

    @Test(groups={"short"})
    public void should_mark_host_down_if_all_connections_fail_on_init() {
        this.scassandra.node(2).currentClient().disableListener();
        this.createCluster(8, 8);
        Assertions.assertThat(this.cluster).host(2).goesDownWithin(10L, TimeUnit.SECONDS);
        Assertions.assertThat(this.cluster).host(1).isUp();
        this.scassandra.node(2).currentClient().enableListener();
        Assertions.assertThat(this.cluster).host(2).comesUpWithin(2L, TimeUnit.SECONDS);
    }

    @Test(groups={"short"})
    public void should_replace_control_connection_if_it_goes_down_but_host_remains_up() {
        this.createCluster(1, 2);
        Assertions.assertThat(this.cluster).usesControlHost(1);
        Connection controlConnection = (Connection)this.cluster.manager.controlConnection.connectionRef.get();
        InetSocketAddress controlSocket = (InetSocketAddress)controlConnection.channel.localAddress();
        this.scassandra.node(1).currentClient().closeConnection(ClosedConnectionReport.CloseType.CLOSE, controlSocket);
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat(this.cluster).hasOpenControlConnection().host(1).isUp();
        Assertions.assertThat(this.cluster.manager.controlConnection.connectionRef.get()).isNotEqualTo((Object)controlConnection);
    }
}

