/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import java.nio.ByteBuffer;
import org.testng.Assert;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class LargeDataTest
extends CCMTestsSupport {
    private void testWideRows(int key) throws Throwable {
        for (int i = 0; i < 1000000; ++i) {
            this.session().execute(QueryBuilder.insertInto((String)"wide_rows").value("k", (Object)key).value("i", (Object)i).setConsistencyLevel(ConsistencyLevel.QUORUM));
        }
        ResultSet rs = this.session().execute((Statement)QueryBuilder.select((String[])new String[]{"i"}).from("wide_rows").where(QueryBuilder.eq((String)"k", (Object)key)));
        int i = 0;
        for (Row row : rs) {
            Assert.assertTrue((row.getInt("i") == i++ ? 1 : 0) != 0);
        }
    }

    private void testWideBatchRows(int key) throws Throwable {
        Batch q = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (int i = 0; i < 4000; ++i) {
            q = q.add((RegularStatement)QueryBuilder.insertInto((String)"wide_batch_rows").value("k", (Object)key).value("i", (Object)i));
        }
        this.session().execute(q.setConsistencyLevel(ConsistencyLevel.QUORUM));
        ResultSet rs = this.session().execute((Statement)QueryBuilder.select((String[])new String[]{"i"}).from("wide_batch_rows").where(QueryBuilder.eq((String)"k", (Object)key)));
        int i = 0;
        for (Row row : rs) {
            Assert.assertTrue((row.getInt("i") == i++ ? 1 : 0) != 0);
        }
    }

    private void testByteRows(int key) throws Throwable {
        ByteBuffer bb = ByteBuffer.allocate(58);
        bb.putShort((short)-13570);
        bb.flip();
        for (int i = 0; i < 1000000; ++i) {
            this.session().execute(QueryBuilder.insertInto((String)"wide_byte_rows").value("k", (Object)key).value("i", (Object)bb).setConsistencyLevel(ConsistencyLevel.QUORUM));
        }
        ResultSet rs = this.session().execute((Statement)QueryBuilder.select((String[])new String[]{"i"}).from("wide_byte_rows").where(QueryBuilder.eq((String)"k", (Object)key)));
        for (Row row : rs) {
            Assert.assertEquals((Object)row.getBytes("i"), (Object)bb);
        }
    }

    private void testLargeText(int key) throws Throwable {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 1000000; ++i) {
            b.append(i);
        }
        this.session().execute(QueryBuilder.insertInto((String)"large_text").value("k", (Object)key).value("txt", (Object)b.toString()).setConsistencyLevel(ConsistencyLevel.QUORUM));
        Row row = this.session().execute((Statement)QueryBuilder.select().all().from("large_text").where(QueryBuilder.eq((String)"k", (Object)key))).one();
        Assert.assertTrue((boolean)b.toString().equals(row.getString("txt")));
    }

    private static String createColumnName(int i) {
        String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "l"};
        int currentI = i;
        StringBuilder columnName = new StringBuilder();
        do {
            columnName.append(letters[currentI % 10]);
        } while ((currentI /= 10) != 0);
        return columnName.toString();
    }

    private void testWideTable(int key) throws Throwable {
        Insert insertStatement = QueryBuilder.insertInto((String)"wide_table").value("k", (Object)key);
        for (int i = 0; i < 330; ++i) {
            insertStatement = insertStatement.value(LargeDataTest.createColumnName(i), (Object)i);
        }
        this.session().execute(insertStatement.setConsistencyLevel(ConsistencyLevel.QUORUM));
        Row row = this.session().execute((Statement)QueryBuilder.select().all().from("wide_table").where(QueryBuilder.eq((String)"k", (Object)key))).one();
        for (int i = 0; i < 330; ++i) {
            Assert.assertTrue((row.getInt(LargeDataTest.createColumnName(i)) == i ? 1 : 0) != 0);
        }
    }

    @Test(groups={"stress"})
    @CassandraVersion(value="2.0.0", description="< 2.0 is skipped as 1.2 does not handle reading wide rows well.")
    public void wideRows() throws Throwable {
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        this.session().execute("USE large_data");
        this.session().execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_rows"));
        this.testWideRows(0);
    }

    @Test(groups={"stress"})
    @CassandraVersion(value="2.0.0", description="< 2.0 is skipped as 1.2 does not handle large batches well.")
    public void wideBatchRows() throws Throwable {
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        this.session().execute("USE large_data");
        this.session().execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_batch_rows"));
        this.testWideBatchRows(0);
    }

    @Test(groups={"stress"})
    public void wideByteRows() throws Throwable {
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        this.session().execute("USE large_data");
        this.session().execute(String.format("CREATE TABLE %s (k INT, i BLOB, PRIMARY KEY(k, i))", "wide_byte_rows"));
        this.testByteRows(0);
    }

    @Test(groups={"stress"})
    public void largeText() throws Throwable {
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        this.session().execute("USE large_data");
        this.session().execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, txt text)", "large_text"));
        this.testLargeText(0);
    }

    @Test(groups={"stress"})
    public void wideTable() throws Throwable {
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        this.session().execute("USE large_data");
        StringBuilder tableDeclaration = new StringBuilder();
        tableDeclaration.append("CREATE TABLE wide_table (");
        tableDeclaration.append("k INT PRIMARY KEY");
        for (int i = 0; i < 330; ++i) {
            tableDeclaration.append(String.format(", %s INT", LargeDataTest.createColumnName(i)));
        }
        tableDeclaration.append(')');
        this.session().execute(tableDeclaration.toString());
        this.testWideTable(0);
    }

    @Test(groups={"duration"})
    @CCMConfig(numberOfNodes={3})
    public void mixedDurationTest() throws Throwable {
        int i;
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 3));
        this.session().execute("USE large_data");
        this.session().execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_rows"));
        this.session().execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_batch_rows"));
        this.session().execute(String.format("CREATE TABLE %s (k INT, i BLOB, PRIMARY KEY(k, i))", "wide_byte_rows"));
        this.session().execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, txt text)", "large_text"));
        StringBuilder tableDeclaration = new StringBuilder();
        tableDeclaration.append("CREATE TABLE wide_table (");
        tableDeclaration.append("k INT PRIMARY KEY");
        for (i = 0; i < 330; ++i) {
            tableDeclaration.append(String.format(", %s INT", LargeDataTest.createColumnName(i)));
        }
        tableDeclaration.append(')');
        this.session().execute(tableDeclaration.toString());
        block8: for (i = 0; i < 10; ++i) {
            switch ((int)(Math.random() * 5.0)) {
                case 0: {
                    this.testWideRows(0);
                    continue block8;
                }
                case 1: {
                    this.testWideBatchRows(0);
                    continue block8;
                }
                case 2: {
                    this.testByteRows(0);
                    continue block8;
                }
                case 3: {
                    this.testLargeText(0);
                    continue block8;
                }
                case 4: {
                    this.testWideTable(0);
                    continue block8;
                }
            }
        }
    }
}

