/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Token;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class M3PTokenFactoryTest {
    Token.Factory factory = Token.M3PToken.FACTORY;

    @Test(groups={"unit"})
    public void should_split_range() {
        List splits = this.factory.split(this.factory.fromString("-9223372036854775808"), this.factory.fromString("4611686018427387904"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("-4611686018427387904"), this.factory.fromString("0")});
    }

    @Test(groups={"unit"})
    public void should_split_range_that_wraps_around_the_ring() {
        List splits = this.factory.split(this.factory.fromString("4611686018427387904"), this.factory.fromString("0"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("-9223372036854775807"), this.factory.fromString("-4611686018427387903")});
    }

    @Test(groups={"unit"})
    public void should_split_range_when_division_not_integral() {
        List splits = this.factory.split(this.factory.fromString("0"), this.factory.fromString("11"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("4"), this.factory.fromString("8")});
    }

    @Test(groups={"unit"})
    public void should_split_range_producing_empty_splits() {
        List splits = this.factory.split(this.factory.fromString("0"), this.factory.fromString("2"), 5);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("1"), this.factory.fromString("2"), this.factory.fromString("2"), this.factory.fromString("2")});
    }

    @Test(groups={"unit"})
    public void should_split_range_producing_empty_splits_near_ring_end() {
        Token minToken = this.factory.fromString("-9223372036854775808");
        Token maxToken = this.factory.fromString("9223372036854775807");
        List splits = this.factory.split(maxToken, minToken, 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{maxToken, maxToken});
        splits = this.factory.split(minToken, this.factory.fromString("-9223372036854775807"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("-9223372036854775807"), this.factory.fromString("-9223372036854775807")});
    }

    @Test(groups={"unit"})
    public void should_split_whole_ring() {
        List splits = this.factory.split(this.factory.fromString("-9223372036854775808"), this.factory.fromString("-9223372036854775808"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("-3074457345618258603"), this.factory.fromString("3074457345618258602")});
    }
}

