/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;

public class MemoryAppender
extends WriterAppender {
    private final Lock appendLock = new ReentrantLock();
    private final Condition append = this.appendLock.newCondition();
    public final StringWriter writer = new StringWriter();
    private int nextLogIdx = 0;

    public MemoryAppender() {
        this.setWriter(this.writer);
        this.setLayout((Layout)new PatternLayout("%m%n"));
    }

    protected void subAppend(LoggingEvent event) {
        this.appendLock.lock();
        try {
            super.subAppend(event);
            this.append.signal();
        }
        finally {
            this.appendLock.unlock();
        }
    }

    public String get() {
        return this.writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitAndGet(long timeoutMillis) throws InterruptedException {
        long nanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        this.appendLock.lock();
        try {
            while (this.get().isEmpty() && nanos > 0L) {
                nanos = this.append.awaitNanos(nanos);
            }
            String string = this.get();
            return string;
        }
        finally {
            this.appendLock.unlock();
        }
    }

    public String getNext() {
        String next = this.get().substring(this.nextLogIdx);
        this.nextLogIdx += next.length();
        return next;
    }

    public MemoryAppender enableFor(Class<?> ... loggers) {
        for (Class<?> logger : loggers) {
            this.enableFor(logger.getName());
        }
        return this;
    }

    public MemoryAppender enableFor(Logger ... loggers) {
        for (Logger logger : loggers) {
            this.enableFor(logger.getName());
        }
        return this;
    }

    public MemoryAppender enableFor(String ... loggers) {
        for (String logger : loggers) {
            org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)logger);
            log4jLogger.addAppender((Appender)this);
        }
        return this;
    }

    public MemoryAppender disableFor(Class<?> ... loggers) {
        for (Class<?> logger : loggers) {
            this.disableFor(logger.getName());
        }
        return this;
    }

    public MemoryAppender disableFor(Logger ... loggers) {
        for (Logger logger : loggers) {
            this.disableFor(logger.getName());
        }
        return this;
    }

    public MemoryAppender disableFor(String ... loggers) {
        for (String logger : loggers) {
            org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)logger);
            log4jLogger.removeAppender((Appender)this);
        }
        return this;
    }
}

