/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.PercentileTracker;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.UnpreparedException;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public abstract class PercentileTrackerTest<B extends PercentileTracker.Builder<B, T>, T extends PercentileTracker> {
    Host defaultHost = (Host)Mockito.mock(Host.class);
    Exception defaultException = (Exception)Mockito.mock(Exception.class);
    Statement defaultStatement = (Statement)Mockito.mock(Statement.class);
    long defaultMaxLatency = 1000L;

    public abstract B builder();

    @Test(groups={"unit"})
    public void should_ignore_certain_exceptions() throws Exception {
        Cluster cluster0 = (Cluster)Mockito.mock(Cluster.class);
        PercentileTracker tracker = (PercentileTracker)((PercentileTracker.Builder)((PercentileTracker.Builder)this.builder().withInterval(50L, TimeUnit.MILLISECONDS)).withMinRecordedValues(100)).build();
        tracker.onRegister(cluster0);
        ArrayList exceptionsToIgnore = Lists.newArrayList((Object[])new Exception[]{new UnavailableException(ConsistencyLevel.ANY, 0, 0), new OverloadedException(null, "Overloaded"), new BootstrappingException(null, "Bootstrapping"), new UnpreparedException(null, "Unprepared"), new InvalidQueryException("Validation", (Throwable)new Exception())});
        long startTime = System.currentTimeMillis();
        for (Exception exception : exceptionsToIgnore) {
            tracker.update(this.defaultHost, this.defaultStatement, exception, TimeUnit.NANOSECONDS.convert(999L, TimeUnit.MILLISECONDS));
        }
        for (int i = 0; i < 100; ++i) {
            tracker.update(this.defaultHost, this.defaultStatement, this.defaultException, TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS));
        }
        long waitTime = 50L - (System.currentTimeMillis() - startTime);
        Uninterruptibles.sleepUninterruptibly((long)(waitTime + 100L), (TimeUnit)TimeUnit.MILLISECONDS);
        for (int i = 1; i <= 99; ++i) {
            long latencyAtPct = tracker.getLatencyAtPercentile(this.defaultHost, this.defaultStatement, this.defaultException, (double)i);
            Assertions.assertThat((long)latencyAtPct).isEqualTo(1L);
        }
    }

    @Test(groups={"unit"})
    public void should_not_record_anything_if_not_enough_measurements() throws Exception {
        Cluster cluster0 = (Cluster)Mockito.mock(Cluster.class);
        PercentileTracker tracker = (PercentileTracker)((PercentileTracker.Builder)((PercentileTracker.Builder)this.builder().withInterval(50L, TimeUnit.MILLISECONDS)).withMinRecordedValues(100)).build();
        tracker.onRegister(cluster0);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 99; ++i) {
            tracker.update(this.defaultHost, this.defaultStatement, this.defaultException, TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS));
        }
        long waitTime = 50L - (System.currentTimeMillis() - startTime);
        Uninterruptibles.sleepUninterruptibly((long)(waitTime + 100L), (TimeUnit)TimeUnit.MILLISECONDS);
        for (int i = 1; i <= 99; ++i) {
            long latencyAtPct = tracker.getLatencyAtPercentile(this.defaultHost, this.defaultStatement, this.defaultException, (double)i);
            Assertions.assertThat((long)latencyAtPct).isEqualTo(-1L);
        }
    }

    @Test(groups={"short"})
    public void should_return_negative_value_when_interval_hasnt_elapsed() throws Exception {
        int i;
        Cluster cluster0 = (Cluster)Mockito.mock(Cluster.class);
        PercentileTracker tracker = (PercentileTracker)((PercentileTracker.Builder)((PercentileTracker.Builder)this.builder().withInterval(50L, TimeUnit.MINUTES)).withMinRecordedValues(100)).build();
        tracker.onRegister(cluster0);
        for (i = 0; i < 99; ++i) {
            tracker.update(this.defaultHost, this.defaultStatement, this.defaultException, TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS));
        }
        for (i = 1; i <= 99; ++i) {
            long latencyAtPct = tracker.getLatencyAtPercentile(this.defaultHost, this.defaultStatement, this.defaultException, (double)i);
            Assertions.assertThat((long)latencyAtPct).isEqualTo(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"unit"})
    public void should_not_record_value_and_log_when_measurement_higher_than_max_trackable_value() throws Exception {
        Cluster cluster0 = (Cluster)Mockito.mock(Cluster.class);
        PercentileTracker tracker = (PercentileTracker)((PercentileTracker.Builder)((PercentileTracker.Builder)this.builder().withInterval(50L, TimeUnit.MILLISECONDS)).withMinRecordedValues(100)).build();
        tracker.onRegister(cluster0);
        Logger percentileLogger = Logger.getLogger(PercentileTracker.class);
        Level originalLevel = percentileLogger.getLevel();
        percentileLogger.setLevel(Level.WARN);
        MemoryAppender appender = new MemoryAppender();
        percentileLogger.addAppender((Appender)appender);
        try {
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < 100; ++i) {
                tracker.update(this.defaultHost, this.defaultStatement, this.defaultException, TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS));
            }
            long largeLatency = 2048L;
            tracker.update(this.defaultHost, this.defaultStatement, this.defaultException, TimeUnit.NANOSECONDS.convert(largeLatency, TimeUnit.MILLISECONDS));
            Assertions.assertThat((String)appender.get()).contains(new CharSequence[]{"Got request with latency of " + largeLatency + " ms, which exceeds the configured maximum trackable value " + this.defaultMaxLatency});
            long waitTime = 50L - (System.currentTimeMillis() - startTime);
            Uninterruptibles.sleepUninterruptibly((long)(waitTime + 100L), (TimeUnit)TimeUnit.MILLISECONDS);
            for (int i = 1; i <= 99; ++i) {
                long latencyAtPct = tracker.getLatencyAtPercentile(this.defaultHost, this.defaultStatement, this.defaultException, (double)i);
                Assertions.assertThat((long)latencyAtPct).isEqualTo(1L);
            }
        }
        finally {
            percentileLogger.setLevel(originalLevel);
            percentileLogger.removeAppender((Appender)appender);
        }
    }
}

