/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMAccess;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMCache;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.CassandraVersion;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RecommissionedNodeTest {
    private static final Logger logger = LoggerFactory.getLogger(RecommissionedNodeTest.class);
    CCMBridge.Builder mainCcmBuilder;
    CCMBridge.Builder otherCcmBuilder;
    CCMAccess mainCcm;
    CCMAccess otherCcm;
    Cluster mainCluster;

    @Test(groups={"long"})
    public void should_ignore_recommissioned_node_on_reconnection_attempt() throws Exception {
        this.mainCcmBuilder = CCMBridge.builder().withNodes(3);
        this.mainCcm = CCMCache.get(this.mainCcmBuilder);
        this.mainCcm.stop(1);
        this.mainCcm.waitForDown(1);
        this.mainCluster = Cluster.builder().addContactPoints(new InetAddress[]{this.mainCcm.addressOfNode(2).getAddress()}).withPort(this.mainCcm.getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build();
        this.mainCluster.connect();
        RecommissionedNodeTest.waitForCountUpHosts(this.mainCluster, 2);
        this.otherCcmBuilder = CCMBridge.builder().withStoragePort(this.mainCcm.getStoragePort()).withThriftPort(this.mainCcm.getThriftPort()).withBinaryPort(this.mainCcm.getBinaryPort()).withNodes(1);
        this.otherCcm = CCMCache.get(this.otherCcmBuilder);
        this.otherCcm.waitForUp(1);
        TimeUnit.SECONDS.sleep(32L);
        Assertions.assertThat((int)RecommissionedNodeTest.countUpHosts(this.mainCluster)).isEqualTo(2);
    }

    @Test(groups={"long"})
    public void should_ignore_recommissioned_node_on_control_connection_reconnect() throws Exception {
        this.mainCcmBuilder = CCMBridge.builder().withNodes(2);
        this.mainCcm = CCMCache.get(this.mainCcmBuilder);
        this.mainCcm.stop(1);
        this.mainCcm.waitForDown(1);
        this.mainCluster = Cluster.builder().addContactPoints(new InetAddress[]{this.mainCcm.addressOfNode(2).getAddress()}).withPort(this.mainCcm.getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build();
        this.mainCluster.connect();
        RecommissionedNodeTest.waitForCountUpHosts(this.mainCluster, 1);
        this.otherCcmBuilder = CCMBridge.builder().withStoragePort(this.mainCcm.getStoragePort()).withThriftPort(this.mainCcm.getThriftPort()).withBinaryPort(this.mainCcm.getBinaryPort()).withNodes(1);
        this.otherCcm = CCMCache.get(this.otherCcmBuilder);
        this.otherCcm.waitForUp(1);
        this.mainCcm.stop(2);
        TimeUnit.SECONDS.sleep(32L);
        Assertions.assertThat(this.mainCluster).hasClosedControlConnection();
    }

    @Test(groups={"long"})
    public void should_ignore_recommissioned_node_on_session_init() throws Exception {
        this.mainCcmBuilder = CCMBridge.builder().withNodes(2);
        this.mainCcm = CCMCache.get(this.mainCcmBuilder);
        this.mainCcm.stop(1);
        this.mainCcm.waitForDown(1);
        this.otherCcmBuilder = CCMBridge.builder().withStoragePort(this.mainCcm.getStoragePort()).withThriftPort(this.mainCcm.getThriftPort()).withBinaryPort(this.mainCcm.getBinaryPort()).withNodes(1);
        this.otherCcm = CCMCache.get(this.otherCcmBuilder);
        this.otherCcm.waitForUp(1);
        this.mainCluster = Cluster.builder().addContactPoints(new InetAddress[]{this.mainCcm.addressOfNode(2).getAddress()}).withPort(this.mainCcm.getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build();
        Assertions.assertThat(this.mainCluster).host(2).hasState(Host.State.UP);
        Assertions.assertThat(this.mainCluster).host(1).hasState(Host.State.UP);
        this.mainCluster.connect();
        Assertions.assertThat(this.mainCluster).host(1).goesDownWithin(10L, TimeUnit.SECONDS).hasState(Host.State.DOWN).isNotReconnectingFromDown();
    }

    @Test(groups={"long"})
    @CassandraVersion(value="2.0.0")
    public void should_ignore_node_that_does_not_support_protocol_version_on_session_init() throws Exception {
        this.mainCcmBuilder = CCMBridge.builder().withNodes(2);
        this.mainCcm = CCMCache.get(this.mainCcmBuilder);
        this.mainCcm.stop(1);
        this.mainCcm.waitForDown(1);
        this.otherCcmBuilder = CCMBridge.builder().withNodes(1).withStoragePort(this.mainCcm.getStoragePort()).withThriftPort(this.mainCcm.getThriftPort()).withBinaryPort(this.mainCcm.getBinaryPort()).withVersion(VersionNumber.parse((String)"1.2.19"));
        this.otherCcm = CCMCache.get(this.otherCcmBuilder);
        this.otherCcm.waitForUp(1);
        this.mainCluster = Cluster.builder().addContactPoints(new InetAddress[]{this.mainCcm.addressOfNode(2).getAddress()}).withPort(this.mainCcm.getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build();
        this.mainCluster.connect();
        Assertions.assertThat(this.mainCluster).host(1).goesDownWithin(10L, TimeUnit.SECONDS).hasState(Host.State.DOWN).isNotReconnectingFromDown();
    }

    @BeforeMethod(groups={"long"})
    public void clearFields() {
        this.mainCluster = null;
        this.mainCcmBuilder = null;
        this.otherCcmBuilder = null;
        this.mainCcm = null;
        this.otherCcm = null;
    }

    @AfterMethod(groups={"long"}, alwaysRun=true)
    public void teardown() {
        if (this.mainCluster != null) {
            this.mainCluster.close();
        }
        if (this.mainCcmBuilder != null) {
            CCMCache.remove(this.mainCcmBuilder);
        }
        if (this.otherCcmBuilder != null) {
            CCMCache.remove(this.otherCcmBuilder);
        }
        if (this.mainCcm != null) {
            this.mainCcm.close();
        }
        if (this.otherCcm != null) {
            this.otherCcm.close();
        }
    }

    private static int countUpHosts(Cluster cluster) {
        int ups = 0;
        for (Host host : cluster.getMetadata().getAllHosts()) {
            if (!host.isUp()) continue;
            ++ups;
        }
        return ups;
    }

    private static void waitForCountUpHosts(Cluster cluster, int expectedCount) throws InterruptedException {
        int maxRetries = 10;
        int interval = 6;
        for (int i = 0; i <= maxRetries; ++i) {
            int actualCount = RecommissionedNodeTest.countUpHosts(cluster);
            if (actualCount == expectedCount) {
                return;
            }
            if (i == maxRetries) {
                Assertions.fail((String)String.format("Up host count didn't reach %d after %d seconds", expectedCount, i * interval));
            } else {
                logger.debug("Counted {} up hosts after {} seconds", (Object)actualCount, (Object)(i * interval));
            }
            TimeUnit.SECONDS.sleep(interval);
        }
    }
}

