/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.RemoteEndpointAwareNettySSLOptions;
import com.datastax.driver.core.SSLOptions;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;

@CCMConfig(ssl={true}, createCluster={false})
public abstract class SSLTestBase
extends CCMTestsSupport {
    @DataProvider(name="sslImplementation")
    public static Object[][] sslImplementation() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.6")) {
            return new Object[][]{{SslImplementation.JDK}};
        }
        return new Object[][]{{SslImplementation.JDK}, {SslImplementation.NETTY_OPENSSL}};
    }

    protected void connectWithSSLOptions(SSLOptions sslOptions) throws Exception {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withSSL(sslOptions).build());
        cluster.connect();
    }

    protected void connectWithSSL() throws Exception {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withSSL().build());
        cluster.connect();
    }

    public SSLOptions getSSLOptions(SslImplementation sslImplementation, boolean clientAuth, boolean trustingServer) throws Exception {
        TrustManagerFactory tmf = null;
        if (trustingServer) {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(this.getClass().getResourceAsStream("/client.truststore"), "cassandra1sfun".toCharArray());
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
        }
        switch (sslImplementation) {
            case JDK: {
                KeyManagerFactory kmf = null;
                if (clientAuth) {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(this.getClass().getResourceAsStream("/client.keystore"), "cassandra1sfun".toCharArray());
                    kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, "cassandra1sfun".toCharArray());
                }
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, new SecureRandom());
                return RemoteEndpointAwareJdkSSLOptions.builder().withSSLContext(sslContext).build();
            }
            case NETTY_OPENSSL: {
                SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(tmf);
                if (clientAuth) {
                    builder.keyManager(CCMBridge.DEFAULT_CLIENT_CERT_CHAIN_FILE, CCMBridge.DEFAULT_CLIENT_PRIVATE_KEY_FILE);
                }
                return new RemoteEndpointAwareNettySSLOptions(builder.build());
            }
        }
        Assertions.fail((String)("Unsupported SSL implementation: " + (Object)((Object)sslImplementation)));
        return null;
    }

    static enum SslImplementation {
        JDK,
        NETTY_OPENSSL;

    }
}

