/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.ScassandraTestBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.TestUtils;
import java.net.InetAddress;
import org.apache.log4j.Level;
import org.assertj.core.api.Assertions;
import org.jboss.byteman.contrib.bmunit.BMNGListener;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@BMUnitConfig(loadDirectory="target/test-classes")
@Listeners(value={BMNGListener.class})
@CCMConfig(createCluster={false})
public class SessionErrorTest
extends ScassandraTestBase {
    private ScassandraCluster scassandra;
    private Cluster cluster;

    @BeforeClass(groups={"short"})
    public void setUp() throws Exception {
        this.scassandra = ScassandraCluster.builder().withNodes(2).build();
        this.scassandra.init();
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.scassandra.address(1).getAddress()}).withPort(this.scassandra.getBinaryPort()).build();
        this.cluster.init();
    }

    @AfterClass(groups={"short"})
    public void tearDown() throws Exception {
        this.cluster.close();
        this.scassandra.stop();
    }

    @Test(groups={"short"})
    @BMRule(name="emulate OOME", targetClass="com.datastax.driver.core.Connection$4", targetMethod="apply(Void)", action="throw new OutOfMemoryError(\"not really\")")
    public void should_propagate_errors() {
        try {
            this.cluster.connect();
            Assertions.fail((String)"Expecting OOME");
        }
        catch (OutOfMemoryError e) {
            Assertions.assertThat((Throwable)e).hasMessage("not really");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    @BMRule(name="emulate NPE", targetClass="com.datastax.driver.core.Connection$4", targetMethod="apply(Void)", action="throw new NullPointerException(\"not really\")")
    public void should_not_propagate_unchecked_exceptions() {
        Level previous = TestUtils.setLogLevel(HostConnectionPool.class, Level.WARN);
        MemoryAppender logs = new MemoryAppender().enableFor(HostConnectionPool.class);
        try {
            Session session = this.cluster.connect();
            Host host1 = this.scassandra.host(this.cluster, 1, 1);
            Host host2 = this.scassandra.host(this.cluster, 1, 2);
            TestUtils.waitForDown(TestUtils.ipOfNode(2), this.cluster);
            Session.State state = session.getState();
            Assertions.assertThat((int)state.getOpenConnections(host1)).isEqualTo(0);
            Assertions.assertThat((int)state.getOpenConnections(host2)).isEqualTo(0);
            Assertions.assertThat((String)logs.get()).contains(new CharSequence[]{"Unexpected error during transport initialization", "not really", NullPointerException.class.getSimpleName(), "com.datastax.driver.core.Connection$4.apply"});
            HostConnectionPool pool1 = (HostConnectionPool)((SessionManager)session).pools.get(host1);
            HostConnectionPool pool2 = (HostConnectionPool)((SessionManager)session).pools.get(host2);
            Assertions.assertThat((Object)pool1).isNotNull();
            Assertions.assertThat((boolean)pool1.isClosed()).isFalse();
            Assertions.assertThat((Object)pool2).isNull();
        }
        catch (Throwable throwable) {
            TestUtils.setLogLevel(HostConnectionPool.class, previous);
            logs.disableFor(HostConnectionPool.class);
            throw throwable;
        }
        TestUtils.setLogLevel(HostConnectionPool.class, previous);
        logs.disableFor(HostConnectionPool.class);
    }
}

