/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.utils.SocketChannelMonitor;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(dirtiesContext={true}, createCluster={false})
public class SessionLeakTest
extends CCMTestsSupport {
    SocketChannelMonitor channelMonitor;

    @Test(groups={"long"})
    public void connectionLeakTest() throws Exception {
        this.channelMonitor = new SocketChannelMonitor();
        this.channelMonitor.reportAtFixedInterval(1, TimeUnit.SECONDS);
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withNettyOptions(this.channelMonitor.nettyOptions()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build());
        cluster.init();
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(0);
        this.assertOpenConnections(1, cluster);
        int corePoolSize = TestUtils.numberOfLocalCoreConnections(cluster);
        Session session = cluster.connect();
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(1);
        this.assertOpenConnections(1 + corePoolSize, cluster);
        session.close();
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(0);
        this.assertOpenConnections(1, cluster);
        this.ccm().add(2);
        this.ccm().start(2);
        this.ccm().waitForUp(2);
        Assertions.assertThat(cluster).host(2).comesUpWithin(2L, TimeUnit.MINUTES);
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(0);
        this.assertOpenConnections(1, cluster);
        Session thisSession = cluster.connect();
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(1);
        this.assertOpenConnections(1 + corePoolSize * 2, cluster);
        thisSession.close();
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(0);
        this.assertOpenConnections(1, cluster);
        cluster.close();
        this.channelMonitor.stop();
        this.channelMonitor.report();
        Assertions.assertThat((int)this.channelMonitor.openChannels(Lists.newArrayList((Object[])new InetSocketAddress[]{this.ccm().addressOfNode(1), this.ccm().addressOfNode(2)})).size()).isEqualTo(0);
    }

    @Test(groups={"short"})
    public void should_not_leak_session_when_wrong_keyspace() throws Exception {
        this.channelMonitor = new SocketChannelMonitor();
        this.channelMonitor.reportAtFixedInterval(1, TimeUnit.SECONDS);
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withNettyOptions(this.channelMonitor.nettyOptions()).build());
        cluster.init();
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(0);
        try {
            this.assertOpenConnections(1, cluster);
            cluster.connect("wrong_keyspace");
            org.assertj.core.api.Assertions.fail((String)"Should not have connected to a wrong keyspace");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        Assertions.assertThat((int)cluster.manager.sessions.size()).isEqualTo(0);
        cluster.close();
        this.channelMonitor.stop();
        this.channelMonitor.report();
        Assertions.assertThat((int)this.channelMonitor.openChannels(this.ccm().addressOfNode(1), this.ccm().addressOfNode(2)).size()).isEqualTo(0);
    }

    private void assertOpenConnections(int expected, Cluster cluster) {
        Assertions.assertThat((Integer)((Integer)cluster.getMetrics().getOpenConnections().getValue())).isEqualTo(expected);
        Assertions.assertThat((int)this.channelMonitor.openChannels(this.ccm().addressOfNode(1), this.ccm().addressOfNode(2)).size()).isEqualTo(expected);
    }
}

