/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class SimpleStatementIntegrationTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE users(id int, id2 int, name text, primary key (id, id2))", "INSERT INTO users(id, id2, name) VALUES (1, 2, 'test')");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_execute_query_with_named_values() {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id and id2 = :id2", (Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"id2", (Object)2));
        Row row = this.session().execute((Statement)statement).one();
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((String)row.getString("name")).isEqualTo((Object)"test");
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    @CassandraVersion(value="2.1.0")
    public void should_fail_if_query_with_named_values_but_missing_parameter() {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id and id2 = :id2", (Map)ImmutableMap.of((Object)"id2", (Object)2));
        this.session().execute((Statement)statement).one();
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    @CassandraVersion(value="2.1.0")
    public void should_fail_if_query_with_named_values_but_using_wrong_type() {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id and id2 = :id2", (Map)ImmutableMap.of((Object)"id", (Object)2.7, (Object)"id2", (Object)2));
        this.session().execute((Statement)statement).one();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useNamedValuesWithProtocol(ProtocolVersion version) {
        Cluster vCluster = this.createClusterBuilder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(version).build();
        try {
            Session vSession = vCluster.connect(this.keyspace);
            SimpleStatement statement = new SimpleStatement("SELECT * FROM users WHERE id = :id", (Map)ImmutableMap.of((Object)"id", (Object)1));
            vSession.execute((Statement)statement).one();
        }
        finally {
            vCluster.close();
        }
    }

    @Test(groups={"short"}, expectedExceptions={UnsupportedFeatureException.class})
    @CassandraVersion(value="2.0.0")
    public void should_fail_if_query_with_named_values_if_protocol_is_V2() {
        if (this.ccm().getCassandraVersion().getMajor() >= 3) {
            throw new SkipException("Skipping since Cassandra 3.0+ does not support protocol v2");
        }
        this.useNamedValuesWithProtocol(ProtocolVersion.V2);
    }

    @Test(groups={"short"}, expectedExceptions={UnsupportedFeatureException.class})
    @CassandraVersion(value="2.0.0")
    public void should_fail_if_query_with_named_values_if_protocol_is_V1() {
        if (this.ccm().getCassandraVersion().getMajor() >= 3) {
            throw new SkipException("Skipping since Cassandra 3.0+ does not support protocol v1");
        }
        this.useNamedValuesWithProtocol(ProtocolVersion.V1);
    }
}

