/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.SimpleStatement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class SimpleStatementTest {
    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_if_too_many_variables() {
        List<Integer> args = Collections.nCopies(65536, 1);
        new SimpleStatement("mock query", args.toArray());
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class})
    public void should_throw_ISE_if_getObject_called_on_statement_without_values() {
        new SimpleStatement("doesn't matter").getObject(0);
    }

    @Test(groups={"unit"}, expectedExceptions={IndexOutOfBoundsException.class})
    public void should_throw_IOOBE_if_getObject_called_with_wrong_index() {
        new SimpleStatement("doesn't matter", new Object[]{new Object()}).getObject(1);
    }

    @Test(groups={"unit"})
    public void should_return_object_at_ith_index() {
        Object expected = new Object();
        Object actual = new SimpleStatement("doesn't matter", new Object[]{expected}).getObject(0);
        Assertions.assertThat((Object)actual).isSameAs(expected);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class})
    public void should_throw_ISE_if_getObject_called_on_statement_without_named_values() {
        new SimpleStatement("doesn't matter").getObject("name");
    }

    @Test(groups={"unit"})
    public void should_return_null_if_getObject_called_on_statement_with_wrong_name() {
        HashMap<String, Object> namedVales = new HashMap<String, Object>();
        namedVales.put("name", new Object());
        Object actual = new SimpleStatement("doesn't matter", namedVales).getObject("wrong name");
        Assertions.assertThat((Object)actual).isNull();
    }

    @Test(groups={"unit"})
    public void should_return_object_with_name() {
        Object expected = new Object();
        String valueName = "name";
        HashMap<String, Object> namedVales = new HashMap<String, Object>();
        namedVales.put(valueName, expected);
        Object actual = new SimpleStatement("doesn't matter", namedVales).getObject(valueName);
        Assertions.assertThat((Object)actual).isSameAs(expected);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class})
    public void should_throw_ISE_if_getValueNames_called_on_statement_without_named_values() {
        new SimpleStatement("doesn't matter").getValueNames();
    }

    @Test(groups={"unit"})
    public void should_return_named_value() {
        Object expected = new Object();
        HashMap<String, Object> namedValues = new HashMap<String, Object>();
        namedValues.put("name", expected);
        Object actual = new SimpleStatement("doesn't matter", namedValues).getObject("name");
        Assertions.assertThat((Object)actual).isEqualTo(expected);
    }

    @Test(groups={"unit"})
    public void should_return_number_of_values() {
        Assertions.assertThat((int)new SimpleStatement("doesn't matter").valuesCount()).isEqualTo(0);
        Assertions.assertThat((int)new SimpleStatement("doesn't matter", new Object[]{1, 2}).valuesCount()).isEqualTo(2);
    }
}

