/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.primitives.UnsignedBytes;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;

public class SortingLoadBalancingPolicy
implements LoadBalancingPolicy {
    final SortedSet<Host> hosts = new ConcurrentSkipListSet<Host>(new Comparator<Host>(){

        @Override
        public int compare(Host host1, Host host2) {
            byte[] address1 = host1.getAddress().getAddress();
            byte[] address2 = host2.getAddress().getAddress();
            return UnsignedBytes.compare((byte)address1[address1.length - 1], (byte)address2[address2.length - 1]);
        }
    });

    public void init(Cluster cluster, Collection<Host> hosts) {
        this.hosts.addAll(hosts);
    }

    public HostDistance distance(Host host) {
        return HostDistance.LOCAL;
    }

    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        return this.hosts.iterator();
    }

    public void onAdd(Host host) {
        this.onUp(host);
    }

    public void onUp(Host host) {
        this.hosts.add(host);
    }

    public void onDown(Host host) {
        this.hosts.remove(host);
    }

    public void onRemove(Host host) {
        this.onDown(host);
    }

    public void close() {
    }
}

