/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(dirtiesContext={true}, createSession={false})
public class StateListenerTest
extends CCMTestsSupport {
    private static final Logger logger = LoggerFactory.getLogger(StateListenerTest.class);

    @Test(groups={"long"})
    public void should_receive_events_when_node_states_change() throws InterruptedException {
        TestListener listener = new TestListener();
        this.cluster().register((Host.StateListener)listener);
        listener.setExpectedEvent(TestListener.Event.ADD);
        this.ccm().add(2);
        this.ccm().start(2);
        listener.waitForEvent();
        listener.setExpectedEvent(TestListener.Event.DOWN);
        this.ccm().forceStop(1);
        listener.waitForEvent();
        listener.setExpectedEvent(TestListener.Event.UP);
        this.ccm().start(1);
        listener.waitForEvent();
        listener.setExpectedEvent(TestListener.Event.REMOVE);
        this.ccm().decommission(2);
        listener.waitForEvent();
    }

    static class TestListener
    implements Host.StateListener {
        volatile CountDownLatch latch;
        volatile Event expectedEvent;
        volatile Event actualEvent;

        TestListener() {
        }

        void setExpectedEvent(Event expectedEvent) {
            logger.debug("Set expected event {}", (Object)expectedEvent);
            this.expectedEvent = expectedEvent;
            this.latch = new CountDownLatch(1);
        }

        void waitForEvent() throws InterruptedException {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.latch.await(2L, TimeUnit.MINUTES)).as("Timed out waiting for event " + (Object)((Object)this.expectedEvent), new Object[0])).isTrue();
            Assertions.assertThat((Comparable)((Object)this.actualEvent)).isEqualTo((Object)this.expectedEvent);
        }

        private void reportActualEvent(Event event) {
            if (this.latch.getCount() == 0L) {
                logger.error("Was not waiting for an event but got {} (this should eventually be fixed by JAVA-657)", (Object)event);
                return;
            }
            logger.debug("Got event {}", (Object)event);
            this.actualEvent = event;
            this.latch.countDown();
        }

        public void onAdd(Host host) {
            this.reportActualEvent(Event.ADD);
        }

        public void onUp(Host host) {
            this.reportActualEvent(Event.UP);
        }

        public void onDown(Host host) {
            this.reportActualEvent(Event.DOWN);
        }

        public void onRemove(Host host) {
            this.reportActualEvent(Event.REMOVE);
        }

        public void onRegister(Cluster cluster) {
        }

        public void onUnregister(Cluster cluster) {
        }

        static enum Event {
            ADD,
            UP,
            SUSPECTED,
            DOWN,
            REMOVE;

        }
    }
}

