/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.CassandraVersion;
import com.datastax.driver.core.utils.DseVersion;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.TestListenerAdapter;
import org.testng.internal.ConstructorOrMethod;

public class TestListener
extends TestListenerAdapter
implements IInvokedMethodListener {
    private long start_time = System.nanoTime();
    private int test_index = 0;

    public void onTestFailure(ITestResult tr) {
        long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start_time);
        long testTime = tr.getEndMillis() - tr.getStartMillis();
        tr.getThrowable().printStackTrace();
        System.out.println("FAILED : " + tr.getName());
        System.out.println("Test   : " + TestListener.formatIntoHHMMSS(testTime / 1000L));
        System.out.println("Elapsed: " + TestListener.formatIntoHHMMSS(elapsedTime));
        System.out.println();
    }

    public void onTestSkipped(ITestResult tr) {
        long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start_time);
        long testTime = tr.getEndMillis() - tr.getStartMillis();
        System.out.println("SKIPPED: " + tr.getName());
        System.out.println("Test   : " + TestListener.formatIntoHHMMSS(testTime / 1000L));
        System.out.println("Elapsed: " + TestListener.formatIntoHHMMSS(elapsedTime));
        System.out.println();
    }

    public void onTestSuccess(ITestResult tr) {
        long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start_time);
        long testTime = tr.getEndMillis() - tr.getStartMillis();
        System.out.println("SUCCESS: " + tr.getName());
        System.out.println("Test   : " + TestListener.formatIntoHHMMSS(testTime / 1000L));
        System.out.println("Elapsed: " + TestListener.formatIntoHHMMSS(elapsedTime));
        System.out.println();
    }

    public void onTestStart(ITestResult tr) {
        System.out.println();
        System.out.println("-----------------------------------------------");
        System.out.println("Starting " + tr.getTestClass().getName() + '.' + tr.getName() + " [Test #" + ++this.test_index + "]...");
    }

    static String formatIntoHHMMSS(long secondsTotal) {
        long hours = secondsTotal / 3600L;
        long remainder = secondsTotal % 3600L;
        long minutes = remainder / 60L;
        long seconds = remainder % 60L;
        return (hours < 10L ? "0" : "") + hours + ':' + (minutes < 10L ? "0" : "") + minutes + ':' + (seconds < 10L ? "0" : "") + seconds;
    }

    public void beforeInvocation(IInvokedMethod testMethod, ITestResult testResult) {
        Method method;
        ITestNGMethod testNgMethod = testResult.getMethod();
        ConstructorOrMethod constructorOrMethod = testNgMethod.getConstructorOrMethod();
        Class<?> clazz = testNgMethod.getInstance().getClass();
        if (clazz != null) {
            while (!this.scanAnnotatedElement(clazz) && !(clazz = clazz.getSuperclass()).equals(Object.class)) {
            }
        }
        if ((method = constructorOrMethod.getMethod()) != null) {
            this.scanAnnotatedElement(method);
        }
    }

    private boolean scanAnnotatedElement(AnnotatedElement element) {
        if (element.isAnnotationPresent(CassandraVersion.class)) {
            CassandraVersion cassandraVersion = element.getAnnotation(CassandraVersion.class);
            TestListener.cassandraVersionCheck(cassandraVersion);
            return true;
        }
        if (element.isAnnotationPresent(DseVersion.class)) {
            DseVersion dseVersion = element.getAnnotation(DseVersion.class);
            TestListener.dseVersionCheck(dseVersion);
            return true;
        }
        return false;
    }

    public void afterInvocation(IInvokedMethod testMethod, ITestResult testResult) {
    }

    private static void cassandraVersionCheck(CassandraVersion version) {
        TestListener.versionCheck(CCMBridge.getGlobalCassandraVersion(), VersionNumber.parse((String)version.value()), version.description());
    }

    private static void dseVersionCheck(DseVersion version) {
        VersionNumber dseVersion = CCMBridge.getGlobalDSEVersion();
        if (dseVersion == null) {
            throw new SkipException("Skipping test because not configured for DataStax Enterprise cluster.");
        }
        TestListener.versionCheck(CCMBridge.getGlobalDSEVersion(), VersionNumber.parse((String)version.value()), version.description());
    }

    private static void versionCheck(VersionNumber current, VersionNumber required, String skipString) {
        if (current == null) {
            throw new SkipException("Skipping test because provided version is null");
        }
        if (current.compareTo(required) < 0) {
            throw new SkipException(String.format("Version >= %s required, but found %s. Justification: %s", required, current, skipString));
        }
    }
}

