/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMAccess;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.GettableByNameData;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.SettableByNameData;
import com.datastax.driver.core.StateListenerBase;
import com.datastax.driver.core.SystemProperties;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import com.sun.management.OperatingSystemMXBean;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.scassandra.Scassandra;
import org.scassandra.ScassandraFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestUtils {
    public static final String IP_PREFIX;
    private static final Logger logger;
    public static final String CREATE_KEYSPACE_SIMPLE_FORMAT = "CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }";
    public static final String CREATE_KEYSPACE_GENERIC_FORMAT = "CREATE KEYSPACE %s WITH replication = { 'class' : '%s', %s }";
    public static final String SELECT_ALL_FORMAT = "SELECT * FROM %s";
    public static final int TEST_BASE_NODE_WAIT;
    private static final ConcurrentMap<String, AtomicInteger> IDENTIFIERS;
    private static final Predicate<InetSocketAddress> PORT_IS_UP;
    public static NettyOptions nonQuietClusterCloseOptions;

    public static void setValue(SettableByIndexData<?> data, int i, DataType type, Object value) {
        switch (type.getName()) {
            case ASCII: {
                data.setString(i, (String)value);
                break;
            }
            case BIGINT: {
                data.setLong(i, ((Long)value).longValue());
                break;
            }
            case BLOB: {
                data.setBytes(i, (ByteBuffer)value);
                break;
            }
            case BOOLEAN: {
                data.setBool(i, ((Boolean)value).booleanValue());
                break;
            }
            case COUNTER: {
                break;
            }
            case DECIMAL: {
                data.setDecimal(i, (BigDecimal)value);
                break;
            }
            case DOUBLE: {
                data.setDouble(i, ((Double)value).doubleValue());
                break;
            }
            case FLOAT: {
                data.setFloat(i, ((Float)value).floatValue());
                break;
            }
            case INET: {
                data.setInet(i, (InetAddress)value);
                break;
            }
            case TINYINT: {
                data.setByte(i, ((Byte)value).byteValue());
                break;
            }
            case SMALLINT: {
                data.setShort(i, ((Short)value).shortValue());
                break;
            }
            case INT: {
                data.setInt(i, ((Integer)value).intValue());
                break;
            }
            case TEXT: {
                data.setString(i, (String)value);
                break;
            }
            case TIMESTAMP: {
                data.setTimestamp(i, (Date)value);
                break;
            }
            case DATE: {
                data.setDate(i, (LocalDate)value);
                break;
            }
            case TIME: {
                data.setTime(i, ((Long)value).longValue());
                break;
            }
            case UUID: {
                data.setUUID(i, (UUID)value);
                break;
            }
            case VARCHAR: {
                data.setString(i, (String)value);
                break;
            }
            case VARINT: {
                data.setVarint(i, (BigInteger)value);
                break;
            }
            case TIMEUUID: {
                data.setUUID(i, (UUID)value);
                break;
            }
            case LIST: {
                data.setList(i, (List)value);
                break;
            }
            case SET: {
                data.setSet(i, (Set)value);
                break;
            }
            case MAP: {
                data.setMap(i, (Map)value);
                break;
            }
            default: {
                throw new RuntimeException("Missing handling of " + type);
            }
        }
    }

    public static void setValue(SettableByNameData<?> data, String name, DataType type, Object value) {
        switch (type.getName()) {
            case ASCII: {
                data.setString(name, (String)value);
                break;
            }
            case BIGINT: {
                data.setLong(name, ((Long)value).longValue());
                break;
            }
            case BLOB: {
                data.setBytes(name, (ByteBuffer)value);
                break;
            }
            case BOOLEAN: {
                data.setBool(name, ((Boolean)value).booleanValue());
                break;
            }
            case COUNTER: {
                break;
            }
            case DECIMAL: {
                data.setDecimal(name, (BigDecimal)value);
                break;
            }
            case DOUBLE: {
                data.setDouble(name, ((Double)value).doubleValue());
                break;
            }
            case FLOAT: {
                data.setFloat(name, ((Float)value).floatValue());
                break;
            }
            case INET: {
                data.setInet(name, (InetAddress)value);
                break;
            }
            case TINYINT: {
                data.setByte(name, ((Byte)value).byteValue());
                break;
            }
            case SMALLINT: {
                data.setShort(name, ((Short)value).shortValue());
                break;
            }
            case INT: {
                data.setInt(name, ((Integer)value).intValue());
                break;
            }
            case TEXT: {
                data.setString(name, (String)value);
                break;
            }
            case TIMESTAMP: {
                data.setTimestamp(name, (Date)value);
                break;
            }
            case DATE: {
                data.setDate(name, (LocalDate)value);
                break;
            }
            case TIME: {
                data.setTime(name, ((Long)value).longValue());
                break;
            }
            case UUID: {
                data.setUUID(name, (UUID)value);
                break;
            }
            case VARCHAR: {
                data.setString(name, (String)value);
                break;
            }
            case VARINT: {
                data.setVarint(name, (BigInteger)value);
                break;
            }
            case TIMEUUID: {
                data.setUUID(name, (UUID)value);
                break;
            }
            case LIST: {
                data.setList(name, (List)value);
                break;
            }
            case SET: {
                data.setSet(name, (Set)value);
                break;
            }
            case MAP: {
                data.setMap(name, (Map)value);
                break;
            }
            default: {
                throw new RuntimeException("Missing handling of " + type);
            }
        }
    }

    public static Object getValue(GettableByIndexData data, int i, DataType type, CodecRegistry codecRegistry) {
        switch (type.getName()) {
            case ASCII: {
                return data.getString(i);
            }
            case BIGINT: {
                return data.getLong(i);
            }
            case BLOB: {
                return data.getBytes(i);
            }
            case BOOLEAN: {
                return data.getBool(i);
            }
            case COUNTER: {
                return data.getLong(i);
            }
            case DECIMAL: {
                return data.getDecimal(i);
            }
            case DOUBLE: {
                return data.getDouble(i);
            }
            case FLOAT: {
                return Float.valueOf(data.getFloat(i));
            }
            case INET: {
                return data.getInet(i);
            }
            case TINYINT: {
                return data.getByte(i);
            }
            case SMALLINT: {
                return data.getShort(i);
            }
            case INT: {
                return data.getInt(i);
            }
            case TEXT: {
                return data.getString(i);
            }
            case TIMESTAMP: {
                return data.getTimestamp(i);
            }
            case DATE: {
                return data.getDate(i);
            }
            case TIME: {
                return data.getTime(i);
            }
            case UUID: {
                return data.getUUID(i);
            }
            case VARCHAR: {
                return data.getString(i);
            }
            case VARINT: {
                return data.getVarint(i);
            }
            case TIMEUUID: {
                return data.getUUID(i);
            }
            case LIST: {
                Class listEltClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(0)).getJavaType().getRawType();
                return data.getList(i, listEltClass);
            }
            case SET: {
                Class setEltClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(0)).getJavaType().getRawType();
                return data.getSet(i, setEltClass);
            }
            case MAP: {
                Class keyClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(0)).getJavaType().getRawType();
                Class valueClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(1)).getJavaType().getRawType();
                return data.getMap(i, keyClass, valueClass);
            }
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    public static Object getValue(GettableByNameData data, String name, DataType type, CodecRegistry codecRegistry) {
        switch (type.getName()) {
            case ASCII: {
                return data.getString(name);
            }
            case BIGINT: {
                return data.getLong(name);
            }
            case BLOB: {
                return data.getBytes(name);
            }
            case BOOLEAN: {
                return data.getBool(name);
            }
            case COUNTER: {
                return data.getLong(name);
            }
            case DECIMAL: {
                return data.getDecimal(name);
            }
            case DOUBLE: {
                return data.getDouble(name);
            }
            case FLOAT: {
                return Float.valueOf(data.getFloat(name));
            }
            case INET: {
                return data.getInet(name);
            }
            case TINYINT: {
                return data.getByte(name);
            }
            case SMALLINT: {
                return data.getShort(name);
            }
            case INT: {
                return data.getInt(name);
            }
            case TEXT: {
                return data.getString(name);
            }
            case TIMESTAMP: {
                return data.getTimestamp(name);
            }
            case DATE: {
                return data.getDate(name);
            }
            case TIME: {
                return data.getTime(name);
            }
            case UUID: {
                return data.getUUID(name);
            }
            case VARCHAR: {
                return data.getString(name);
            }
            case VARINT: {
                return data.getVarint(name);
            }
            case TIMEUUID: {
                return data.getUUID(name);
            }
            case LIST: {
                Class listEltClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(0)).getJavaType().getRawType();
                return data.getList(name, listEltClass);
            }
            case SET: {
                Class setEltClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(0)).getJavaType().getRawType();
                return data.getSet(name, setEltClass);
            }
            case MAP: {
                Class keyClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(0)).getJavaType().getRawType();
                Class valueClass = codecRegistry.codecFor((DataType)type.getTypeArguments().get(1)).getJavaType().getRawType();
                return data.getMap(name, keyClass, valueClass);
            }
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    public static Object getFixedValue(final DataType type) {
        try {
            switch (type.getName()) {
                case ASCII: {
                    return "An ascii string";
                }
                case BIGINT: {
                    return 42L;
                }
                case BLOB: {
                    return ByteBuffer.wrap(new byte[]{4, 12, 1});
                }
                case BOOLEAN: {
                    return true;
                }
                case COUNTER: {
                    throw new UnsupportedOperationException("Cannot 'getSomeValue' for counters");
                }
                case DURATION: {
                    return Duration.from((String)"1h20m3s");
                }
                case DECIMAL: {
                    return new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
                }
                case DOUBLE: {
                    return 3.142519;
                }
                case FLOAT: {
                    return Float.valueOf(3.142519f);
                }
                case INET: {
                    return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
                }
                case TINYINT: {
                    return (byte)25;
                }
                case SMALLINT: {
                    return (short)26;
                }
                case INT: {
                    return 24;
                }
                case TEXT: {
                    return "A text string";
                }
                case TIMESTAMP: {
                    return new Date(1352288289L);
                }
                case DATE: {
                    return LocalDate.fromDaysSinceEpoch((int)0);
                }
                case TIME: {
                    return 54012123450000L;
                }
                case UUID: {
                    return UUID.fromString("087E9967-CCDC-4A9B-9036-05930140A41B");
                }
                case VARCHAR: {
                    return "A varchar string";
                }
                case VARINT: {
                    return new BigInteger("123456789012345678901234567890");
                }
                case TIMEUUID: {
                    return UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66");
                }
                case LIST: {
                    return new ArrayList<Object>(){
                        {
                            this.add(TestUtils.getFixedValue((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case SET: {
                    return new HashSet<Object>(){
                        {
                            this.add(TestUtils.getFixedValue((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case MAP: {
                    return new HashMap<Object, Object>(){
                        {
                            this.put(TestUtils.getFixedValue((DataType)type.getTypeArguments().get(0)), TestUtils.getFixedValue((DataType)type.getTypeArguments().get(1)));
                        }
                    };
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    public static Object getFixedValue2(final DataType type) {
        try {
            switch (type.getName()) {
                case ASCII: {
                    return "A different ascii string";
                }
                case BIGINT: {
                    return Long.MAX_VALUE;
                }
                case BLOB: {
                    ByteBuffer bb = ByteBuffer.allocate(64);
                    bb.putInt(51966);
                    bb.putShort((short)3);
                    bb.putShort((short)45);
                    return bb;
                }
                case BOOLEAN: {
                    return false;
                }
                case COUNTER: {
                    throw new UnsupportedOperationException("Cannot 'getSomeValue' for counters");
                }
                case DECIMAL: {
                    return new BigDecimal("12.3E+7");
                }
                case DOUBLE: {
                    return Double.POSITIVE_INFINITY;
                }
                case FLOAT: {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case INET: {
                    return InetAddress.getByName("123.123.123.123");
                }
                case TINYINT: {
                    return (byte)127;
                }
                case SMALLINT: {
                    return (short)Short.MAX_VALUE;
                }
                case INT: {
                    return Integer.MAX_VALUE;
                }
                case TEXT: {
                    return "r\u00e9sum\u00e9";
                }
                case TIMESTAMP: {
                    return new Date(872835240000L);
                }
                case DATE: {
                    return LocalDate.fromDaysSinceEpoch((int)0);
                }
                case TIME: {
                    return 54012123450000L;
                }
                case UUID: {
                    return UUID.fromString("067e6162-3b6f-4ae2-a171-2470b63dff00");
                }
                case VARCHAR: {
                    return "A different varchar r\u00e9sum\u00e9";
                }
                case VARINT: {
                    return new BigInteger(Integer.toString(Integer.MAX_VALUE) + "000");
                }
                case TIMEUUID: {
                    return UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66");
                }
                case LIST: {
                    return new ArrayList<Object>(){
                        {
                            this.add(TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case SET: {
                    return new HashSet<Object>(){
                        {
                            this.add(TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case MAP: {
                    return new HashMap<Object, Object>(){
                        {
                            this.put(TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(0)), TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(1)));
                        }
                    };
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    static Set<DataType> allPrimitiveTypes(final ProtocolVersion protocolVersion) {
        return Sets.filter((Set)DataType.allPrimitiveTypes(), (Predicate)new Predicate<DataType>(){

            public boolean apply(DataType dataType) {
                return protocolVersion.compareTo((Enum)dataType.getName().minProtocolVersion) >= 0;
            }
        });
    }

    public static void waitForUp(String node, Cluster cluster) {
        TestUtils.waitFor(node, cluster, TEST_BASE_NODE_WAIT, false);
    }

    public static void waitForUp(String node, Cluster cluster, int timeoutSeconds) {
        TestUtils.waitFor(node, cluster, timeoutSeconds, false);
    }

    public static void waitForDown(String node, Cluster cluster) {
        TestUtils.waitFor(node, cluster, TEST_BASE_NODE_WAIT * 3, true);
    }

    public static void waitForDown(String node, Cluster cluster, int timeoutSeconds) {
        TestUtils.waitFor(node, cluster, timeoutSeconds, true);
    }

    private static void waitFor(String node, Cluster cluster, int timeoutSeconds, boolean waitForDown) {
        if (waitForDown) {
            logger.debug("Waiting for node to leave: {}", (Object)node);
        } else {
            logger.debug("Waiting for upcoming node: {}", (Object)node);
        }
        if (waitForDown) {
            Futures.getUnchecked((Future)cluster.manager.submitSchemaRefresh(null, null, null, null));
        }
        if (waitForDown) {
            ConditionChecker.check().every(1L, TimeUnit.SECONDS).before(timeoutSeconds, TimeUnit.SECONDS).that(new HostIsDown(cluster, node)).becomesTrue();
        } else {
            ConditionChecker.check().every(1L, TimeUnit.SECONDS).before(timeoutSeconds, TimeUnit.SECONDS).that(new HostIsUp(cluster, node)).becomesTrue();
        }
    }

    public static String ipOfNode(int n) {
        return IP_PREFIX + n;
    }

    public static InetAddress addressOfNode(int i) {
        try {
            return InetAddress.getByName(IP_PREFIX + i);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Host findOrWaitForHost(Cluster cluster, int node, long duration, TimeUnit unit) {
        return TestUtils.findOrWaitForHost(cluster, TestUtils.ipOfNode(node), duration, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Host findOrWaitForHost(Cluster cluster, final String address, long duration, TimeUnit unit) {
        Host host = TestUtils.findHost(cluster, address);
        if (host == null) {
            final CountDownLatch addSignal = new CountDownLatch(1);
            StateListenerBase addListener = new StateListenerBase(){

                @Override
                public void onAdd(Host host) {
                    if (host.getAddress().getHostAddress().equals(address)) {
                        addSignal.countDown();
                    }
                }
            };
            cluster.register((Host.StateListener)addListener);
            try {
                if (addSignal.await(duration, unit)) {
                    host = TestUtils.findHost(cluster, address);
                }
            }
            catch (InterruptedException e) {
                Host host2 = null;
                return host2;
            }
            finally {
                cluster.unregister((Host.StateListener)addListener);
            }
        }
        return host;
    }

    public static Host findHost(Cluster cluster, int hostNumber) {
        return TestUtils.findHost(cluster, TestUtils.ipOfNode(hostNumber));
    }

    public static Host findHost(Cluster cluster, String address) {
        for (Host host : cluster.getMetadata().allHosts()) {
            if (!host.getAddress().getHostAddress().equals(address)) continue;
            return host;
        }
        return null;
    }

    public static Host findOrWaitForControlConnection(Cluster cluster, long duration, TimeUnit unit) {
        ControlConnection controlConnection = cluster.manager.controlConnection;
        long durationNs = TimeUnit.NANOSECONDS.convert(duration, unit);
        long start = System.nanoTime();
        while (System.nanoTime() - start < durationNs) {
            if (controlConnection.isOpen()) {
                return controlConnection.connectedHost();
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public static HostConnectionPool poolOf(Session session, int hostNumber) {
        SessionManager sessionManager = (SessionManager)session;
        return (HostConnectionPool)sessionManager.pools.get(TestUtils.findHost(session.getCluster(), hostNumber));
    }

    public static int numberOfLocalCoreConnections(Cluster cluster) {
        Configuration configuration = cluster.getConfiguration();
        return configuration.getPoolingOptions().getCoreConnectionsPerHost(HostDistance.LOCAL);
    }

    public static Scassandra createScassandraServer() {
        int binaryPort = TestUtils.findAvailablePort();
        int adminPort = TestUtils.findAvailablePort();
        return ScassandraFactory.createServer((String)TestUtils.ipOfNode(1), (int)binaryPort, (String)TestUtils.ipOfNode(1), (int)adminPort);
    }

    public static String generateIdentifier(String prefix) {
        AtomicInteger seq = new AtomicInteger(0);
        AtomicInteger previous = IDENTIFIERS.putIfAbsent(prefix, seq);
        if (previous != null) {
            seq = previous;
        }
        return prefix + seq.incrementAndGet();
    }

    public static synchronized int findAvailablePort() throws RuntimeException {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
            ss.setReuseAddress(true);
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }
    }

    public static void waitUntilPortIsUp(InetSocketAddress address) {
        ConditionChecker.check().before(5L, TimeUnit.MINUTES).that(address, PORT_IS_UP).becomesTrue();
    }

    public static void waitUntilPortIsDown(InetSocketAddress address) {
        ConditionChecker.check().before(5L, TimeUnit.MINUTES).that(address, PORT_IS_UP).becomesFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingPort(InetAddress address, int port) {
        logger.debug("Trying {}:{}...", (Object)address, (Object)port);
        boolean connectionSuccessful = false;
        Socket socket = null;
        try {
            socket = new Socket(address, port);
            connectionSuccessful = true;
            logger.debug("Successfully connected");
        }
        catch (IOException e) {
            logger.debug("Connection failed");
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.warn("Error closing socket to " + address, (Throwable)e);
                }
            }
        }
        return connectionSuccessful;
    }

    public static Cluster buildControlCluster(Cluster cluster, CCMAccess ccm) {
        Host controlHost = cluster.manager.controlConnection.connectedHost();
        List<InetSocketAddress> singleAddress = Collections.singletonList(controlHost.getSocketAddress());
        return Cluster.builder().addContactPoints(new InetAddress[]{controlHost.getSocketAddress().getAddress()}).withPort(ccm.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), singleAddress)).build();
    }

    public static QueryOptions nonDebouncingQueryOptions() {
        return new QueryOptions().setRefreshNodeIntervalMillis(0).setRefreshNodeListIntervalMillis(0).setRefreshSchemaIntervalMillis(0);
    }

    public static void executeNoFail(Runnable task, boolean logException) {
        block2: {
            try {
                task.run();
            }
            catch (Exception e) {
                if (!logException) break block2;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void executeNoFail(Callable<?> task, boolean logException) {
        block2: {
            try {
                task.call();
            }
            catch (Exception e) {
                if (!logException) break block2;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static long getFreeMemoryMB() {
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        return (bean.getFreePhysicalMemorySize() + bean.getFreeSwapSpaceSize()) / 1024L / 1024L;
    }

    public static ByteBuffer serializeForDynamicCompositeType(Object ... params) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        int size = 0;
        for (Object p : params) {
            if (p instanceof Integer) {
                ByteBuffer elt = ByteBuffer.allocate(9);
                elt.putShort((short)-32663);
                elt.putShort((short)4);
                elt.putInt((Integer)p);
                elt.put((byte)0);
                elt.flip();
                size += elt.remaining();
                l.add(elt);
                continue;
            }
            if (p instanceof String) {
                ByteBuffer bytes = ByteBuffer.wrap(((String)p).getBytes());
                ByteBuffer elt = ByteBuffer.allocate(4 + bytes.remaining() + 1);
                elt.putShort((short)-32653);
                elt.putShort((short)bytes.remaining());
                elt.put(bytes);
                elt.put((byte)0);
                elt.flip();
                size += elt.remaining();
                l.add(elt);
                continue;
            }
            throw new RuntimeException();
        }
        ByteBuffer res = ByteBuffer.allocate(size);
        for (ByteBuffer bb : l) {
            res.put(bb);
        }
        res.flip();
        return res;
    }

    public static ByteBuffer serializeForCompositeType(Object ... params) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        int size = 0;
        for (Object p : params) {
            if (p instanceof Integer) {
                ByteBuffer elt = ByteBuffer.allocate(7);
                elt.putShort((short)4);
                elt.putInt((Integer)p);
                elt.put((byte)0);
                elt.flip();
                size += elt.remaining();
                l.add(elt);
                continue;
            }
            if (p instanceof String) {
                ByteBuffer bytes = ByteBuffer.wrap(((String)p).getBytes());
                ByteBuffer elt = ByteBuffer.allocate(2 + bytes.remaining() + 1);
                elt.putShort((short)bytes.remaining());
                elt.put(bytes);
                elt.put((byte)0);
                elt.flip();
                size += elt.remaining();
                l.add(elt);
                continue;
            }
            throw new RuntimeException();
        }
        ByteBuffer res = ByteBuffer.allocate(size);
        for (ByteBuffer bb : l) {
            res.put(bb);
        }
        res.flip();
        return res;
    }

    public static Level setLogLevel(Class<?> logger, Level newLevel) {
        return TestUtils.setLogLevel(logger.getName(), newLevel);
    }

    public static Level setLogLevel(Logger logger, Level newLevel) {
        return TestUtils.setLogLevel(logger.getName(), newLevel);
    }

    public static Level setLogLevel(String logger, Level newLevel) {
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger((String)logger);
        Level oldLevel = log4jLogger.getLevel();
        log4jLogger.setLevel(newLevel);
        return oldLevel;
    }

    static {
        String ip_prefix = System.getProperty("ipprefix");
        if (ip_prefix == null || ip_prefix.isEmpty()) {
            ip_prefix = "127.0.1.";
        }
        IP_PREFIX = ip_prefix;
        logger = LoggerFactory.getLogger(TestUtils.class);
        TEST_BASE_NODE_WAIT = SystemProperties.getInt((String)"com.datastax.driver.TEST_BASE_NODE_WAIT", (int)60);
        IDENTIFIERS = new ConcurrentHashMap<String, AtomicInteger>();
        PORT_IS_UP = new Predicate<InetSocketAddress>(){

            public boolean apply(InetSocketAddress address) {
                return TestUtils.pingPort(address.getAddress(), address.getPort());
            }
        };
        nonQuietClusterCloseOptions = new NettyOptions(){

            public void onClusterClose(EventLoopGroup eventLoopGroup) {
                eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).syncUninterruptibly();
            }
        };
    }

    private static class HostIsUp
    implements Callable<Boolean> {
        private final Cluster cluster;
        private final String ip;

        public HostIsUp(Cluster cluster, String ip) {
            this.cluster = cluster;
            this.ip = ip;
        }

        @Override
        public Boolean call() throws Exception {
            Host host = TestUtils.findHost(this.cluster, this.ip);
            return host != null && host.isUp();
        }
    }

    private static class HostIsDown
    implements Callable<Boolean> {
        private final Cluster cluster;
        private final String ip;

        public HostIsDown(Cluster cluster, String ip) {
            this.cluster = cluster;
            this.ip = ip;
        }

        @Override
        public Boolean call() throws Exception {
            Host host = TestUtils.findHost(this.cluster, this.ip);
            return host == null || !host.isUp();
        }
    }
}

