/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.MockClocks;
import com.datastax.driver.core.ThreadLocalMonotonicTimestampGenerator;
import com.datastax.driver.core.TimestampGenerator;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ThreadLocalMonotonicTimestampGeneratorTest {
    @Test(groups={"unit"})
    public void should_generate_incrementing_timestamps_for_each_thread() throws InterruptedException {
        long fixedTime = 1L;
        final ThreadLocalMonotonicTimestampGenerator generator = new ThreadLocalMonotonicTimestampGenerator();
        generator.clock = new MockClocks.FixedTimeClock(1L);
        int testThreadsCount = 2;
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(testThreadsCount));
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)testThreadsCount);
        for (int i = 0; i < testThreadsCount; ++i) {
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 1000; ++i) {
                        Assert.assertEquals((long)generator.next(), (long)(1L + (long)i));
                    }
                }
            }));
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        try {
            Futures.allAsList((Iterable)futures).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AssertionError) {
                throw (AssertionError)((Object)cause);
            }
            Assert.fail((String)"Error in a test thread", (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"unit"})
    public void should_generate_incrementing_timestamps_on_clock_resync() {
        ThreadLocalMonotonicTimestampGenerator generator = new ThreadLocalMonotonicTimestampGenerator(0L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
        generator.clock = new MockClocks.BackInTimeClock();
        MemoryAppender appender = new MemoryAppender();
        Logger logger = Logger.getLogger(TimestampGenerator.class);
        Level originalLevel = logger.getLevel();
        logger.setLevel(Level.WARN);
        logger.addAppender((Appender)appender);
        String logFormat = "Clock skew detected: current tick (%d) was %d microseconds behind the last generated timestamp (%d), returned timestamps will be artificially incremented to guarantee monotonicity.";
        try {
            long start;
            long previous = start = generator.next();
            long next = 0L;
            for (int i = 0; i < 1001; ++i) {
                next = generator.next();
                Assert.assertEquals((long)next, (long)(previous + 1L));
                previous = next;
            }
            Assert.assertEquals((long)next, (long)(start + 1001L));
            Assertions.assertThat((String)appender.getNext()).containsOnlyOnce((CharSequence)"Clock skew detected:").containsOnlyOnce((CharSequence)String.format(logFormat, start - 1L, 1, start));
            Uninterruptibles.sleepUninterruptibly((long)1100L, (TimeUnit)TimeUnit.MILLISECONDS);
            next = generator.next();
            Assertions.assertThat((long)next).isEqualTo(previous + 1L);
            Assertions.assertThat((String)appender.getNext()).containsOnlyOnce((CharSequence)"Clock skew detected:").containsOnlyOnce((CharSequence)String.format(logFormat, start - 1002L, 2003, previous));
        }
        finally {
            logger.removeAppender((Appender)appender);
            logger.setLevel(originalLevel);
        }
    }
}

