/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ScassandraTestBase;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.ThreadingOptions;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.iterable.Extractor;
import org.mockito.Mockito;
import org.scassandra.http.client.ClosedConnectionReport;
import org.testng.annotations.Test;

public class ThreadingOptionsTest
extends ScassandraTestBase {
    private String customPrefix = "custom";
    private ThreadingOptions threadingOptions = new ThreadingOptions(){

        public ThreadFactory createThreadFactory(String clusterName, String executorName) {
            return new ThreadFactoryBuilder().setNameFormat(clusterName + "-" + ThreadingOptionsTest.this.customPrefix + "-" + executorName + "-%d").setThreadFactory((ThreadFactory)new DefaultThreadFactory("ignored name")).setDaemon(true).build();
        }

        public ExecutorService createExecutor(String clusterName) {
            return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.createThreadFactory(clusterName, "myExecutor"));
        }

        public ExecutorService createBlockingExecutor(String clusterName) {
            return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.createThreadFactory(clusterName, "myBlockingExecutor"));
        }

        public ScheduledExecutorService createReconnectionExecutor(String clusterName) {
            return new ScheduledThreadPoolExecutor(1, this.createThreadFactory(clusterName, "myReconnection"));
        }

        public ScheduledExecutorService createScheduledTasksExecutor(String clusterName) {
            return new ScheduledThreadPoolExecutor(1, this.createThreadFactory(clusterName, "myScheduled-task-worker"));
        }

        public ScheduledExecutorService createReaperExecutor(String clusterName) {
            return new ScheduledThreadPoolExecutor(1, this.createThreadFactory(clusterName, "myConnection-reaper"));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_provided_threading_options() {
        ThreadingOptions spy = (ThreadingOptions)Mockito.spy((Object)this.threadingOptions);
        Cluster cluster = this.createClusterBuilder().withPoolingOptions(new PoolingOptions().setConnectionsPerHost(HostDistance.LOCAL, 1, 1)).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(100L)).withThreadingOptions(spy).build();
        try {
            String clusterName = cluster.getClusterName();
            cluster.init();
            ((ThreadingOptions)Mockito.verify((Object)spy)).createExecutor(clusterName);
            ((ThreadingOptions)Mockito.verify((Object)spy)).createBlockingExecutor(clusterName);
            ((ThreadingOptions)Mockito.verify((Object)spy)).createReconnectionExecutor(clusterName);
            ((ThreadingOptions)Mockito.verify((Object)spy)).createScheduledTasksExecutor(clusterName);
            ((ThreadingOptions)Mockito.verify((Object)spy)).createReaperExecutor(clusterName);
            ((ThreadingOptions)Mockito.verify((Object)spy)).createThreadFactory(clusterName, "nio-worker");
            ((ThreadingOptions)Mockito.verify((Object)spy)).createThreadFactory(clusterName, "timeouter");
            cluster.connect();
            this.currentClient.disableListener();
            this.currentClient.closeConnections(ClosedConnectionReport.CloseType.CLOSE);
            TestUtils.waitForDown(TestUtils.IP_PREFIX + "1", cluster);
            this.currentClient.enableListener();
            TestUtils.waitForUp(TestUtils.IP_PREFIX + "1", cluster);
            Set<Thread> threads = Thread.getAllStackTraces().keySet();
            for (Thread thread : threads) {
                if (!thread.getName().startsWith(clusterName + "-" + this.customPrefix)) continue;
                Assertions.assertThat((boolean)thread.isDaemon()).isTrue();
            }
            final Pattern threadNamePattern = Pattern.compile(clusterName + "-" + this.customPrefix + "-(.*)-0");
            Assertions.assertThat(threads).extracting((Extractor)new Extractor<Thread, String>(){

                public String extract(Thread thread) {
                    Matcher matcher = threadNamePattern.matcher(thread.getName());
                    if (matcher.matches()) {
                        return matcher.group(1);
                    }
                    return thread.getName();
                }
            }).contains((Object[])new String[]{"nio-worker", "timeouter", "myExecutor", "myReconnection", "myScheduled-task-worker", "myConnection-reaper"});
        }
        finally {
            cluster.close();
        }
    }
}

