/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import com.datastax.driver.core.utils.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class TypeCodecNestedCollectionsIntegrationTest
extends CCMTestsSupport {
    private final String insertQuery = "INSERT INTO \"myTable\" (pk, v) VALUES (?, ?)";
    private final String selectQuery = "SELECT pk, v FROM \"myTable\" WHERE pk = ?";
    private BuiltStatement insertStmt;
    private BuiltStatement selectStmt;
    private int pk = 42;
    private List<Set<Map<MyInt, String>>> v;
    private TypeToken<List<Set<Map<MyInt, String>>>> listType = new TypeToken<List<Set<Map<MyInt, String>>>>(){};
    private TypeToken<Set<Map<MyInt, String>>> elementsType = new TypeToken<Set<Map<MyInt, String>>>(){};

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE IF NOT EXISTS \"myTable\" (pk int PRIMARY KEY, v frozen<list<frozen<set<frozen<map<int,text>>>>>>)");
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withCodecRegistry(new CodecRegistry().register((TypeCodec)new MyIntCodec()));
    }

    @BeforeClass(groups={"short"})
    public void setupData() {
        ImmutableMap map = ImmutableMap.of((Object)new MyInt(42), (Object)"foo", (Object)new MyInt(43), (Object)"bar");
        HashSet<ImmutableMap> set = new HashSet<ImmutableMap>();
        set.add(map);
        this.v = new ArrayList<Set<Map<MyInt, String>>>();
        this.v.add(set);
    }

    @BeforeMethod(groups={"short"})
    public void createBuiltStatements() throws Exception {
        this.insertStmt = QueryBuilder.insertInto((String)"\"myTable\"").value("pk", (Object)QueryBuilder.bindMarker()).value("v", (Object)QueryBuilder.bindMarker());
        this.selectStmt = QueryBuilder.select((String[])new String[]{"pk", "v"}).from("\"myTable\"").where(QueryBuilder.eq((String)"pk", (Object)QueryBuilder.bindMarker()));
    }

    @Test(groups={"short"})
    public void should_work_with_simple_statements() {
        this.session().execute("INSERT INTO \"myTable\" (pk, v) VALUES (?, ?)", new Object[]{this.pk, this.v});
        ResultSet rows = this.session().execute("SELECT pk, v FROM \"myTable\" WHERE pk = ?", new Object[]{this.pk});
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_work_with_prepared_statements_1() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (pk, v) VALUES (?, ?)").bind(new Object[]{this.pk, this.v}));
        PreparedStatement ps = this.session().prepare("SELECT pk, v FROM \"myTable\" WHERE pk = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind(new Object[]{this.pk}));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_work_with_prepared_statements_2() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (pk, v) VALUES (?, ?)").bind().setInt(0, this.pk).setList(1, this.v, this.elementsType));
        PreparedStatement ps = this.session().prepare("SELECT pk, v FROM \"myTable\" WHERE pk = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.pk));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_work_with_prepared_statements_3() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (pk, v) VALUES (?, ?)").bind().setInt(0, this.pk).set(1, this.v, this.listType));
        PreparedStatement ps = this.session().prepare("SELECT pk, v FROM \"myTable\" WHERE pk = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.pk));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_work_with_built_statements() {
        this.session().execute((Statement)this.session().prepare((RegularStatement)this.insertStmt).bind().setInt(0, this.pk).set(1, this.v, this.listType));
        PreparedStatement ps = this.session().prepare((RegularStatement)this.selectStmt);
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.pk));
        Row row = rows.one();
        this.assertRow(row);
    }

    private void assertRow(Row row) {
        Assertions.assertThat((List)row.getList(1, this.elementsType)).isEqualTo(this.v);
        Assertions.assertThat((List)((List)row.get(1, this.listType))).isEqualTo(this.v);
    }

    private class MyIntCodec
    extends TypeCodec<MyInt> {
        MyIntCodec() {
            super(DataType.cint(), MyInt.class);
        }

        public ByteBuffer serialize(MyInt value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return TypeCodec.cint().serialize(Integer.valueOf(value.i), protocolVersion);
        }

        public MyInt deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return new MyInt(TypeCodec.cint().deserialize(bytes, protocolVersion));
        }

        public MyInt parse(String value) throws InvalidTypeException {
            return null;
        }

        public String format(MyInt value) throws InvalidTypeException {
            return null;
        }
    }

    private class MyInt {
        private final int i;

        private MyInt(int i) {
            this.i = i;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyInt myInt = (MyInt)o;
            return MoreObjects.equal((Object)this.i, (Object)myInt.i);
        }

        public int hashCode() {
            return MoreObjects.hashCode((Object[])new Object[]{this.i});
        }
    }
}

