/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class NoHostAvailableExceptionTest {
    @Test(groups={"unit"})
    public void should_build_default_message_when_less_than_3_errors() {
        NoHostAvailableException e = new NoHostAvailableException(NoHostAvailableExceptionTest.buildMockErrors(3));
        String message = e.getMessage();
        Assertions.assertThat((String)message).startsWith((CharSequence)"All host(s) tried for query failed");
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.1:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 1)"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.2:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 2)"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.3:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 3)"});
    }

    @Test(groups={"unit"})
    public void should_build_default_message_when_more_than_3_errors() {
        NoHostAvailableException e = new NoHostAvailableException(NoHostAvailableExceptionTest.buildMockErrors(4));
        String message = e.getMessage();
        Assertions.assertThat((String)message).startsWith((CharSequence)"All host(s) tried for query failed");
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.1:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 1)"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.2:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 2)"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.3:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 3)"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"only showing errors of first 3 hosts, use getErrors() for more details"});
    }

    @Test(groups={"unit"})
    public void should_build_formatted_message_without_stack_traces() {
        NoHostAvailableException e = new NoHostAvailableException(NoHostAvailableExceptionTest.buildMockErrors(3));
        String message = e.getCustomMessage(3, true, false);
        Assertions.assertThat((String)message).startsWith((CharSequence)"All host(s) tried for query failed (tried:\n");
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.1:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 1)\n"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.2:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 2)\n"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.3:9042 (com.datastax.driver.core.exceptions.NoHostAvailableExceptionTest$MockError: mock error 3)\n"});
    }

    @Test(groups={"unit"})
    public void should_build_formatted_message_with_stack_traces() {
        NoHostAvailableException e = new NoHostAvailableException(NoHostAvailableExceptionTest.buildMockErrors(3));
        String message = e.getCustomMessage(3, true, true);
        Assertions.assertThat((String)message).startsWith((CharSequence)"All host(s) tried for query failed (tried:\n");
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.1:9042\nmock stack trace 1\n"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.3:9042\nmock stack trace 3\n"});
        Assertions.assertThat((String)message).contains(new CharSequence[]{"/127.0.0.2:9042\nmock stack trace 2\n"});
    }

    private static Map<InetSocketAddress, Throwable> buildMockErrors(int count) {
        HashMap<InetSocketAddress, Throwable> errors = new HashMap<InetSocketAddress, Throwable>();
        for (int i = 1; i <= count; ++i) {
            errors.put(new InetSocketAddress("127.0.0." + i, 9042), new MockError(i));
        }
        return errors;
    }

    static class MockError
    extends Exception {
        private final int i;

        MockError(int i) {
            super("mock error " + i);
            this.i = i;
        }

        @Override
        public void printStackTrace(PrintWriter writer) {
            writer.printf("mock stack trace %d", this.i);
        }
    }
}

