/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.QueryTracker;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SortingLoadBalancingPolicy;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.Clock;
import com.datastax.driver.core.policies.ErrorAwarePolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Mockito;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ErrorAwarePolicyIntegrationTest {
    private QueryTracker queryTracker;
    private Clock clock;
    private ScassandraCluster sCluster;
    private AtomicInteger errorCounter;
    private LatencyTracker latencyTracker;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.queryTracker = new QueryTracker();
        this.clock = (Clock)Mockito.mock(Clock.class);
        this.sCluster = ScassandraCluster.builder().withNodes(2).build();
        this.sCluster.init();
        this.errorCounter = new AtomicInteger(0);
        this.latencyTracker = new LatencyTracker(){

            public void update(Host host, Statement statement, Exception exception, long newLatencyNanos) {
                if (exception != null) {
                    ErrorAwarePolicyIntegrationTest.this.errorCounter.incrementAndGet();
                }
            }

            public void onRegister(Cluster cluster) {
            }

            public void onUnregister(Cluster cluster) {
            }
        };
        this.prime(1, Result.unauthorized);
        this.prime(2, Result.success);
    }

    @AfterMethod(groups={"short"})
    public void tearDown() {
        this.sCluster.stop();
    }

    private Cluster.Builder builder(LoadBalancingPolicy lbp) {
        return Cluster.builder().withNettyOptions(TestUtils.nonQuietClusterCloseOptions).addContactPoints(new InetAddress[]{this.sCluster.address(1).getAddress()}).withPort(this.sCluster.getBinaryPort()).withLoadBalancingPolicy(lbp);
    }

    private void prime(int node, Result result) {
        this.sCluster.node(node).primingClient().prime(PrimingRequest.queryBuilder().withQuery("select * from test.foo").withThen(PrimingRequest.then().withResult(result)).build());
    }

    private void awaitTrackerUpdate(final int expectedCount) {
        ConditionChecker.check().every(10L).that(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ErrorAwarePolicyIntegrationTest.this.errorCounter.get() >= expectedCount;
            }
        }).before(5000L).becomesTrue();
    }

    private void setTime(long time, TimeUnit timeUnit) {
        Mockito.when((Object)this.clock.nanoTime()).thenReturn((Object)TimeUnit.NANOSECONDS.convert(time, timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_exclude_host_after_reaching_maximum_errors() throws InterruptedException {
        ErrorAwarePolicy lbp = ErrorAwarePolicy.builder((LoadBalancingPolicy)new SortingLoadBalancingPolicy()).withMaxErrorsPerMinute(1).withClock(this.clock).build();
        Cluster cluster = this.builder((LoadBalancingPolicy)lbp).build();
        try {
            Session session = cluster.connect();
            cluster.register(this.latencyTracker);
            this.setTime(0L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 2, UnauthorizedException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(2);
            this.setTime(5L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 1, this.sCluster.address(2));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_resurrect_host_after_retry_period() throws InterruptedException {
        ErrorAwarePolicy lbp = ErrorAwarePolicy.builder((LoadBalancingPolicy)new SortingLoadBalancingPolicy()).withMaxErrorsPerMinute(1).withRetryPeriod(70L, TimeUnit.SECONDS).withClock(this.clock).build();
        Cluster cluster = this.builder((LoadBalancingPolicy)lbp).build();
        try {
            Session session = cluster.connect();
            cluster.register(this.latencyTracker);
            this.setTime(0L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 2, UnauthorizedException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(2);
            this.setTime(5L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 5, this.sCluster.address(2));
            this.setTime(75L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 1, UnauthorizedException.class, this.sCluster.address(1));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_not_penalize_default_ignored_exceptions() throws InterruptedException {
        ErrorAwarePolicy lbp = ErrorAwarePolicy.builder((LoadBalancingPolicy)new SortingLoadBalancingPolicy()).withMaxErrorsPerMinute(1).withClock(this.clock).build();
        Cluster cluster = this.builder((LoadBalancingPolicy)lbp).withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE).build();
        try {
            Session session = cluster.connect();
            cluster.register(this.latencyTracker);
            this.setTime(0L, TimeUnit.SECONDS);
            this.prime(1, Result.read_request_timeout);
            this.queryTracker.query(session, 10, ReadTimeoutException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(10);
            this.setTime(5L, TimeUnit.SECONDS);
            this.prime(1, Result.write_request_timeout);
            this.queryTracker.query(session, 10, WriteTimeoutException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(20);
            this.setTime(10L, TimeUnit.SECONDS);
            this.prime(1, Result.unavailable);
            this.queryTracker.query(session, 10, UnavailableException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(30);
            this.setTime(15L, TimeUnit.SECONDS);
            this.prime(1, Result.already_exists);
            this.queryTracker.query(session, 10, AlreadyExistsException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(40);
            this.setTime(20L, TimeUnit.SECONDS);
            this.prime(1, Result.invalid);
            this.queryTracker.query(session, 10, InvalidQueryException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(50);
            this.setTime(25L, TimeUnit.SECONDS);
            this.prime(1, Result.syntax_error);
            this.queryTracker.query(session, 10, SyntaxError.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(60);
            this.setTime(30L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 10, SyntaxError.class, this.sCluster.address(1));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_only_consider_exceptions_based_on_errors_filter() throws InterruptedException {
        ErrorAwarePolicy.ErrorFilter iqeOnlyFilter = new ErrorAwarePolicy.ErrorFilter(){

            public boolean shouldConsiderError(Exception e, Host host, Statement statement) {
                return e.getClass().isAssignableFrom(InvalidQueryException.class);
            }
        };
        ErrorAwarePolicy lbp = ErrorAwarePolicy.builder((LoadBalancingPolicy)new SortingLoadBalancingPolicy()).withMaxErrorsPerMinute(1).withClock(this.clock).withErrorsFilter(iqeOnlyFilter).build();
        Cluster cluster = this.builder((LoadBalancingPolicy)lbp).withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE).build();
        try {
            Session session = cluster.connect();
            cluster.register(this.latencyTracker);
            this.setTime(0L, TimeUnit.SECONDS);
            this.prime(1, Result.unauthorized);
            this.queryTracker.query(session, 10, UnauthorizedException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(10);
            this.setTime(5L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 1, UnauthorizedException.class, this.sCluster.address(1));
            this.prime(1, Result.invalid);
            this.queryTracker.query(session, 2, InvalidQueryException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(13);
            this.setTime(10L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 1, this.sCluster.address(2));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_regard_defaults() throws InterruptedException {
        ErrorAwarePolicy lbp = ErrorAwarePolicy.builder((LoadBalancingPolicy)new SortingLoadBalancingPolicy()).withClock(this.clock).build();
        Cluster cluster = this.builder((LoadBalancingPolicy)lbp).build();
        try {
            Session session = cluster.connect();
            cluster.register(this.latencyTracker);
            this.setTime(0L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 2, UnauthorizedException.class, this.sCluster.address(1));
            this.awaitTrackerUpdate(2);
            this.setTime(5L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 5, this.sCluster.address(2));
            this.setTime(35L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 5, this.sCluster.address(2));
            this.setTime(125L, TimeUnit.SECONDS);
            this.queryTracker.query(session, 1, UnauthorizedException.class, this.sCluster.address(1));
        }
        finally {
            cluster.close();
        }
    }
}

