/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryTracker;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(createCcm={false})
public class TokenAwarePolicyTest
extends CCMTestsSupport {
    QueryTracker queryTracker;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.queryTracker = new QueryTracker();
    }

    @DataProvider(name="shuffleProvider")
    public Object[][] shuffleProvider() {
        return new Object[][]{{true}, {false}, {null}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="shuffleProvider")
    public void should_shuffle_replicas_based_on_configuration(Boolean shuffleReplicas) {
        TokenAwarePolicy loadBalancingPolicy;
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(8).withSimpleKeyspace("keyspace", 3).build();
        if (shuffleReplicas == null) {
            loadBalancingPolicy = new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy());
            shuffleReplicas = true;
        } else {
            loadBalancingPolicy = new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy(), shuffleReplicas.booleanValue());
        }
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withLoadBalancingPolicy((LoadBalancingPolicy)loadBalancingPolicy).build();
        try {
            sCluster.init();
            ByteBuffer routingKey = TypeCodec.varchar().serialize((Object)"This is some sample text", ProtocolVersion.NEWEST_SUPPORTED);
            ArrayList replicas = Lists.newArrayList((Iterable)cluster.getMetadata().getReplicas("keyspace", routingKey));
            Assertions.assertThat((List)replicas).containsExactly((Object[])new Host[]{sCluster.host(cluster, 1, 6), sCluster.host(cluster, 1, 7), sCluster.host(cluster, 1, 8)});
            SimpleStatement statement = new SimpleStatement("select * from table where k=5");
            statement.setRoutingKey(routingKey);
            statement.setKeyspace("keyspace");
            boolean shuffledAtLeastOnce = false;
            for (int i = 0; i < 1024; ++i) {
                ArrayList queryPlan = Lists.newArrayList((Iterator)loadBalancingPolicy.newQueryPlan(null, (Statement)statement));
                Assertions.assertThat((List)queryPlan).containsOnlyElementsOf((Iterable)cluster.getMetadata().getAllHosts());
                List firstThree = queryPlan.subList(0, 3);
                if (shuffleReplicas.booleanValue()) {
                    Assertions.assertThat(firstThree).containsOnlyElementsOf((Iterable)replicas);
                    if (firstThree.equals(replicas)) continue;
                    shuffledAtLeastOnce = true;
                    continue;
                }
                Assertions.assertThat(firstThree).containsExactlyElementsOf((Iterable)replicas);
            }
            Assertions.assertThat((boolean)shuffledAtLeastOnce).isEqualTo((Object)shuffleReplicas);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_choose_proper_host_based_on_routing_key() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(3).withSimpleKeyspace("keyspace", 1).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            ByteBuffer routingKey = TypeCodec.varchar().serialize((Object)"should_choose_proper_host_based_on_routing_key", ProtocolVersion.NEWEST_SUPPORTED);
            SimpleStatement statement = new SimpleStatement("select * from table where k=5").setRoutingKey(routingKey).setKeyspace("keyspace");
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 10);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_choose_proper_host_based_on_token_range() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(3).withSimpleKeyspace("keyspace", 1).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            ByteBuffer routingKey = TypeCodec.varchar().serialize((Object)"should_choose_proper_host_based_on_routing_key", ProtocolVersion.NEWEST_SUPPORTED);
            Host host2 = TestUtils.findHost(cluster, 2);
            Set ranges = cluster.getMetadata().getTokenRanges("keyspace", host2);
            Assertions.assertThat((Iterable)ranges).hasSize(1);
            TokenRange range = (TokenRange)ranges.iterator().next();
            RegularStatement statement = new SimpleStatement("select * from table where k=5").setRoutingKey(routingKey).setKeyspace("keyspace").setRoutingToken(range.getEnd());
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 10);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_choose_host_in_local_dc_when_using_network_topology_strategy_and_dc_aware() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(3, 3).withNetworkTopologyKeyspace("keyspace", (Map<Integer, Integer>)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)1)).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(ScassandraCluster.datacenter(2)).withUsedHostsPerRemoteDc(3).build())).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            ByteBuffer routingKey = TypeCodec.varchar().serialize((Object)"should_choose_host_in_local_dc_when_using_network_topology_strategy_and_dc_aware", ProtocolVersion.NEWEST_SUPPORTED);
            SimpleStatement statement = new SimpleStatement("select * from table where k=5").setRoutingKey(routingKey).setKeyspace("keyspace");
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 2, 1, 10);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_other_nodes_when_replicas_having_token_are_down() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(4).withSimpleKeyspace("keyspace", 2).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(2).getAddress()}).withPort(sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy(), false)).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            ByteBuffer routingKey = TypeCodec.varchar().serialize((Object)"should_use_other_nodes_when_replicas_having_token_are_down", ProtocolVersion.NEWEST_SUPPORTED);
            SimpleStatement statement = new SimpleStatement("select * from table where k=5").setRoutingKey(routingKey).setKeyspace("keyspace");
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 10);
            this.queryTracker.reset();
            sCluster.stop(cluster, 4);
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 10);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 0);
            this.queryTracker.reset();
            sCluster.stop(cluster, 1);
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 5);
            this.queryTracker.assertQueried(sCluster, 1, 3, 5);
            this.queryTracker.assertQueried(sCluster, 1, 4, 0);
            this.queryTracker.reset();
            sCluster.start(cluster, 1);
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 10);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 0);
            this.queryTracker.reset();
            sCluster.start(cluster, 4);
            this.queryTracker.query(session, 10, (Statement)statement);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 10);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_provided_routing_key_boundstatement() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(4).withSimpleKeyspace("keyspace", 1).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(2).getAddress()}).withPort(sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy(), false)).build();
        try {
            sCluster.init();
            Session session = cluster.connect("keyspace");
            PreparedStatement preparedStatement = session.prepare("insert into tbl (k0, v) values (?, ?)");
            BoundStatement bs = preparedStatement.bind(new Object[]{"a", "b"});
            ByteBuffer routingKey = TypeCodec.bigint().serialize(Long.valueOf(33L), ProtocolVersion.NEWEST_SUPPORTED);
            bs.setRoutingKey(routingKey);
            this.queryTracker.query(session, 10, (Statement)bs);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 10);
            this.queryTracker.reset();
            bs = preparedStatement.bind(new Object[]{"a", "b"});
            ByteBuffer routingKeyK0Part = TypeCodec.bigint().serialize(Long.valueOf(42L), ProtocolVersion.NEWEST_SUPPORTED);
            ByteBuffer routingKeyK1Part = TypeCodec.varchar().serialize((Object)"hello_world", ProtocolVersion.NEWEST_SUPPORTED);
            bs.setRoutingKey(new ByteBuffer[]{routingKeyK0Part, routingKeyK1Part});
            this.queryTracker.query(session, 10, (Statement)bs);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 10);
            this.queryTracker.assertQueried(sCluster, 1, 4, 0);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    @CCMConfig(createCcm={true}, numberOfNodes={3}, createCluster={false})
    @Test(groups={"long"})
    public void should_properly_generate_and_use_routing_key_for_composite_partition_key() {
        Cluster cluster = this.register(Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).build());
        Session session = cluster.connect();
        String table = "composite";
        String ks = TestUtils.generateIdentifier("ks_");
        session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", ks, 1));
        session.execute("USE " + ks);
        session.execute(String.format("CREATE TABLE %s (k1 int, k2 int, i int, PRIMARY KEY ((k1, k2)))", table));
        PreparedStatement insertPs = session.prepare("INSERT INTO " + table + "(k1, k2, i) VALUES (?, ?, ?)");
        BoundStatement insertBs = insertPs.bind(new Object[]{1, 2, 3});
        PreparedStatement selectPs = session.prepare("SELECT * FROM " + table + " WHERE k1=? and k2=?");
        BoundStatement selectBs = selectPs.bind(new Object[]{1, 2});
        for (int i = 0; i < 10; ++i) {
            ResultSet rs = session.execute((Statement)insertBs);
            Assertions.assertThat(rs.getExecutionInfo().getQueriedHost()).isEqualTo(TestUtils.findHost(cluster, 1));
            rs = session.execute((Statement)selectBs);
            Assertions.assertThat(rs.getExecutionInfo().getQueriedHost()).isEqualTo(TestUtils.findHost(cluster, 1));
            Assertions.assertThat((boolean)rs.isExhausted()).isFalse();
            Row r = rs.one();
            Assertions.assertThat((boolean)rs.isExhausted()).isTrue();
            Assertions.assertThat((int)r.getInt("i")).isEqualTo(3);
        }
    }
}

