/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryBuilderTest {
    @Test(groups={"unit"})
    public void selectTest() throws Exception {
        String query = "SELECT * FROM foo WHERE k=4 AND c>'a' AND c<='z';";
        Select.Where select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gt((String)"c", (Object)"a")).and(QueryBuilder.lte((String)"c", (Object)"z"));
        Assert.assertEquals((String)select.toString(), (String)query);
        select = QueryBuilder.select().all().from("foo").where().and(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gt((String)"c", (Object)"a")).and(QueryBuilder.lte((String)"c", (Object)"z"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a,b,\"C\" FROM foo WHERE a IN ('127.0.0.1','127.0.0.3') AND \"C\"='foo' ORDER BY a ASC,b DESC LIMIT 42;";
        select = QueryBuilder.select((String[])new String[]{"a", "b", QueryBuilder.quote((String)"C")}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.0.0.3")})).and(QueryBuilder.eq((String)QueryBuilder.quote((String)"C"), (Object)"foo")).orderBy(new Ordering[]{QueryBuilder.asc((String)"a"), QueryBuilder.desc((String)"b")}).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(a),ttl(a) FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a").ttl("a").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT DISTINCT longName AS a,ttl(longName) AS ttla FROM foo LIMIT :limit;";
        select = QueryBuilder.select().distinct().column("longName").as("a").ttl("longName").as("ttla").from("foo").limit(QueryBuilder.bindMarker((String)"limit"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT DISTINCT longName AS a,ttl(longName) AS ttla FROM foo WHERE k IN () LIMIT :limit;";
        select = QueryBuilder.select().distinct().column("longName").as("a").ttl("longName").as("ttla").from("foo").where(QueryBuilder.in((String)"k", (Object[])new Object[0])).limit(QueryBuilder.bindMarker((String)"limit"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE bar=:barmark AND baz=:bazmark LIMIT :limit;";
        select = QueryBuilder.select().all().from("foo").where().and(QueryBuilder.eq((String)"bar", (Object)QueryBuilder.bindMarker((String)"barmark"))).and(QueryBuilder.eq((String)"baz", (Object)QueryBuilder.bindMarker((String)"bazmark"))).limit(QueryBuilder.bindMarker((String)"limit"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a FROM foo WHERE k IN ();";
        select = QueryBuilder.select((String[])new String[]{"a"}).from("foo").where(QueryBuilder.in((String)"k", (Object[])new Object[0]));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a FROM foo WHERE k IN ?;";
        select = QueryBuilder.select((String[])new String[]{"a"}).from("foo").where(QueryBuilder.in((String)"k", (Object[])new Object[]{QueryBuilder.bindMarker()}));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT DISTINCT a FROM foo WHERE k=1;";
        select = QueryBuilder.select((String[])new String[]{"a"}).distinct().from("foo").where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT DISTINCT a,b FROM foo WHERE k=1;";
        select = QueryBuilder.select((String[])new String[]{"a", "b"}).distinct().from("foo").where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT count(*) FROM foo;";
        select = QueryBuilder.select().countAll().from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT intToBlob(b) FROM foo;";
        select = QueryBuilder.select().fcall("intToBlob", new Object[]{QueryBuilder.column((String)"b")}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k>42 LIMIT 42;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)"k", (Object)42)).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE token(k)>token(42);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo2 WHERE token(a,b)>token(42,101);";
        select = QueryBuilder.select().all().from("foo2").where(QueryBuilder.gt((String)QueryBuilder.token((String[])new String[]{"a", "b"}), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42, 101})));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM words WHERE w='):,ydL ;O,D';";
        select = QueryBuilder.select().all().from("words").where(QueryBuilder.eq((String)"w", (Object)"):,ydL ;O,D"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM words WHERE w='WA(!:gS)r(UfW';";
        select = QueryBuilder.select().all().from("words").where(QueryBuilder.eq((String)"w", (Object)"WA(!:gS)r(UfW"));
        Assert.assertEquals((String)select.toString(), (String)query);
        Date date = new Date();
        date.setTime(1234325L);
        query = "SELECT * FROM foo WHERE d=1234325;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"d", (Object)date));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE b=0xcafebabe;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"b", (Object)Bytes.fromHexString((String)"0xCAFEBABE")));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE e CONTAINS 'text';";
        select = QueryBuilder.select().from("foo").where(QueryBuilder.contains((String)"e", (Object)"text"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE e CONTAINS KEY 'key1';";
        select = QueryBuilder.select().from("foo").where(QueryBuilder.containsKey((String)"e", (Object)"key1"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT CAST(writetime(country) AS text) FROM artists LIMIT 2;";
        select = QueryBuilder.select().cast(QueryBuilder.fcall((String)"writetime", (Object[])new Object[]{QueryBuilder.column((String)"country")}), DataType.text()).from("artists").limit(2);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT avg(CAST(v AS float)) FROM e;";
        select = QueryBuilder.select().fcall("avg", new Object[]{QueryBuilder.cast((Object)QueryBuilder.column((String)"v"), (DataType)DataType.cfloat())}).from("e");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT CAST(writetime(country) AS text) FROM artists LIMIT 2;";
        select = QueryBuilder.select().raw("CAST(writetime(country) AS text)").from("artists").limit(2);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE e LIKE 'a%';";
        select = QueryBuilder.select().from("foo").where(QueryBuilder.like((String)"e", (Object)"a%"));
        Assert.assertEquals((String)select.toString(), (String)query);
        try {
            QueryBuilder.select().countAll().from("foo").orderBy(new Ordering[]{QueryBuilder.asc((String)"a"), QueryBuilder.desc((String)"b")}).orderBy(new Ordering[]{QueryBuilder.asc((String)"a"), QueryBuilder.desc((String)"b")});
            Assertions.fail((String)"Expected an IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"An ORDER BY clause has already been provided");
        }
        try {
            QueryBuilder.select().from("foo").orderBy(new Ordering[0]);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid ORDER BY argument, the orderings must not be empty.");
        }
        try {
            QueryBuilder.select().column("a").all().from("foo");
            Assertions.fail((String)"Expected an IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Some columns ([a]) have already been selected.");
        }
        try {
            QueryBuilder.select().column("a").countAll().from("foo");
            Assertions.fail((String)"Expected an IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Some columns ([a]) have already been selected.");
        }
        try {
            QueryBuilder.select().all().from("foo").limit(-42);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid LIMIT value, must be strictly positive");
        }
        try {
            QueryBuilder.select().all().from("foo").limit(42).limit(42);
            Assertions.fail((String)"Expected an IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"A LIMIT value has already been provided");
        }
    }

    @Test(groups={"unit"})
    public void insertTest() throws Exception {
        String query = "INSERT INTO foo (a,b,\"C\",d) VALUES (123,'127.0.0.1','foo''bar',{'x':3,'y':2}) USING TIMESTAMP 42 AND TTL 24;";
        Insert.Options insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)123).value("b", (Object)InetAddress.getByName("127.0.0.1")).value(QueryBuilder.quote((String)"C"), (Object)"foo'bar").value("d", (Object)new TreeMap<String, Integer>(){
            {
                this.put("x", 3);
                this.put("y", 2);
            }
        }).using(QueryBuilder.timestamp((long)42L)).and(QueryBuilder.ttl((int)24));
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo (a,b) VALUES (2,null);";
        insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)2).value("b", null);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo (a,b) VALUES ({2,3,4},3.4) USING TTL 24 AND TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4}).using(QueryBuilder.ttl((int)24)).and(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo.bar (a,b) VALUES ({2,3,4},3.4) USING TTL ? AND TIMESTAMP ?;";
        insert = QueryBuilder.insertInto((String)"foo", (String)"bar").values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4}).using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker())).and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo.bar (a,b,c) VALUES ({2,3,4},3.4,123) USING TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4}).value("c", (Object)123);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo (c,a,b) VALUES (123,{2,3,4},3.4) USING TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").using(QueryBuilder.timestamp((long)42L)).value("c", (Object)123).values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4});
        Assert.assertEquals((String)insert.toString(), (String)query);
        try {
            QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{1, 2, 3});
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Got 2 names but 3 values");
        }
        query = "INSERT INTO foo (k,x) VALUES (0,1) IF NOT EXISTS;";
        insert = QueryBuilder.insertInto((String)"foo").value("k", (Object)0).value("x", (Object)1).ifNotExists();
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void updateTest() throws Exception {
        String query = "UPDATE foo.bar USING TIMESTAMP 42 SET a=12,b=[3,2,1],c=c+3 WHERE k=2;";
        Update.Where update = QueryBuilder.update((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).and(QueryBuilder.set((String)"b", Arrays.asList(3, 2, 1))).and(QueryBuilder.incr((String)"c", (long)3L)).where(QueryBuilder.eq((String)"k", (Object)2));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=null WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.set((String)"b", null));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET a[2]='foo',b=[3,2,1]+b,c=c-{'a'} WHERE k=2 AND l='foo' AND m<4 AND n>=1;";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.setIdx((String)"a", (int)2, (Object)"foo")).and(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1))).and(QueryBuilder.remove((String)"c", (Object)"a")).where(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).and(QueryBuilder.lt((String)"m", (Object)4)).and(QueryBuilder.gte((String)"n", (Object)1));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=[3]+b,c=c+['a'],d=d+[1,2,3],e=e-[1];";
        update = QueryBuilder.update((String)"foo").with().and(QueryBuilder.prepend((String)"b", (Object)3)).and(QueryBuilder.append((String)"c", (Object)"a")).and(QueryBuilder.appendAll((String)"d", Arrays.asList(1, 2, 3))).and(QueryBuilder.discard((String)"e", (Object)1));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=b-[1,2,3],c=c+{1},d=d+{2,3,4};";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.discardAll((String)"b", Arrays.asList(1, 2, 3))).and(QueryBuilder.add((String)"c", (Object)1)).and(QueryBuilder.addAll((String)"d", (Set)new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=b-{2,3,4},c['k']='v',d=d+{'x':3,'y':2};";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.removeAll((String)"b", (Set)new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        })).and(QueryBuilder.put((String)"c", (Object)"k", (Object)"v")).and(QueryBuilder.putAll((String)"d", (Map)new TreeMap<String, Integer>(){
            {
                this.put("x", 3);
                this.put("y", 2);
            }
        }));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TTL 400;";
        update = QueryBuilder.update((String)"foo").using(QueryBuilder.ttl((int)400));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET a=" + new BigDecimal(3.2) + ",b=42 WHERE k=2;";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"a", (Object)new BigDecimal(3.2))).and(QueryBuilder.set((String)"b", (Object)new BigInteger("42"))).where(QueryBuilder.eq((String)"k", (Object)2));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TIMESTAMP 42 SET b=[3,2,1]+b WHERE k=2 AND l='foo';";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).with(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)update.toString(), (String)query);
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1)));
        Assert.assertEquals((String)update.toString(), (String)query);
        update = QueryBuilder.update((String)"foo").using(QueryBuilder.timestamp((long)42L)).where(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).with(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1)));
        Assert.assertEquals((String)update.toString(), (String)query);
        try {
            QueryBuilder.update((String)"foo").using(QueryBuilder.ttl((int)-400));
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid ttl, must be positive");
        }
        query = "UPDATE foo SET x=4 WHERE k=0 IF x=1;";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"x", (Object)4)).where(QueryBuilder.eq((String)"k", (Object)0)).onlyIf(QueryBuilder.eq((String)"x", (Object)1));
        Assert.assertEquals((String)update.toString(), (String)query);
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"x", (Object)3)).where(QueryBuilder.eq((String)"k", (Object)2)).ifExists();
        Assertions.assertThat((String)update.toString()).isEqualTo((Object)"UPDATE foo SET x=3 WHERE k=2 IF EXISTS;");
    }

    @Test(groups={"unit"})
    public void deleteTest() throws Exception {
        String query = "DELETE a,b,c FROM foo USING TIMESTAMP 0 WHERE k=1;";
        Delete.Where delete = QueryBuilder.delete((String[])new String[]{"a", "b", "c"}).from("foo").using(QueryBuilder.timestamp((long)0L)).where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a[3],b['foo'],c FROM foo WHERE k=1;";
        delete = QueryBuilder.delete().listElt("a", 3).mapElt("b", (Object)"foo").column("c").from("foo").where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a[?],b[?],c FROM foo WHERE k=1;";
        delete = QueryBuilder.delete().listElt("a", QueryBuilder.bindMarker()).mapElt("b", (Object)QueryBuilder.bindMarker()).column("c").from("foo").where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b,c FROM foo;";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b", "c"}).from("foo");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo USING TIMESTAMP 1240003134 WHERE k='value';";
        delete = QueryBuilder.delete().all().from("foo").using(QueryBuilder.timestamp((long)1240003134L)).where(QueryBuilder.eq((String)"k", (Object)"value"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        delete = QueryBuilder.delete().from("foo").using(QueryBuilder.timestamp((long)1240003134L)).where(QueryBuilder.eq((String)"k", (Object)"value"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b,c FROM foo.bar USING TIMESTAMP 1240003134 WHERE k=1;";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b", "c"}).from("foo", "bar").where().and(QueryBuilder.eq((String)"k", (Object)1)).using(QueryBuilder.timestamp((long)1240003134L));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo.bar WHERE k1='foo' AND k2=1;";
        delete = QueryBuilder.delete().from("foo", "bar").where(QueryBuilder.eq((String)"k1", (Object)"foo")).and(QueryBuilder.eq((String)"k2", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        try {
            QueryBuilder.delete().column("a").all().from("foo");
            Assertions.fail((String)"Expected an IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Some columns ([a]) have already been selected.");
        }
        try {
            QueryBuilder.delete().from("foo").using(QueryBuilder.timestamp((long)-1240003134L));
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid timestamp, must be positive");
        }
        query = "DELETE FROM foo.bar WHERE k1='foo' IF EXISTS;";
        delete = QueryBuilder.delete().from("foo", "bar").where(QueryBuilder.eq((String)"k1", (Object)"foo")).ifExists();
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo.bar WHERE k1='foo' IF a=1 AND b=2;";
        delete = QueryBuilder.delete().from("foo", "bar").where(QueryBuilder.eq((String)"k1", (Object)"foo")).onlyIf(QueryBuilder.eq((String)"a", (Object)1)).and(QueryBuilder.eq((String)"b", (Object)2));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k=:key;";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)QueryBuilder.bindMarker((String)"key")));
        Assert.assertEquals((String)delete.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void batchTest() throws Exception {
        String query = "BEGIN BATCH USING TIMESTAMP 42 ";
        query = query + "INSERT INTO foo (a,b) VALUES ({2,3,4},3.4);";
        query = query + "UPDATE foo SET a[2]='foo',b=[3,2,1]+b,c=c-{'a'} WHERE k=2;";
        query = query + "DELETE a[3],b['foo'],c FROM foo WHERE k=1;";
        query = query + "APPLY BATCH;";
        Batch.Options batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4})).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.setIdx((String)"a", (int)2, (Object)"foo")).and(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1))).and(QueryBuilder.remove((String)"c", (Object)"a")).where(QueryBuilder.eq((String)"k", (Object)2))).add((RegularStatement)QueryBuilder.delete().listElt("a", 3).mapElt("b", (Object)"foo").column("c").from("foo").where(QueryBuilder.eq((String)"k", (Object)1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN BATCH ";
        query = query + "DELETE a[3] FROM foo WHERE k=1;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[]{QueryBuilder.delete().listElt("a", 3).from("foo").where(QueryBuilder.eq((String)"k", (Object)1))});
        Assert.assertEquals((String)batch.toString(), (String)query);
        Assert.assertEquals((String)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).toString(), (String)"BEGIN BATCH APPLY BATCH;");
    }

    @Test(groups={"unit"})
    public void batchCounterTest() throws Exception {
        String query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a+1;";
        query = query + "UPDATE foo SET b=b+2;";
        query = query + "UPDATE foo SET c=c+3;";
        query = query + "APPLY BATCH;";
        Batch.Options batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"a", (long)1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"b", (long)2L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a+1;";
        query = query + "UPDATE foo SET b=b+1;";
        query = query + "UPDATE foo SET c=c+1;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"a"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"b"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c"))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a-1;";
        query = query + "UPDATE foo SET b=b-2;";
        query = query + "UPDATE foo SET c=c-3;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"a", (long)1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"b", (long)2L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a-1;";
        query = query + "UPDATE foo SET b=b-1;";
        query = query + "UPDATE foo SET c=c-1;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"a"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"b"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"c"))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a+1;";
        query = query + "UPDATE foo SET b=b+-2;";
        query = query + "UPDATE foo SET c=c-3;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"a", (long)-1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"b", (long)-2L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void batchMixedCounterTest() throws Exception {
        QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"a", (long)1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"b", (Object)2))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
    }

    @Test(groups={"unit"})
    public void markerTest() throws Exception {
        String query = "INSERT INTO test (k,c) VALUES (0,?);";
        Insert insert = QueryBuilder.insertInto((String)"test").value("k", (Object)0).value("c", (Object)QueryBuilder.bindMarker());
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void rawEscapingTest() throws Exception {
        String query = "SELECT * FROM t WHERE c='C''est la vie!';";
        Select.Where select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)"C'est la vie!"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM t WHERE c=C'est la vie!;";
        select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)QueryBuilder.raw((String)"C'est la vie!")));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM t WHERE c=now();";
        select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)QueryBuilder.fcall((String)"now", (Object[])new Object[0])));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM t WHERE c='now()';";
        select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)QueryBuilder.raw((String)"'now()'")));
        Assert.assertEquals((String)select.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void selectInjectionTests() throws Exception {
        String query = "SELECT * FROM \"foo WHERE k=4\";";
        Select select = QueryBuilder.select().all().from("foo WHERE k=4");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4 AND c=5';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4 AND c=5"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4'' AND c=''5';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' AND c='5"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4'' OR ''1''=''1';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' OR '1'='1"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4; --test comment;';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4; --test comment;"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT \"*\" FROM foo;";
        select = QueryBuilder.select((String[])new String[]{"*"}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a,b FROM foo WHERE a IN ('b','c''); --comment');";
        select = QueryBuilder.select((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{"b", "c'); --comment"}));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a,b FROM foo WHERE a IN ('a','b','c');";
        select = QueryBuilder.select((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Iterable)Sets.newLinkedHashSet(Arrays.asList("a", "b", "c"))));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM bar; --(b) FROM foo;";
        select = QueryBuilder.select().fcall("* FROM bar; --", new Object[]{QueryBuilder.column((String)"b")}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(\"a) FROM bar; --\"),ttl(a) FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a) FROM bar; --").ttl("a").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(a),ttl(\"a) FROM bar; --\") FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a").ttl("a) FROM bar; --").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE \"k=1 OR k\">42 LIMIT 42;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)"k=1 OR k", (Object)42)).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE token(\"k)>0 OR token(k\")>token(42);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k)>0 OR token(k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)select.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void insertInjectionTest() throws Exception {
        String query = "INSERT INTO foo (a) VALUES ('123); --comment');";
        Insert insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)"123); --comment");
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo (\"a,b\") VALUES (123);";
        insert = QueryBuilder.insertInto((String)"foo").value("a,b", (Object)123);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo (a,b) VALUES ({'2''} space','3','4'},3.4) USING TTL 24 AND TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<String>(){
            {
                this.add("2'} space");
                this.add("3");
                this.add("4");
            }
        }, 3.4}).using(QueryBuilder.ttl((int)24)).and(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void updateInjectionTest() throws Exception {
        String query = "UPDATE foo.bar USING TIMESTAMP 42 SET a=12 WHERE k='2 OR 1=1';";
        Update.Where update = QueryBuilder.update((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).where(QueryBuilder.eq((String)"k", (Object)"2 OR 1=1"));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b='null WHERE k=1; --comment' WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.set((String)"b", (Object)"null WHERE k=1; --comment"));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TIMESTAMP 42 SET \"b WHERE k=1; --comment\"=[3,2,1]+\"b WHERE k=1; --comment\" WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.prependAll((String)"b WHERE k=1; --comment", Arrays.asList(3, 2, 1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)update.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void deleteInjectionTests() throws Exception {
        String query = "DELETE FROM \"foo WHERE k=4\";";
        Delete delete = QueryBuilder.delete().from("foo WHERE k=4");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4 AND c=5';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4 AND c=5"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4'' AND c=''5';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' AND c='5"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4'' OR ''1''=''1';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' OR '1'='1"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4; --test comment;';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4; --test comment;"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE \"*\" FROM foo;";
        delete = QueryBuilder.delete((String[])new String[]{"*"}).from("foo");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b FROM foo WHERE a IN ('b','c''); --comment');";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{"b", "c'); --comment"}));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE \"k=1 OR k\">42;";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.gt((String)"k=1 OR k", (Object)42));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE token(\"k)>0 OR token(k\")>token(42);";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k)>0 OR token(k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)delete.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void statementForwardingTest() throws Exception {
        Update upd = QueryBuilder.update((String)"foo");
        upd.setConsistencyLevel(ConsistencyLevel.QUORUM);
        upd.enableTracing();
        Update.Where query = upd.using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).and(QueryBuilder.incr((String)"c", (long)3L)).where(QueryBuilder.eq((String)"k", (Object)2));
        Assert.assertEquals((Object)query.getConsistencyLevel(), (Object)ConsistencyLevel.QUORUM);
        Assert.assertTrue((boolean)query.isTracing());
    }

    @Test(groups={"unit"}, expectedExceptions={CodecNotFoundException.class})
    public void rejectUnknownValueTest() throws Exception {
        RegularStatement s = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"a", (Object)new byte[13])).where(QueryBuilder.eq((String)"k", (Object)2)).setForceNoValues(true);
        s.getQueryString();
    }

    @Test(groups={"unit"})
    public void truncateTest() throws Exception {
        Assert.assertEquals((String)QueryBuilder.truncate((String)"foo").toString(), (String)"TRUNCATE foo;");
        Assert.assertEquals((String)QueryBuilder.truncate((String)"foo", (String)QueryBuilder.quote((String)"Bar")).toString(), (String)"TRUNCATE foo.\"Bar\";");
    }

    @Test(groups={"unit"})
    public void quotingTest() {
        Assert.assertEquals((String)QueryBuilder.select().from("Metrics", "epochs").toString(), (String)"SELECT * FROM Metrics.epochs;");
        Assert.assertEquals((String)QueryBuilder.select().from("Metrics", QueryBuilder.quote((String)"epochs")).toString(), (String)"SELECT * FROM Metrics.\"epochs\";");
        Assert.assertEquals((String)QueryBuilder.select().from(QueryBuilder.quote((String)"Metrics"), "epochs").toString(), (String)"SELECT * FROM \"Metrics\".epochs;");
        Assert.assertEquals((String)QueryBuilder.select().from(QueryBuilder.quote((String)"Metrics"), QueryBuilder.quote((String)"epochs")).toString(), (String)"SELECT * FROM \"Metrics\".\"epochs\";");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)"Metrics", (String)"epochs").toString(), (String)"INSERT INTO Metrics.epochs () VALUES ();");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)"Metrics", (String)QueryBuilder.quote((String)"epochs")).toString(), (String)"INSERT INTO Metrics.\"epochs\" () VALUES ();");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)QueryBuilder.quote((String)"Metrics"), (String)"epochs").toString(), (String)"INSERT INTO \"Metrics\".epochs () VALUES ();");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)QueryBuilder.quote((String)"Metrics"), (String)QueryBuilder.quote((String)"epochs")).toString(), (String)"INSERT INTO \"Metrics\".\"epochs\" () VALUES ();");
    }

    @Test(groups={"unit"})
    public void compoundWhereClauseTest() throws Exception {
        String query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)=('a',2);";
        Select.Where select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.eq(Arrays.asList("c1", "c2"), Arrays.asList("a", 2)));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)>('a',2);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gt(Arrays.asList("c1", "c2"), Arrays.asList("a", 2)));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)>=('a',2) AND (c1,c2)<('b',0);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gte(Arrays.asList("c1", "c2"), Arrays.asList("a", 2))).and(QueryBuilder.lt(Arrays.asList("c1", "c2"), Arrays.asList("b", 0)));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)<=('a',2);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.lte(Arrays.asList("c1", "c2"), Arrays.asList("a", 2)));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2) IN ((1,'foo'),(2,'bar'),(3,'qix'));";
        ImmutableList names = ImmutableList.of((Object)"c1", (Object)"c2");
        ImmutableList values = ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"foo"), (Object)ImmutableList.of((Object)2, (Object)"bar"), (Object)ImmutableList.of((Object)3, (Object)"qix"));
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)names, (Iterable)values));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2) IN ((1,'foo'),(2,?),?);";
        names = ImmutableList.of((Object)"c1", (Object)"c2");
        values = ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"foo"), (Object)ImmutableList.of((Object)2, (Object)QueryBuilder.bindMarker()), (Object)QueryBuilder.bindMarker());
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)names, (Iterable)values));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1) IN (?);";
        names = ImmutableList.of((Object)"c1");
        values = ImmutableList.of((Object)ImmutableList.of((Object)QueryBuilder.bindMarker()));
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)names, (Iterable)values));
        Assert.assertEquals((String)select.toString(), (String)query);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Too many values for IN clause, the maximum allowed is 65535")
    public void should_fail_if_compound_in_clause_has_too_many_values() {
        List<BindMarker> values = Collections.nCopies(65536, QueryBuilder.bindMarker());
        QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)ImmutableList.of((Object)"name"), values));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Missing values for IN clause")
    public void should_fail_if_compound_in_clause_given_null_values() {
        QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)ImmutableList.of((Object)"name"), null));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The number of names \\(4\\) and values \\(3\\) don't match")
    public void should_fail_if_compound_in_clause_has_mismatch_of_names_and_values() {
        QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Iterable)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4), (Object)ImmutableList.of((Object)1, (Object)2, (Object)3))));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Wrong element type for values list, expected List or BindMarker, got java.lang.Integer")
    public void shoud_fail_if_compound_in_clause_has_value_pair_that_is_not_list_or_bind_marker() {
        QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.in((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Iterable)ImmutableList.of((Object)1)));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Missing values for IN clause")
    public void should_fail_if_in_clause_has_null_values() {
        QueryBuilder.select().all().from("foo").where(QueryBuilder.in((String)"bar", (Iterable)null));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_if_in_clause_has_too_many_values() {
        List<String> values = Collections.nCopies(65536, "a");
        QueryBuilder.select().all().from("foo").where(QueryBuilder.in((String)"bar", (Object[])values.toArray()));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_if_built_statement_has_too_many_values() {
        List<String> values = Collections.nCopies(65535, "a");
        Select.Where statement = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"bar", (Object)"a")).and(QueryBuilder.in((String)"baz", (Object[])values.toArray()));
        statement.getValues(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE);
    }

    @Test(groups={"unit"})
    public void should_handle_nested_collections() {
        String query = "UPDATE foo SET l=[[1],[2]] WHERE k=1;";
        ImmutableList list = ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2));
        Update.Where statement = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"l", (Object)list)).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
        query = "UPDATE foo SET m={1:[[1],[2]],2:[[1],[2]]} WHERE k=1;";
        statement = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"m", (Object)ImmutableMap.of((Object)1, (Object)list, (Object)2, (Object)list))).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
        query = "UPDATE foo SET m=m+{1:[[1],[2]],2:[[1],[2]]} WHERE k=1;";
        statement = QueryBuilder.update((String)"foo").with(QueryBuilder.putAll((String)"m", (Map)ImmutableMap.of((Object)1, (Object)list, (Object)2, (Object)list))).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
        query = "UPDATE foo SET l=[[1]]+l WHERE k=1;";
        statement = QueryBuilder.update((String)"foo").with(QueryBuilder.prepend((String)"l", (Object)ImmutableList.of((Object)1))).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
        query = "UPDATE foo SET l=[[1],[2]]+l WHERE k=1;";
        statement = QueryBuilder.update((String)"foo").with(QueryBuilder.prependAll((String)"l", (List)list)).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
    }

    @Test(groups={"unit"}, expectedExceptions={InvalidQueryException.class})
    public void should_not_allow_bind_marker_for_add() {
        QueryBuilder.update((String)"foo").with(QueryBuilder.add((String)"s", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"k", (Object)1));
    }

    @Test(groups={"unit"}, expectedExceptions={InvalidQueryException.class})
    public void should_now_allow_bind_marker_for_prepend() {
        QueryBuilder.update((String)"foo").with(QueryBuilder.prepend((String)"l", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"k", (Object)1));
    }

    @Test(groups={"unit"}, expectedExceptions={InvalidQueryException.class})
    public void should_not_allow_bind_marker_for_append() {
        QueryBuilder.update((String)"foo").with(QueryBuilder.append((String)"l", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"k", (Object)1));
    }

    @Test(groups={"unit"}, expectedExceptions={InvalidQueryException.class})
    public void should_not_allow_bind_marker_for_remove() {
        QueryBuilder.update((String)"foo").with(QueryBuilder.remove((String)"s", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"k", (Object)1));
    }

    @Test(groups={"unit"}, expectedExceptions={InvalidQueryException.class})
    public void should_not_allow_bind_marker_for_discard() {
        QueryBuilder.update((String)"foo").with(QueryBuilder.discard((String)"l", (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"k", (Object)1));
    }

    @Test(groups={"unit"})
    public void should_quote_complex_column_names() {
        String query = "SELECT * FROM foo WHERE \"foo.bar\"=1;";
        Select.Where statement = QueryBuilder.select().from("foo").where(QueryBuilder.eq((String)QueryBuilder.quote((String)"foo.bar"), (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
    }

    @Test(groups={"unit"})
    public void should_quote_column_names_with_escaped_quotes() {
        String query = "SELECT * FROM foo WHERE \"foo \"\" bar\"=1;";
        Select.Where statement = QueryBuilder.select().from("foo").where(QueryBuilder.eq((String)QueryBuilder.quote((String)"foo \" bar"), (Object)1));
        Assertions.assertThat((String)statement.toString()).isEqualTo((Object)query);
    }

    @Test(groups={"unit"})
    public void should_not_serialize_raw_query_values() {
        Select.Where select = QueryBuilder.select().from("test").where(QueryBuilder.gt((String)"i", (Object)QueryBuilder.raw((String)"1")));
        Assertions.assertThat((String)select.getQueryString()).doesNotContain((CharSequence)"?");
        Assertions.assertThat((Object[])select.getValues(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE)).isNull();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class})
    public void should_throw_ISE_if_getObject_called_on_statement_without_values() {
        QueryBuilder.select().from("test").where(QueryBuilder.eq((String)"foo", (Object)42)).getObject(0);
    }

    @Test(groups={"unit"}, expectedExceptions={IndexOutOfBoundsException.class})
    public void should_throw_IOOBE_if_getObject_called_with_wrong_index() {
        QueryBuilder.select().from("test").where(QueryBuilder.eq((String)"foo", (Object)new Object())).getObject(1);
    }

    @Test(groups={"unit"})
    public void should_return_object_at_ith_index() {
        Object expected = new Object();
        Object actual = QueryBuilder.select().from("test").where(QueryBuilder.eq((String)"foo", (Object)expected)).getObject(0);
        Assertions.assertThat((Object)actual).isSameAs(expected);
    }

    @Test(groups={"unit"})
    public void should_serialize_collections_of_serializable_elements() {
        HashSet set = Sets.newHashSet((Object[])new UUID[]{UUID.randomUUID()});
        ArrayList list = Lists.newArrayList((Object[])new Date[]{new Date()});
        ImmutableMap map = ImmutableMap.of((Object)new BigInteger("1"), (Object)"foo");
        Insert query = QueryBuilder.insertInto((String)"foo").value("v", (Object)set);
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES (?);");
        Assertions.assertThat((Object)query.getObject(0)).isEqualTo((Object)set);
        query = QueryBuilder.insertInto((String)"foo").value("v", (Object)list);
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES (?);");
        Assertions.assertThat((Object)query.getObject(0)).isEqualTo((Object)list);
        query = QueryBuilder.insertInto((String)"foo").value("v", (Object)map);
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES (?);");
        Assertions.assertThat((Object)query.getObject(0)).isEqualTo((Object)map);
    }

    @Test(groups={"unit"})
    public void should_not_attempt_to_serialize_function_calls_in_collections() {
        Insert query = QueryBuilder.insertInto((String)"foo").value("v", (Object)Sets.newHashSet((Object[])new Object[]{QueryBuilder.fcall((String)"func", (Object[])new Object[]{1})}));
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES ({func(1)});");
        Assertions.assertThat((Object[])query.getValues(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE)).isNullOrEmpty();
    }

    @Test(groups={"unit"})
    public void should_not_attempt_to_serialize_bind_markers_in_collections() {
        Insert query = QueryBuilder.insertInto((String)"foo").value("v", (Object)Lists.newArrayList((Object[])new Object[]{1, 2, QueryBuilder.bindMarker()}));
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES ([1,2,?]);");
        Assertions.assertThat((Object[])query.getValues(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE)).isNullOrEmpty();
    }

    @Test(groups={"unit"})
    public void should_not_attempt_to_serialize_raw_values_in_collections() {
        Insert query = QueryBuilder.insertInto((String)"foo").value("v", (Object)ImmutableMap.of((Object)1, (Object)QueryBuilder.raw((String)"x")));
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES ({1:x});");
        Assertions.assertThat((Object[])query.getValues(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE)).isNullOrEmpty();
    }

    @Test(groups={"unit"})
    public void should_not_attempt_to_serialize_collections_containing_numbers() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        Insert query = QueryBuilder.insertInto((String)"foo").value("v", (Object)list);
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES ([1,2,3]);");
        Assertions.assertThat((boolean)query.hasValues()).isFalse();
        HashSet set = Sets.newHashSet((Object[])new Integer[]{1, 2, 3});
        query = QueryBuilder.insertInto((String)"foo").value("v", (Object)set);
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES ({1,2,3});");
        Assertions.assertThat((boolean)query.hasValues()).isFalse();
        ImmutableMap map = ImmutableMap.of((Object)1, (Object)Float.valueOf(12.34f));
        query = QueryBuilder.insertInto((String)"foo").value("v", (Object)map);
        Assertions.assertThat((String)query.getQueryString()).isEqualTo((Object)"INSERT INTO foo (v) VALUES ({1:12.34});");
        Assertions.assertThat((boolean)query.hasValues()).isFalse();
    }

    @Test(groups={"unit"})
    public void should_include_original_cause_when_arguments_invalid() {
        ByteBuffer bb = ByteBuffer.allocate(65536);
        ArrayList value = Lists.newArrayList((Object[])new ByteBuffer[]{bb});
        Insert s = QueryBuilder.insertInto((String)"foo").value("l", (Object)value);
        try {
            s.getValues(ProtocolVersion.V2, CodecRegistry.DEFAULT_INSTANCE);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (InvalidTypeException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalArgumentException.class);
            StringWriter writer = new StringWriter();
            e.getCause().printStackTrace(new PrintWriter(writer));
            String stackTrace = writer.toString();
            Assertions.assertThat((String)stackTrace).contains(new CharSequence[]{"Native protocol version 2 supports only elements with size up to 65535 bytes - but element size is 65536 bytes"});
        }
    }

    @Test(groups={"unit"})
    public void should_handle_per_partition_limit_clause() {
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").perPartitionLimit(2).toString()).isEqualTo((Object)"SELECT * FROM foo PER PARTITION LIMIT 2;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").perPartitionLimit(QueryBuilder.bindMarker()).toString()).isEqualTo((Object)"SELECT * FROM foo PER PARTITION LIMIT ?;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").perPartitionLimit(QueryBuilder.bindMarker((String)"limit")).toString()).isEqualTo((Object)"SELECT * FROM foo PER PARTITION LIMIT :limit;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").perPartitionLimit(2).limit(QueryBuilder.bindMarker()).toString()).isEqualTo((Object)"SELECT * FROM foo PER PARTITION LIMIT 2 LIMIT ?;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{2, 4})).perPartitionLimit(2).limit(3).toString()).isEqualTo((Object)"SELECT * FROM foo WHERE a IN (2,4) PER PARTITION LIMIT 2 LIMIT 3;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).perPartitionLimit(QueryBuilder.bindMarker()).limit(3).toString()).isEqualTo((Object)"SELECT * FROM foo WHERE a=? PER PARTITION LIMIT ? LIMIT 3;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).orderBy(new Ordering[]{QueryBuilder.desc((String)"b")}).perPartitionLimit(2).limit(3).toString()).isEqualTo((Object)"SELECT * FROM foo WHERE a=? ORDER BY b DESC PER PARTITION LIMIT 2 LIMIT 3;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"a", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.gt((String)"b", (Object)QueryBuilder.bindMarker())).orderBy(new Ordering[]{QueryBuilder.desc((String)"b")}).perPartitionLimit(QueryBuilder.bindMarker()).limit(3).allowFiltering().toString()).isEqualTo((Object)"SELECT * FROM foo WHERE a=? AND b>? ORDER BY b DESC PER PARTITION LIMIT ? LIMIT 3 ALLOW FILTERING;");
        try {
            QueryBuilder.select().distinct().all().from("foo").perPartitionLimit(3);
            Assertions.fail((String)"Should not allow DISTINCT + PER PARTITION LIMIT");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessage("PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
        }
        try {
            QueryBuilder.select().all().from("foo").perPartitionLimit(-1);
            Assertions.fail((String)"Should not allow negative limit");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Invalid PER PARTITION LIMIT value, must be strictly positive");
        }
        try {
            QueryBuilder.select().all().from("foo").perPartitionLimit(1).perPartitionLimit(QueryBuilder.bindMarker());
            Assertions.fail((String)"Should not allow to set limit twice");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("A PER PARTITION LIMIT value has already been provided");
        }
    }

    @Test(groups={"unit"})
    public void should_handle_select_json() throws Exception {
        Assertions.assertThat((String)QueryBuilder.select().json().from("users").toString()).isEqualTo((Object)"SELECT JSON * FROM users;");
        Assertions.assertThat((String)QueryBuilder.select((String[])new String[]{"id", "age"}).json().from("users").toString()).isEqualTo((Object)"SELECT JSON id,age FROM users;");
        Assertions.assertThat((String)QueryBuilder.select().json().column("id").writeTime("age").ttl("state").as("ttl").from("users").toString()).isEqualTo((Object)"SELECT JSON id,writetime(age),ttl(state) AS ttl FROM users;");
        Assertions.assertThat((String)QueryBuilder.select().distinct().json().column("id").from("users").toString()).isEqualTo((Object)"SELECT JSON DISTINCT id FROM users;");
    }

    @Test(groups={"unit"})
    public void should_handle_insert_json() throws Exception {
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"example").json((Object)"{\"id\": 0, \"tupleval\": [1, \"abc\"], \"numbers\": [1, 2, 3], \"letters\": [\"a\", \"b\", \"c\"]}").toString()).isEqualTo((Object)"INSERT INTO example JSON '{\"id\": 0, \"tupleval\": [1, \"abc\"], \"numbers\": [1, 2, 3], \"letters\": [\"a\", \"b\", \"c\"]}';");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").json((Object)"{\"id\": \"user123\", \"\\\"Age\\\"\": 42, \"\\\"State\\\"\": \"TX\"}").toString()).isEqualTo((Object)"INSERT INTO users JSON '{\"id\": \"user123\", \"\\\"Age\\\"\": 42, \"\\\"State\\\"\": \"TX\"}';");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").json((Object)QueryBuilder.bindMarker()).toString()).isEqualTo((Object)"INSERT INTO users JSON ?;");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").json((Object)QueryBuilder.bindMarker((String)"json")).toString()).isEqualTo((Object)"INSERT INTO users JSON :json;");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"example").json((Object)"{\"id\": 0, \"tupleval\": [1, \"abc\"], \"numbers\": [1, 2, 3], \"letters\": [\"a\", \"b\", \"c\"]}").defaultNull().toString()).isEqualTo((Object)"INSERT INTO example JSON '{\"id\": 0, \"tupleval\": [1, \"abc\"], \"numbers\": [1, 2, 3], \"letters\": [\"a\", \"b\", \"c\"]}' DEFAULT NULL;");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"example").json((Object)"{\"id\": 0, \"tupleval\": [1, \"abc\"], \"numbers\": [1, 2, 3], \"letters\": [\"a\", \"b\", \"c\"]}").defaultUnset().toString()).isEqualTo((Object)"INSERT INTO example JSON '{\"id\": 0, \"tupleval\": [1, \"abc\"], \"numbers\": [1, 2, 3], \"letters\": [\"a\", \"b\", \"c\"]}' DEFAULT UNSET;");
    }

    @Test(groups={"unit"})
    public void should_handle_to_json() throws Exception {
        Assertions.assertThat((String)QueryBuilder.select().toJson("id").as("id").toJson("age").as("age").from("users").toString()).isEqualTo((Object)"SELECT toJson(id) AS id,toJson(age) AS age FROM users;");
        Assertions.assertThat((String)QueryBuilder.select().distinct().toJson("id").as("id").from("users").toString()).isEqualTo((Object)"SELECT DISTINCT toJson(id) AS id FROM users;");
        Assertions.assertThat((String)QueryBuilder.select((Object[])new Object[]{QueryBuilder.alias((Object)QueryBuilder.toJson((Object)"id"), (String)"id"), QueryBuilder.alias((Object)QueryBuilder.toJson((Object)"age"), (String)"age")}).from("users").toString()).isEqualTo((Object)"SELECT toJson(id) AS id,toJson(age) AS age FROM users;");
        Assertions.assertThat((String)QueryBuilder.select((Object[])new Object[]{QueryBuilder.alias((Object)QueryBuilder.toJson((Object)"id"), (String)"id")}).distinct().from("users").toString()).isEqualTo((Object)"SELECT DISTINCT toJson(id) AS id FROM users;");
    }

    @Test(groups={"unit"})
    public void should_handle_from_json() throws Exception {
        Assertions.assertThat((String)QueryBuilder.update((String)"users").with(QueryBuilder.set((String)"age", (Object)QueryBuilder.fromJson((Object)"42"))).where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.fromJson((Object)"\"user123\""))).toString()).isEqualTo((Object)"UPDATE users SET age=fromJson('42') WHERE id=fromJson('\"user123\"');");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").value("id", QueryBuilder.fromJson((Object)"\"user123\"")).value("age", QueryBuilder.fromJson((Object)"42")).toString()).isEqualTo((Object)"INSERT INTO users (id,age) VALUES (fromJson('\"user123\"'),fromJson('42'));");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").value("id", QueryBuilder.fromJson((Object)QueryBuilder.bindMarker())).toString()).isEqualTo((Object)"INSERT INTO users (id) VALUES (fromJson(?));");
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").value("id", QueryBuilder.fromJson((Object)QueryBuilder.bindMarker((String)"id"))).toString()).isEqualTo((Object)"INSERT INTO users (id) VALUES (fromJson(:id));");
    }

    @Test(groups={"unit"})
    public void should_inline_custom_codec() throws Exception {
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").value("id", (Object)new Foo(42)).toString()).isEqualTo((Object)"INSERT INTO users (id) VALUES (?);");
        CodecRegistry.DEFAULT_INSTANCE.register((TypeCodec)new FooCodec());
        Assertions.assertThat((String)QueryBuilder.insertInto((String)"users").value("id", (Object)new Foo(42)).toString()).isEqualTo((Object)"INSERT INTO users (id) VALUES (42);");
    }

    @Test(groups={"unit"})
    public void should_not_append_last_column_twice() throws Exception {
        Select.SelectionOrAlias select = QueryBuilder.select().column("a").column("b");
        Select fromUsers1 = select.from("users");
        Select fromUsers2 = select.from("users");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)fromUsers1.getQueryString()).isEqualTo((Object)fromUsers2.getQueryString())).isEqualTo((Object)"SELECT a,b FROM users;");
    }

    @Test(groups={"unit"})
    public void should_handle_setting_udt_fields() throws Exception {
        Assertions.assertThat((String)QueryBuilder.update((String)"tbl").with(QueryBuilder.set((Object)QueryBuilder.path((String[])new String[]{"a", QueryBuilder.quote((String)"B")}), (Object)"foo")).and(QueryBuilder.set((Object)QueryBuilder.raw((String)"c.\"D\""), (Object)"bar")).where(QueryBuilder.eq((String)"k", (Object)0)).getQueryString()).isEqualTo((Object)"UPDATE tbl SET a.\"B\"=?,c.\"D\"=? WHERE k=0;");
    }

    @Test(groups={"unit"})
    public void should_handle_retrieving_udt_fields() throws Exception {
        Assertions.assertThat((String)QueryBuilder.select().path(new String[]{"a", Metadata.quote((String)"B")}).raw("c.\"D\"").from("tbl").getQueryString()).isEqualTo((Object)"SELECT a.\"B\",c.\"D\" FROM tbl;");
    }

    @Test(groups={"unit"})
    public void should_handle_group_by_clause() {
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").groupBy(new Object[]{"c1", QueryBuilder.column((String)"c2"), QueryBuilder.raw((String)"c3")}).toString()).isEqualTo((Object)"SELECT * FROM foo GROUP BY c1,c2,c3;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").groupBy(new Object[]{"c1", QueryBuilder.column((String)"c2"), QueryBuilder.raw((String)"c3")}).orderBy(new Ordering[]{QueryBuilder.asc((String)"c1")}).toString()).isEqualTo((Object)"SELECT * FROM foo GROUP BY c1,c2,c3 ORDER BY c1 ASC;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"x", (Object)42)).groupBy(new Object[]{"c1", QueryBuilder.column((String)"c2"), QueryBuilder.raw((String)"c3")}).toString()).isEqualTo((Object)"SELECT * FROM foo WHERE x=42 GROUP BY c1,c2,c3;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"x", (Object)42)).groupBy(new Object[]{"c1", QueryBuilder.column((String)"c2"), QueryBuilder.raw((String)"c3")}).orderBy(new Ordering[]{QueryBuilder.asc((String)"c1")}).toString()).isEqualTo((Object)"SELECT * FROM foo WHERE x=42 GROUP BY c1,c2,c3 ORDER BY c1 ASC;");
        try {
            QueryBuilder.select().all().from("foo").groupBy(new Object[]{"foo"}).groupBy(new Object[]{"bar"});
            Assertions.fail((String)"Should not allow GROUP BY twice");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("A GROUP BY clause has already been provided");
        }
    }

    @Test(groups={"unit"})
    public void should_handle_allow_filtering() {
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").allowFiltering().toString()).isEqualTo((Object)"SELECT * FROM foo ALLOW FILTERING;");
        Assertions.assertThat((String)QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"x", (Object)42)).allowFiltering().toString()).isEqualTo((Object)"SELECT * FROM foo WHERE x=42 ALLOW FILTERING;");
    }

    static class FooCodec
    extends TypeCodec<Foo> {
        public FooCodec() {
            super(DataType.cint(), Foo.class);
        }

        public ByteBuffer serialize(Foo value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return null;
        }

        public Foo deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return null;
        }

        public Foo parse(String value) throws InvalidTypeException {
            return null;
        }

        public String format(Foo foo) throws InvalidTypeException {
            return Integer.toString(foo.bar);
        }
    }

    static class Foo {
        int bar;

        public Foo(int bar) {
            this.bar = bar;
        }
    }
}

