/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.3")
public class QueryBuilderUDTExecutionTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TYPE udt (i int, a inet)", "CREATE TABLE udtTest(k int PRIMARY KEY, t frozen<udt>, l list<frozen<udt>>, m map<int, frozen<udt>>)");
    }

    @Test(groups={"short"})
    public void insertUdtTest() throws Exception {
        UserType udtType = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("udt");
        UDTValue udtValue = (UDTValue)((UDTValue)udtType.newValue().setInt("i", 2)).setInet("a", InetAddress.getByName("localhost"));
        Insert insert = QueryBuilder.insertInto((String)"udtTest").value("k", (Object)1).value("t", (Object)udtValue);
        Assert.assertEquals((String)insert.toString(), (String)"INSERT INTO udtTest (k,t) VALUES (1,{i:2,a:'127.0.0.1'});");
        this.session().execute((Statement)insert);
        List rows = this.session().execute((Statement)QueryBuilder.select().from("udtTest").where(QueryBuilder.eq((String)"k", (Object)1))).all();
        Assert.assertEquals((int)rows.size(), (int)1);
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((String)"127.0.0.1", (String)r1.getUDTValue("t").getInet("a").getHostAddress());
    }

    @Test(groups={"short"})
    public void should_handle_collections_of_UDT() throws Exception {
        UserType udtType = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType("udt");
        UDTValue udtValue = (UDTValue)((UDTValue)udtType.newValue().setInt("i", 2)).setInet("a", InetAddress.getByName("localhost"));
        UDTValue udtValue2 = (UDTValue)((UDTValue)udtType.newValue().setInt("i", 3)).setInet("a", InetAddress.getByName("localhost"));
        Insert insert = QueryBuilder.insertInto((String)"udtTest").value("k", (Object)1).value("l", (Object)ImmutableList.of((Object)udtValue));
        Assertions.assertThat((String)insert.toString()).isEqualTo((Object)"INSERT INTO udtTest (k,l) VALUES (1,[{i:2,a:'127.0.0.1'}]);");
        this.session().execute((Statement)insert);
        List rows = this.session().execute((Statement)QueryBuilder.select().from("udtTest").where(QueryBuilder.eq((String)"k", (Object)1))).all();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row r1 = (Row)rows.get(0);
        Assertions.assertThat((String)((UDTValue)r1.getList("l", UDTValue.class).get(0)).getInet("a").getHostAddress()).isEqualTo((Object)"127.0.0.1");
        HashMap map = Maps.newHashMap();
        map.put(0, udtValue);
        map.put(2, udtValue2);
        Update.Where updateMap = QueryBuilder.update((String)"udtTest").with(QueryBuilder.putAll((String)"m", (Map)map)).where(QueryBuilder.eq((String)"k", (Object)1));
        Assertions.assertThat((String)updateMap.toString()).isEqualTo((Object)"UPDATE udtTest SET m=m+{0:{i:2,a:'127.0.0.1'},2:{i:3,a:'127.0.0.1'}} WHERE k=1;");
        this.session().execute((Statement)updateMap);
        rows = this.session().execute((Statement)QueryBuilder.select().from("udtTest").where(QueryBuilder.eq((String)"k", (Object)1))).all();
        r1 = (Row)rows.get(0);
        Assertions.assertThat((Map)r1.getMap("m", Integer.class, UDTValue.class)).isEqualTo((Object)map);
    }

    @CassandraVersion(value="3.6", description="Requires CASSANDRA-7423 introduced in Cassandra 3.6")
    @Test(groups={"short"})
    public void should_support_setting_and_retrieving_udt_fields() {
        String table = "unfrozen_udt_table";
        String udt = "person";
        this.session().execute((Statement)((CreateType)SchemaBuilder.createType((String)udt).addColumn("first", DataType.text())).addColumn("last", DataType.text()));
        UserType userType = this.cluster().getMetadata().getKeyspace(this.keyspace).getUserType(udt);
        Assertions.assertThat((Iterable)userType).isNotNull();
        this.session().execute((Statement)SchemaBuilder.createTable((String)table).addPartitionKey("k", DataType.text()).addUDTColumn("u", SchemaBuilder.udtLiteral((String)udt)));
        UDTValue value = userType.newValue();
        value.setString("first", "Bob");
        value.setString("last", "Smith");
        this.session().execute((Statement)QueryBuilder.insertInto((String)table).value("k", (Object)"key").value("u", (Object)value));
        this.session().execute((Statement)QueryBuilder.update((String)table).with(QueryBuilder.set((Object)QueryBuilder.path((String[])new String[]{"u", "first"}), (Object)"Rick")).and(QueryBuilder.set((Object)QueryBuilder.raw((String)"u.last"), (Object)"Jones")).where(QueryBuilder.eq((String)"k", (Object)"key")));
        Row r = this.session().execute((Statement)QueryBuilder.select().path(new String[]{"u", "first"}).raw("u.last").from(table).where(QueryBuilder.eq((String)"k", (Object)"key"))).one();
        Assertions.assertThat((String)r.getString("u.first")).isEqualTo((Object)"Rick");
        Assertions.assertThat((String)r.getString("u.last")).isEqualTo((Object)"Jones");
    }
}

