/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.AbstractCreateStatement;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CreateTest {
    @Test(groups={"unit"})
    public void should_create_simple_table() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_udt_partition_key() throws Exception {
        Create statement = SchemaBuilder.createTable((String)"test").addUDTPartitionKey("u", SchemaBuilder.frozen((String)"user"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tu frozen<user>,\n\t\tPRIMARY KEY(u))");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class})
    public void should_fail_when_creating_table_without_partition_key() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addColumn("name", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"})
    public void should_create_simple_table_if_not_exists() throws Exception {
        AbstractCreateStatement statement = ((Create)SchemaBuilder.createTable((String)"test").ifNotExists()).addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE IF NOT EXISTS test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))");
    }

    @Test(groups={"unit"})
    public void should_create_simple_table_with_keyspace() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"ks", (String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE ks.test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))");
    }

    @Test(groups={"unit"})
    public void should_create_simple_table_with_list() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("friends", (DataType)DataType.list((DataType)DataType.text()));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tfriends list<text>,\n\t\tPRIMARY KEY(id))");
    }

    @Test(groups={"unit"})
    public void should_create_simple_table_with_set() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("friends", (DataType)DataType.set((DataType)DataType.text()));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tfriends set<text>,\n\t\tPRIMARY KEY(id))");
    }

    @Test(groups={"unit"})
    public void should_create_simple_table_with_map() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("friends", (DataType)DataType.map((DataType)DataType.cint(), (DataType)DataType.text()));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tfriends map<int, text>,\n\t\tPRIMARY KEY(id))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_clustering_keys() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol1 uuid,\n\t\tcol2 uuid,\n\t\tname text,\n\t\tPRIMARY KEY(id, col1, col2))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_udt_clustering_keys() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addUDTClusteringColumn("col2", SchemaBuilder.frozen((String)"address")).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol1 uuid,\n\t\tcol2 frozen<address>,\n\t\tname text,\n\t\tPRIMARY KEY(id, col1, col2))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_composite_partition_key() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id1", DataType.bigint()).addPartitionKey("id2", DataType.text()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid1 bigint,\n\t\tid2 text,\n\t\tname text,\n\t\tPRIMARY KEY((id1, id2)))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_composite_partition_key_and_clustering_keys() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id1", DataType.bigint()).addPartitionKey("id2", DataType.text()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid1 bigint,\n\t\tid2 text,\n\t\tcol1 uuid,\n\t\tcol2 uuid,\n\t\tname text,\n\t\tPRIMARY KEY((id1, id2), col1, col2))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_static_column() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col", DataType.uuid()).addStaticColumn("bucket", DataType.cint()).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol uuid,\n\t\tbucket int static,\n\t\tname text,\n\t\tPRIMARY KEY(id, col))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_udt_static_column() throws Exception {
        AbstractCreateStatement statement = SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col", DataType.uuid()).addUDTStaticColumn("bucket", SchemaBuilder.frozen((String)"address")).addColumn("name", DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol uuid,\n\t\tbucket frozen<address> static,\n\t\tname text,\n\t\tPRIMARY KEY(id, col))");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_clustering_order() throws Exception {
        Create.Options statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text())).withOptions().clusteringOrder("col1", SchemaBuilder.Direction.ASC).clusteringOrder("col2", SchemaBuilder.Direction.DESC);
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol1 uuid,\n\t\tcol2 uuid,\n\t\tname text,\n\t\tPRIMARY KEY(id, col1, col2))\n\tWITH CLUSTERING ORDER BY(col1 ASC, col2 DESC)");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_when_blank_clustering_order_column_provided() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text())).withOptions().clusteringOrder("", SchemaBuilder.Direction.DESC);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_when_clustering_order_column_does_not_match_declared_clustering_keys() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text())).withOptions().clusteringOrder("col3", SchemaBuilder.Direction.ASC);
    }

    @Test(groups={"unit"})
    public void should_create_table_with_compact_storage() throws Exception {
        Create.Options statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text())).withOptions().compactStorage();
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol1 uuid,\n\t\tcol2 uuid,\n\t\tname text,\n\t\tPRIMARY KEY(id, col1, col2))\n\tWITH COMPACT STORAGE");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_all_options() throws Exception {
        TableOptions statement = ((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create.Options)((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addClusteringColumn("col1", DataType.uuid()).addClusteringColumn("col2", DataType.uuid()).addColumn("name", DataType.text())).withOptions().clusteringOrder("col1", SchemaBuilder.Direction.ASC).clusteringOrder("col2", SchemaBuilder.Direction.DESC).compactStorage().bloomFilterFPChance(Double.valueOf(0.01))).caching(SchemaBuilder.Caching.ROWS_ONLY)).comment("This is a comment")).compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.leveledStrategy().ssTableSizeInMB(Integer.valueOf(160)))).compressionOptions(SchemaBuilder.lz4())).dcLocalReadRepairChance(Double.valueOf(0.21))).defaultTimeToLive(Integer.valueOf(100))).gcGraceSeconds(Integer.valueOf(9999))).minIndexInterval(Integer.valueOf(64))).maxIndexInterval(Integer.valueOf(512))).memtableFlushPeriodInMillis(Integer.valueOf(12))).populateIOCacheOnFlush(Boolean.valueOf(true))).readRepairChance(Double.valueOf(0.05))).replicateOnWrite(Boolean.valueOf(true))).speculativeRetry(SchemaBuilder.always())).cdc(Boolean.valueOf(true));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tcol1 uuid,\n\t\tcol2 uuid,\n\t\tname text,\n\t\tPRIMARY KEY(id, col1, col2))\n\tWITH caching = 'rows_only' AND bloom_filter_fp_chance = 0.01 AND comment = 'This is a comment' AND compression = {'sstable_compression' : 'LZ4Compressor'} AND compaction = {'class' : 'LeveledCompactionStrategy', 'sstable_size_in_mb' : 160} AND dclocal_read_repair_chance = 0.21 AND default_time_to_live = 100 AND gc_grace_seconds = 9999 AND min_index_interval = 64 AND max_index_interval = 512 AND memtable_flush_period_in_ms = 12 AND populate_io_cache_on_flush = true AND read_repair_chance = 0.05 AND replicate_on_write = true AND speculative_retry = 'ALWAYS' AND cdc = true AND CLUSTERING ORDER BY(col1 ASC, col2 DESC) AND COMPACT STORAGE");
    }

    @Test(groups={"unit"})
    public void should_build_table_with_new_caching_options() throws Exception {
        TableOptions statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)100));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH caching = {'keys' : 'all', 'rows_per_partition' : 100}");
        statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.allRows());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH caching = {'keys' : 'all', 'rows_per_partition' : 'all'}");
    }

    @Test(groups={"unit"})
    public void should_build_table_with_custom_option() throws Exception {
        TableOptions statement = ((Create.Options)((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().freeformOption("key1", (Object)"value1")).freeformOption("key2", (Object)1.0);
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH key1 = 'value1' AND key2 = 1.0");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class})
    public void should_fail_when_both_caching_versions() throws Exception {
        ((Create.Options)((Create.Options)((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().caching(SchemaBuilder.Caching.KEYS_ONLY)).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.allRows())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_when_negative_rows_per_partition() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)-3));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_when_read_repair_chance_out_of_bound() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().readRepairChance(Double.valueOf(1.3));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_when_read_repair_chance_negative() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().readRepairChance(Double.valueOf(-1.3));
    }

    @Test(groups={"unit"})
    public void should_create_table_with_speculative_retry_none() throws Exception {
        TableOptions statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().speculativeRetry(SchemaBuilder.noSpeculativeRetry());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH speculative_retry = 'NONE'");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_speculative_retry_in_percentile() throws Exception {
        TableOptions statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().speculativeRetry(SchemaBuilder.percentile((int)95));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH speculative_retry = '95percentile'");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_speculative_retry_in_milli_secs() throws Exception {
        TableOptions statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().speculativeRetry(SchemaBuilder.millisecs((int)12));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH speculative_retry = '12ms'");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_cdc_true() throws Exception {
        TableOptions statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().cdc(Boolean.valueOf(true));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH cdc = true");
    }

    @Test(groups={"unit"})
    public void should_create_table_with_cdc_false() throws Exception {
        TableOptions statement = ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("id", DataType.bigint()).addColumn("name", DataType.text())).withOptions().cdc(Boolean.valueOf(false));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tCREATE TABLE test(\n\t\tid bigint,\n\t\tname text,\n\t\tPRIMARY KEY(id))\n\tWITH cdc = false");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The '\\[pk\\]' columns can not be declared as partition keys and clustering keys at the same time")
    public void should_fail_if_same_partition_and_clustering_column() throws Exception {
        SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("pk", DataType.bigint()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The '\\[pk\\]' columns can not be declared as partition keys and simple columns at the same time")
    public void should_fail_if_same_partition_and_simple_column() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addColumn("pk", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The '\\[cluster\\]' columns can not be declared as clustering keys and simple columns at the same time")
    public void should_fail_if_same_clustering_and_simple_column() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("cluster", DataType.bigint()).addColumn("cluster", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The '\\[pk\\]' columns can not be declared as partition keys and static columns at the same time")
    public void should_fail_if_same_partition_and_static_column() throws Exception {
        SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addStaticColumn("pk", DataType.text()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The '\\[cluster\\]' columns can not be declared as clustering keys and static columns at the same time")
    public void should_fail_if_same_clustering_and_static_column() throws Exception {
        SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("cluster", DataType.bigint()).addStaticColumn("cluster", DataType.text()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The '\\[col\\]' columns can not be declared as simple columns and static columns at the same time")
    public void should_fail_if_same_simple_and_static_column() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("cluster", DataType.uuid()).addColumn("col", DataType.bigint())).addStaticColumn("col", DataType.text()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The table 'test' cannot declare static columns '\\[stat\\]' without clustering columns")
    public void should_fail_if_static_column_in_non_clustered_table() throws Exception {
        SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addStaticColumn("stat", DataType.text()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The keyspace name 'ADD' is not allowed because it is a reserved keyword")
    public void should_fail_if_keyspace_name_is_a_reserved_keyword() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"ADD", (String)"test").addPartitionKey("pk", DataType.bigint()).addColumn("col", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The table name 'ADD' is not allowed because it is a reserved keyword")
    public void should_fail_if_table_name_is_a_reserved_keyword() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"ADD").addPartitionKey("pk", DataType.bigint()).addColumn("col", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The partition key name 'ADD' is not allowed because it is a reserved keyword")
    public void should_fail_if_partition_key_is_a_reserved_keyword() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("ADD", DataType.bigint()).addColumn("col", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The clustering column name 'ADD' is not allowed because it is a reserved keyword")
    public void should_fail_if_clustering_key_is_a_reserved_keyword() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("ADD", DataType.uuid()).addColumn("col", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The column name 'ADD' is not allowed because it is a reserved keyword")
    public void should_fail_if_simple_column_is_a_reserved_keyword() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("cluster", DataType.uuid()).addColumn("ADD", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The static column name 'ADD' is not allowed because it is a reserved keyword")
    public void should_fail_if_static_column_is_a_reserved_keyword() throws Exception {
        ((Create)SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("cluster", DataType.uuid()).addStaticColumn("ADD", DataType.text()).addColumn("col", DataType.text())).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Cannot create table 'test' with compact storage and static columns '\\[stat\\]'")
    public void should_fail_creating_table_with_static_columns_and_compact_storage() throws Exception {
        SchemaBuilder.createTable((String)"test").addPartitionKey("pk", DataType.bigint()).addClusteringColumn("cluster", DataType.uuid()).addStaticColumn("stat", DataType.text()).withOptions().compactStorage().getQueryString();
    }
}

