/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.utils;

import com.datastax.driver.core.NettyOptions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelMonitor
implements Runnable,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SocketChannelMonitor.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("SocketMonitor-%d").build());
    private final Collection<SocketChannel> channels = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final AtomicLong channelsCreated = new AtomicLong(0L);
    private final NettyOptions nettyOptions = new NettyOptions(){

        public void afterChannelInitialized(SocketChannel channel) throws Exception {
            SocketChannelMonitor.this.channels.add(channel);
            SocketChannelMonitor.this.channelsCreated.incrementAndGet();
        }

        public void onClusterClose(EventLoopGroup eventLoopGroup) {
            eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).syncUninterruptibly();
        }
    };
    public static Predicate<SocketChannel> openChannels = new Predicate<SocketChannel>(){

        public boolean apply(SocketChannel input) {
            return input.isOpen();
        }
    };
    private static Comparator<SocketChannel> BY_REMOTE_ADDRESS = new Comparator<SocketChannel>(){

        @Override
        public int compare(SocketChannel t0, SocketChannel t1) {
            assert (t0 != null && t0.remoteAddress() != null);
            assert (t1 != null && t1.remoteAddress() != null);
            return t0.remoteAddress().toString().compareTo(t1.remoteAddress().toString());
        }
    };

    @Override
    public void run() {
        try {
            this.report();
        }
        catch (Exception e) {
            logger.error("Error countered.", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public NettyOptions nettyOptions() {
        return this.nettyOptions;
    }

    public void reportAtFixedInterval(int interval, TimeUnit timeUnit) {
        this.executor.scheduleAtFixedRate(this, interval, interval, timeUnit);
    }

    public void report() {
        this.report((Predicate<SocketChannel>)Predicates.alwaysTrue());
    }

    public void report(Predicate<SocketChannel> channelFilter) {
        if (logger.isDebugEnabled()) {
            Iterable<SocketChannel> channels = this.matchingChannels(channelFilter);
            Iterable open = Iterables.filter(channels, openChannels);
            Iterable closed = Iterables.filter(channels, (Predicate)Predicates.not(openChannels));
            logger.debug("Channel states: {} open, {} closed, live {}, total sockets created (including those that don't match filter) {}.", new Object[]{Iterables.size((Iterable)open), Iterables.size((Iterable)closed), Iterables.size(channels), this.channelsCreated.get()});
            if (logger.isTraceEnabled()) {
                logger.trace("Open channels {}.", (Object)open);
                logger.trace("Closed channels {}.", (Object)closed);
            }
        }
    }

    public Collection<SocketChannel> openChannels(InetSocketAddress ... addresses) {
        return this.openChannels(Arrays.asList(addresses));
    }

    public Collection<SocketChannel> openChannels(final Collection<InetSocketAddress> addresses) {
        ArrayList channels = Lists.newArrayList(this.matchingChannels(new Predicate<SocketChannel>(){

            public boolean apply(SocketChannel input) {
                return input.isOpen() && input.remoteAddress() != null && addresses.contains(input.remoteAddress());
            }
        }));
        Collections.sort(channels, BY_REMOTE_ADDRESS);
        return channels;
    }

    public Iterable<SocketChannel> matchingChannels(Predicate<SocketChannel> channelFilter) {
        return Iterables.filter((Iterable)Lists.newArrayList(this.channels), (Predicate)Predicates.and((Predicate)Predicates.notNull(), channelFilter));
    }
}

